<?php

namespace App\Masomwetu\Scholar;

use Illuminate\Database\Eloquent\Model;
use App\Masomwetu\Scholar\Enfant;
use App\Masomwetu\Scholar\MsClasse;
use App\Masomwetu\Scholar\MsInscription;
use App\Masomwetu\Scholar\StatusEnfant;
use App\Masomwetu\Scholar\MsEleveDeroger;
use App\Masomwetu\Scholar\MsAnneeScolaire;
use App\Masomwetu\Allocation\EmpruntMateriel;

use App\Masomwetu\Payment\MpFraisPaiement;
use App\Masomwetu\Payment\MpFraisPaiementExpetionnel;
use App\Masomwetu\Disciplinary\MdCommentaire;
use App\Masomwetu\Disciplinary\MdRetard;
use App\Masomwetu\Disciplinary\MdAbsence;
use App\Masomwetu\Disciplinary\MdPresence;
use App\Masomwetu\Disciplinary\MdEleveRenvoyer;
use App\Masomwetu\Report\MrCote; 

use App\Masomwetu\Scholar\MsPromotion;
use App\Masomwetu\Scholar\Tuteur; 
use App\Masomwetu\Scholar\ParentEnfant; 
use App\Masomwetu\School\Religion; 
use App\Masomwetu\School\DossierEnfant; 
use App\Masomwetu\School\Ecole;
class MsEleve extends Model
{
    //
		protected $table = "bulletin_ms_eleves";
		protected $guarded = [];
		public $timestamps = true;

		public function getEtatAttribute(){
			//dd($this);
			if(!isset($this->attributes['etat']))return null;
			return (!in_array($this->attributes['etat'],['',null,'0000-00-00','Actif']))?('Abandon:'.$this->attributes['etat']):'Actif';
		}

		public function enfant(){
			return $this->belongsTo(Enfant::class);
		}

		public function msClasse(){
			return $this->belongsTo(MsClasse::class);
		}
		public function ecole(){
			return $this->belongsTo(Ecole::class);
		}

		public function msInscription(){
			return $this->belongsTo(MsInscription::class);
		}

		public function statusEnfant(){
			return $this->belongsTo(StatusEnfant::class);
		}

		public function mpFraisPaiements(){
			return $this->hasMany(MpFraisPaiement::class);
		}

		public function mpFraisPaiementExpetionnels(){
			return $this->hasMany(MpFraisPaiementExpetionnel::class);
		}

		public function mdCommentaires(){
			return $this->hasMany(MdCommentaire::class);
		}

		public function mdRetards(){
			return $this->hasMany(MdRetard::class);
		}

		public function mdAbsences(){
			return $this->hasMany(MdAbsence::class);
		}
		public function mdPresences(){
			return $this->hasMany(MdPresence::class);
		}

		public function mdEleveRenvoyers(){
			return $this->hasMany(MdEleveRenvoyer::class);
		}

		public function mrCotes(){
			return $this->hasMany(MrCote::class);
		}
		public function msEleveDerogers(){
			return $this->hasMany(MsEleveDeroger::class);
		}
		public function empruntMateriels(){
			return $this->hasMany(EmpruntMateriel::class);
		}

		
		public function msPromotion(){
			return $this->belongsTo(MsPromotion::class);
		}

		public function tuteur(){
			return $this->belongsTo(Tuteur::class);
		}
		public function parentEnfant(){
			return $this->belongsTo(ParentEnfant::class);
		}

		public function religion(){
			return $this->belongsTo(Religion::class);
		}
		public function dossierEnfants(){
			return $this->hasMany(DossierEnfant::class);
		}
		public function msAnneeScolaire(){
			return $this->belongsTo(MsAnneeScolaire::class);
		}
}
