<?php

namespace App\Imports;

use App\Config\MsPromotion;
use Maatwebsite\Excel\Concerns\ToModel;
use App\Masomwetu\Scholar\MsClasse;
use App\Masomwetu\Report\MrCours;
use App\Masomwetu\Report\MrCoursPromotion;
use \App\Masomwetu\Payment\MpFraisPaiement;
use \App\Masomwetu\Payment\MpFrais;
use \App\Masomwetu\Payment\MpRecu;
use \App\Masomwetu\Payment\MpFraisClasse;
use \App\Masomwetu\Scholar\MsEleve;
use \App\Http\Controllers\MPaymentController;
use \App\Config;
use App\Masomwetu\Payment\MpFraisPaiementExpetionnel;

class PaiementImport implements ToModel
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
	public $erreur;
	public function __construct(){
		$this->user_id = \Auth::user()->id;
		$this->erreur = [];
		$this->annee_id = Config::getIdAnnee();
		$this->MPaymentController = new MPaymentController;
	}
	public function to_date($d){
		if(is_numeric($d)){
			$date = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($d)->format('Y-m-d');
			return $date;
		}
		$dd = explode('/',$d);
		if(count($dd)==3)
			return "$dd[2]-$dd[1]-$dd[0]";
		
		$dd = explode('-',$d);
		if(count($dd)==3)
			return $d;
		
		return false;
		
	}
	private $user_id=false;
	private $idFrais = [];
	function create_recu($ms_eleve_id,$num_recu=0,$obs=null){
		$num_recu=sprintf('%04.d',$num_recu).'-'.date('m-y');//.'-'.date('m-y')
		$datas = [
			'date_recu'=>date('Y-m-d H:i:s'),
				// 'num_recu'=>$num_recu,
				'ms_eleve_id'=>$ms_eleve_id,
				// 'montant_recu_usd'=>$montant_recu_usd,
				// 'montant_recu_cdf'=>$montant_recu_cdf,
				// 'montant_recu'=>$montant_recu,
				'user_id'=>$this->user_id,
				'ms_annee_scolaire_id'=>Config::getIdAnnee(),
				'Observation'=>$obs
			];
			$mprecu = MpRecu::create($datas);
			$mprecu->num_recu = sprintf('%06.d',$mprecu->id).'-'.date('-m-y');
			$mprecu->save();
			return $mprecu;
	}

    public function model(array $row)
    {
		if($row[0]=='ID'){
			$this->idFrais = $row;
	  		//$this->user_id = \Auth::user()->id;
			//dd($this->idFrais);
		}
	  $id_eleve = (int)$row[0];
	  $eleve = MsEleve::where('id',$id_eleve)->first();
	  $num_r = "";
	  
	  /* if($d = $row[0]){
		//$date = Carbon/Carbon::instance($row[0]);
		$date = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($d)->format('Y-m-d');
	  } */
	  //$compte = 1; // $this->trouver_classe_comptable($id_frais_classe, $date ); //
        
		$return = [];
		if($eleve){
			for($i=3;$i<count($this->idFrais);$i+=4){
				// trouver l'id du frais a payer
				$r = $this->traiter_frais_indice($eleve,$row,$i);
				
			}

			if(count($return)){
				// $recu = $this->create_recu($id_eleve);$ms_eleve_id=null
				$n_recu = '';//$row[1];//$row[0];//'';//
				$recu = $this->MPaymentController->create_recu($id_eleve,$date,$n_recu.' !! ');
				foreach($return as $p){
					if($p)$p->update(['mp_recu_id'=>$recu->id]);
				}
			}
		}
		else {
			$row[] = "ELEVE NON TROUVE ";
			$this->erreur[] = $row;
		}	
		return null;
    }

	private function trouver_frais_apayer($ms_classe_id,$i){
		if($this->idFrais[1]=="Tous"){
			$id_frais = (int)$this->idFrais[$i+1];
			$frais_apayer = MpFraisClasse::with('mpFrais')->where('mp_frais_id',$id_frais)->where('ms_classe_id',$ms_classe_id)->where('ms_annee_scolaire_id',$this->annee_id)->get()->first();
			//if(!$frais_apayer)dd($frais_apayer,$id_frais,$this->annee_id,$ms_classe_id);
			$id_frais_classe = $frais_apayer?$frais_apayer->id:false;
		}
		else{
			$id_frais_classe = (int)$this->idFrais[$i+1];
			$frais_apayer = MpFraisClasse::with('mpFrais')->find($id_frais_classe);
		}
		return $frais_apayer;
	}

	// traite chaque frais d'un eleve a un indice donne
	private function traiter_frais_indice($eleve,$row,$row_indice_frais){
		$i = $row_indice_frais;
		$frais_apayer = $this->trouver_frais_apayer($eleve->ms_classe_id,$i);
        
		if(!is_null($frais_apayer) and $frais_apayer !='null' ){
		    if(!is_object($frais_apayer))dd('---',$frais_apayer,$eleve,$eleve->ms_classe_id,$i);
		    try{
		    $montant_usd =$frais_apayer->taux;
    		}catch(\Exception  $e){
    		    dd($frais_apayer,is_null($frais_apayer),is_object($frais_apayer));
    		}
			$montant_usd = (int)$row[$i];
			$montant_cdf = (int)$row[$i+1];
			$num_recu =  (int)$row[$i+2];
			$date = ($row[$i+3]??false)?$this->to_date($row[$i+3]):date("Y-m-d");

			$r = $this->traiter_paiement_frais_i($eleve,$frais_apayer,$montant_usd,$montant_cdf,$num_recu,$date);
			if($r['rest']>0)// si il y a un reste on peut le payer au frais suivant
			{
				$frais_apayer = $this->trouver_frais_apayer($eleve->ms_classe_id,$i+4);
				//try{
    		    //$montant_usd =$frais_apayer->taux;
        		//}catch(\Exception  $e){
        		//    dd('***',$frais_apayer,is_null($frais_apayer),is_object($frais_apayer));
        	    //}
        		if(!$frais_apayer){
        		    $row[] = "frais (".($i+4).") non aligne dans la classe ".$eleve->enfant->nom;
			        $this->erreur[] = $row;
        		    return false;
        		}
				$r = $this->traiter_paiement_frais_i($eleve,$frais_apayer,0,$r['rest'],$num_recu,$date);
				if($r['rest']>0){
					$frais_apayer = $this->trouver_frais_apayer($eleve->ms_classe_id,$i+8);
					$r = $this->traiter_paiement_frais_i($eleve,$frais_apayer,0,$r['rest'],$num_recu,$date);
				}
			}
			return $r;
		}
		return false;
	}
	
	// effeectuer le paiement concret d'un eleve
	private function traiter_paiement_frais_i($eleve,$frais_apayer,$montant_usd,$montant_cdf,$num_recu,$date){
		$rest = 0;
		$montant_usd_en_fr = $montant_usd*$frais_apayer->taux;
		
		$montant_cdf_usd = $montant_cdf + $montant_usd_en_fr;
		//dd($montant_cdf_usd,$montant_cdf,$num_recu);
		if(!$montant_cdf_usd)
			return false;

		$result = MpFraisPaiement::groupBy('ms_eleve_id','mp_frais_classe_id')
			->selectRaw('sum(montant_payer) as sum')
			->where('mp_frais_classe_id',$frais_apayer->id)
			->where('ms_eleve_id',$eleve->id)
			->get();
		$total_payer = count($result)?$result[0]->sum:0;

		$montant_du_frais = (double)$frais_apayer->montant;
		$compte = $frais_apayer->compte;
		$rest_a_payer = $montant_du_frais - $total_payer; // 
		if($rest_a_payer){
			$monnaie = $frais_apayer->montant_usd?'usd':'cdf';

			$taux = $frais_apayer->taux;
			$montants = $this->calculer_montant($montant_cdf,$montant_usd,$montant_du_frais ,$total_payer,$monnaie,$taux);
			//dd($row,$frais,"$montant_cdf,$montant_usd,$montant_du_frais ,$total_payer,$monnaie,$taux,$rest_a_payer",$montants);
			$rest = $montants['rest'];

			if($rest>0 ){		
			    $id_eleve=$eleve->id;
				$user_id = \Auth::user()->id;
				$data = [
					'ms_eleve_id'=>$id_eleve,
					'mp_frais_classe_id'=>$frais_apayer->id,
					'montant_fixer'=>$montants['montant']+$rest,
					'raison'=>"CAS D'UNE INSCRIPTION",
					'user_id'=>$user_id,
				];
				$fc = MpFraisPaiementExpetionnel::firstOrcreate(['ms_eleve_id'=>$id_eleve,'mp_frais_classe_id'=>$frais_apayer->id],$data);
				if(!$fc->waRecentlyCreated)
					$fc->update($data);	
				$montants['montant'] = $montants['montant']	+$rest;
				if($montants['montant_cdf'])
					$montants['montant_cdf'] = $montants['montant_cdf']	+$rest;
				if($montants['montant_usd'])
					$montants['montant_usd'] = $montants['montant_usd']	+$rest/2000;

				//$row[] = "A paye $rest de trop pour ".$frais_apayer->mpFrais->frais;			
				//$this->erreur[] = $row;
				$rest = 0;
			}
			$mp = MpFraisPaiement::create(['ms_eleve_id'=>$eleve->id
				,'mp_frais_classe_id'=>$frais_apayer->id
				,'montant_payer'=>$montants['montant']
				,'montant_payer_cdf'=>$montants['montant_cdf']
				,'montant_payer_usd'=>$montants['montant_usd']
				,'payer_le'=>$date
				,'compte_id'=>$compte
				,'user_id'=>$this->user_id
				,]);
			if($num_recu){							
				$recu = $this->MPaymentController->create_recu($eleve->id,$date,$num_recu.' !! ');
				$mp->update(['mp_recu_id'=>$recu->id]);
			}
			else $return[] = $mp;
			if($frais_apayer->mpFrais->frais=="INSCRI-REINSC"){
				$el = MsEleve::find($eleve->id);
				$el->update(['inscrit_le' => $date]);
			}
		}
		else if($montant_cdf_usd){
			$row[] = "A deja paye ".$eleve->enfant->nom." ".$eleve->enfant->postnom." ".$eleve->id." -- ".$frais_apayer->mpFrais->frais;
			$this->erreur[] = $row;
		}
		return compact('return','row','rest');		
	}
	
	private function calculer_montant($montant_cdf,$montant_usd,$montant_du_frais ,$total_payer,$monnaie,$taux){
		$rest = 0;
		$montant_usd_en_fr = $montant_usd*$taux;
		$montant_cdf_usd = $montant_cdf + $montant_usd_en_fr;
		$rest_a_payer = $montant_du_frais - $total_payer; // 

		if($montant_cdf_usd){
			if($montant_cdf_usd > $rest_a_payer){
				$m = $this->deduire_les_montant_a_payer($montant_cdf_usd,$montant_cdf,$montant_usd,$montant_usd_en_fr ,$rest_a_payer,$taux,$monnaie);
				$montant_cdf = $m['montant_cdf'];
				$montant_usd = $m['montant_usd'];
				$rest 		 = $m['rest'];
				$montant 	 = $rest_a_payer;
				$msg="Montant trop grand ".chiffre($montant_cdf_usd)." CDF !!!";
				
			}
			else  $montant = $montant_cdf_usd;					
		}
		else {
			$montant = $rest_a_payer;
			// determiner la monnaie prise en charge
			if($monnaie == 'usd'){
				$montant_usd = (int)($montant / $taux);
				$montant_cdf = $montant - ($montant_usd * $taux);
			}						
			else $montant_cdf = $montant ;
		}
		return compact('montant_cdf','montant_usd','montant','rest');
	}
  
	private function preparer_montant_en_usd($montant_cdf,$montant_usd,$montant_usd_en_fr ,$rest_a_payer,$taux){
		// si l'usd est > au reste_a_payer alors on paye le tout en usd et on recalcule le reste
		if($montant_usd_en_fr >= $rest_a_payer){
			$montant_usd = (int)($rest_a_payer /$taux) ; // on concertie le reste a payer en usd
			$peu = $rest_a_payer % $taux; // ce qui ne peut etre converti en usd (on le prend en cdf)
			$montant_cdf = $peu;
		}
		else { // sinon alors on garde ca premierement et on voit combien rajouter en cdf
			$complement = $rest_a_payer - $montant_usd_en_fr; // donc dans le reste a payer on retire les usd(cdf) et le reste est suppose etre le cdf a rajouter
			// si il y'a des cdf
			if($montant_cdf >= $complement)
				$montant_cdf = $complement;
			else $montant_cdf = $montant_cdf; // sinon on rajouter le tout
		}
		return compact('montant_cdf','montant_usd');
	}

	private function preparer_montant_en_cdf($montant_cdf_usd,$montant_cdf,$montant_usd,$montant_usd_en_fr ,$rest_a_payer,$taux){
		// si le cdf est > au reste_a_payer alors on paye le tout en cdf et on recalcule le reste
		if($montant_cdf >= $rest_a_payer){
			$montant_cdf =  $rest_a_payer ; // on paie directement
			$montant_usd = 0;
		}
		else { // sinon alors on garde ca premierement et on voit combien rajouter en usd
			$complement = $rest_a_payer - $montant_cdf; // donc dans le reste a payer on retire les cdf et le reste est suppose etre converti en usd et rajouter a la somme
			// si il y'a des cdf
			if($montant_usd_en_fr >= $complement){
				$montant_usd = (int)( $complement / $taux);
				$peu = $complement % $taux; // ce qui ne peut etre converti en usd (?????)
				if($peu>0){
					// on doit rappler la fonction en priorisant les usd
					return $this->deduire_les_montant_a_payer($montant_cdf_usd,$montant_cdf,$montant_usd,$montant_usd_en_fr ,$rest_a_payer,$taux,'usd');
				}
			}
			else $montant_usd = $montant_usd; // sinon on rajouter le tout
		}
		return compact('montant_cdf','montant_usd');
	}

	// $frais_apayer->montant_usd
	private function deduire_les_montant_a_payer($montant_cdf_usd,$montant_cdf,$montant_usd,$montant_usd_en_fr ,$rest_a_payer,$taux,$monnaie='usd'){
		// si on doit payer en usd
		if($monnaie=='usd'){
			$r = $this->preparer_montant_en_usd($montant_cdf,$montant_usd,$montant_usd_en_fr ,$rest_a_payer,$taux);
		}
		// et si on doit payer en cdf
		else $r = $this->preparer_montant_en_cdf($montant_cdf_usd,$montant_cdf,$montant_usd,$montant_usd_en_fr ,$rest_a_payer,$taux);
		$r['rest'] = $montant_cdf_usd - $rest_a_payer;
		return $r;
	}
	
    
}
