<?php

namespace App\Imports;

use App\Masomwetu\Scholar\MsEleve;
use App\Masomwetu\Scholar\Enfant;
use App\Masomwetu\Scholar\Tuteur;
use App\Masomwetu\Scholar\MsInscription;
use \App\Masomwetu\Scholar\MsClasse;
use Maatwebsite\Excel\Concerns\ToModel;
// use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Concerns\WithBatchInserts;
use Maatwebsite\Excel\Concerns\WithChunkReading;

use Maatwebsite\Excel\Concerns\WithHeadingRow;
use \App\Config;

class EleveResultTestImport implements ToModel, WithBatchInserts, WithChunkReading, WithHeadingRow
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
	*/
	public $error = false;
	public function __construct(){
		$this->error = [];
	}
	
    public function model(array $row){
		$mat = $row['matricule']??null;
		$p = $row['pourcentage']??null;
		if($mat and $p){			
			$id_annee = \App\Config::getIdAnnee();
			$enfant = Enfant::with('msInscriptions.msPromotion')
				->whereHas('msInscriptions.msPromotion',function($q)use($id_annee){return $q->where('ms_annee_scolaire_id',$id_annee);})
				->where('matricule',$mat)->get()->first();
			if($enfant){
				$insc = $enfant->msInscriptions->filter(function($v, $i) use($id_annee){ return $v->msPromotion->ms_annee_scolaire_id == $id_annee; })->first();
				$insc->test_pourcentage = $p;
				$insc->save();
			}
			else $this->error[] = implode(', ',$row);
		}
		else $this->error[] = implode(', ',$row);
		return null;
    }
	
    public function batchSize(): int
    {
        return 1000;
    }
		public function chunkSize(): int
    {
        return 1000;
    }
}

