<?php

namespace App\Imports;

use App\Masomwetu\Scholar\MsEleve;
use App\Masomwetu\Scholar\Enfant;
use App\Masomwetu\Scholar\Tuteur;
use App\Masomwetu\Scholar\MsInscription;
use \App\Masomwetu\Scholar\MsClasse;
use Maatwebsite\Excel\Concerns\ToModel;
// use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Concerns\WithBatchInserts;
use Maatwebsite\Excel\Concerns\WithChunkReading;

use Maatwebsite\Excel\Concerns\WithHeadingRow;
use \App\Config;

class EleveImport implements ToModel, WithBatchInserts, WithChunkReading, WithHeadingRow
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
	*/
	public $error = false;
	public function __construct($classe){
		$this->classe_inside = false;
		$this->ecole_id = Config::getEcoleId();
		$this->annee_id = Config::getIdAnnee();
		$this->error = false;
		if($classe){
			$this->ms_promotion_id = $classe->ms_promotion_id;
			$this->ms_classe_id = $classe->id;
		}
		else {
			$this->classe_inside = MsClasse::with('msPromotion')->where('ecole_id',$this->ecole_id)->get();
		}
	}
	
	public function to_date($d){
		if(is_numeric($d)){
			$date = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($d)->format('Y-m-d');
			return $date;
		}
		$dd = explode('/',$d);
		if(count($dd)==3)
			return "$dd[2]-$dd[1]-$dd[0]";
		
		$dd = explode('-',$d);
		if(count($dd)==3)
			return $d;
		
		return false;
		
	}
	
    public function model(array $row)
    {
		 //dd($row);
		// if(!isset($row['matricule']) or empty($row['matricule']))
			// return null;
		// trouver la classe de l'enfant
		if($this->classe_inside and ($classe = $this->classe_inside->where('classe',trim($row['classe'])))){
			// $this->classe_inside->where('classe',$row['classe'])->first();
			$classe = $classe->first();
			if(!($classe->ms_promotion_id??false)){
				$this->error = $row;
				return null;
			}
			$this->ms_promotion_id = $classe->ms_promotion_id;
			$this->ms_classe_id = $classe->id;
		}
		// else return null;

		try{
			$mat = $row['matricule']??null;
			$nom = $row['nom']??'';
			$post = $row['post_nom']??($row['postnom']??'');
			$values = [
				'nom'=>$nom,
				'postnom'=>$post,
				'prenom'=>$row['prenom']??'',
				'genre'=>$row['genre']??'M',
				'datenaiss'=> $this->to_date($row['datenaiss']??''),//$row['datenaiss']??'??/??/????',//isset($row['datenaiss'])?
				'lieunaiss'=>$row['lieunaiss']??'-',
			];
			if($mat){
				$enfant = Enfant::firstOrCreate(['matricule'=>$mat],$values);
			}else 
				$enfant = Enfant::create($values);
			// ajout du matricule
			if(!$enfant->matricule){
				$enfant->update(['matricule'=>($nom[0]??'-').($post[0]??'-').sprintf('%03.d',$enfant->id).'-'.date('y')]);
				//$enfant->update(['matricule'=>'E'.($nom[0]??'-').($post[0]??'-').sprintf('%06.d',$enfant->id).'-'.date('y')]);
			}

		$tuteur_id = NULL;
		if((isset($row['telephone']) and !empty($row['telephone'])) or (isset($row['tuteur']) and !empty($row['tuteur']))){
			$tut = $row['tuteur']??("Tuteur de ".$row['nom']);
			$adr = $row['adresse']??'-';
			$tel = $row['telephone']??'';
			if( !empty($tel) and !empty($row['tuteur']))
				$tuteur = Tuteur::firstOrCreate(['telephone'=>$tel,'nom_tuteur'=> $tut],['adresse'=> $adr]);
			else if(!empty($row['tuteur']))
				$tuteur = Tuteur::firstOrCreate(['nom_tuteur'=> $tut],['adresse'=> $adr,'telephone'=>$tel]);
			else if(!empty($tel) )
				$tuteur = Tuteur::firstOrCreate(['telephone'=>$tel],['adresse'=> $adr,'nom_tuteur'=> $tut]);
			$tuteur_id = $tuteur->id;
		}
		
		
		$dateinsc = ($row['dateinsc']??false)?$this->to_date($row['dateinsc']):date('Y-m-d');
		//$montant = $row['montantinsc']??0;
		$pro_ecole = $row['ecoleprov']??'N.S.';
		$pro_classe = $row['classeprov']??'N.S.';
		$pourcentage = $row['pourcentage']??'N.S.';
		$datas = [
		];
		
		$insc = MsInscription::firstOrCreate(['enfant_id'=>$enfant->id,'ms_promotion_id'=>$this->ms_promotion_id],$datas);
		if(!$insc->wasRecentlyCreated)
			$insc->update($datas);
		
		$datas = [
			'inscrit_le'=>$dateinsc
			//,'montant'=>(int)$montant
			,'pro_classe'=>$pro_classe
			,'pro_ecole'=>$pro_ecole
			,'pourcentage'=>$pourcentage,
			'tuteur_id'=>$tuteur_id,
			'classer'=>true,
			'ms_classe_id'=>$this->ms_classe_id,
			'ms_promotion_id'=>$this->ms_promotion_id,
			'etat'=>'Actif',
			'status_enfant_id'=>null,
		];
		
		$eleve = MsEleve::firstOrCreate([
			'enfant_id'=>$enfant->id,
			'ecole_id'=>$this->ecole_id,
			'ms_annee_scolaire_id'=>$this->annee_id]
			,$datas);
		if(!$eleve->wasRecentlyCreated)
			$eleve->update($datas);
		
		// dd($insc);
		// return new MsEleve($datas);
		return null;	
		}catch(QueryException  $e){
			return null;
		}
    }
	
    public function batchSize(): int
    {
        return 1000;
    }
		public function chunkSize(): int
    {
        return 1000;
    }
}

