<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Enregistrement\TestEnregistrement;
use App\Http\Controllers\MyDataTableController;

use App\Masomwetu\Sys\User; 


use Illuminate\Support\Facades\Auth; 

class TestController extends Controller
{
	public function __construct(){
		$urlSearch = route('enregistrement.test.filter');
		$from = "test_enregistrements";
		$fields = ['id'=>'SUP','nom'=>"NOM", 'postnom'=>"POSTNOM", 'prenom'=>"PRENOM", 
		'lieunaiss'=>"NE A", 'datenaiss'=>"NE LE", 'genre'=>"SEXE",
		 'annee_scolaire'=>"ANNEE SCOL"
		 , 'result_math'=>"MATH"
		 , 'result_francais'=>"FRA"
		 , 'code'=>"CODE"
		 , 'a_reussi'=>"RESLT"
		 , '-'=>"MEN."
		 , 'created_at'=>"ENRE. LE"];
		 
		$this->myDataTable = new MyDataTableController;
		$this->myDataTable->setExceptCreate([ '-', 'id', 'created_at','result_math', 'result_francais','a_reussi']);
		$this->myDataTable->setExceptOnlineEditableTd([ '-', 'id', 'created_at','a_reussi','genre', 'lieunaiss','datenaiss']);
		$this->myDataTable->setExceptListe([ 'created_at']);
		$this->myDataTable->setExceptSearch([ '-']);
		$this->myDataTable->create($urlSearch,$from,$fields);
		// la table de modification des onlien editable td
		$this->myDataTable->editable_table=78;
		$this->myDataTable->delete_url=route('enregistrement.test.supprimer');
		
		
	}
	public function index(Request $req){
		
		$myDataTable = $this->myDataTable;
		//if($req->method()=='GET')
		$user_c = \Auth::user() ? \App\User::find(\Auth::user()->id):false;
		if($user_c and !$user_c->user_acces_to_zone('MENU-INSC-TESTE-ADD')){	
			$this->myDataTable->create_rule = false;	
			$this->myDataTable->delete_rule = false;
		}// dd( \Auth::user(),$user_c);
		return $this->addUser('enregistrement_test.index',compact('myDataTable'));		
		
	}

	public function extraire(Request $req){
		$liste = TestEnregistrement::all();
		return 	\Excel::download((new \App\Exports\TesteEnregistrementExport)
		->forListe($liste), 'enregistrement-test.xlsx' );
					
		
	}

	public function save(Request $request){// 		
		$this->myDataTable->setRulesData(['*'=>'','nom'=>'required','postnom'=>'required','prenom'=>'required']);
		$donneeAretier = ['-'=>['created_at','id']];
		$datas_rules = $this->myDataTable->dataToSave($request,$donneeAretier);
		
		$result = AjaxValidator::validate($datas_rules['datas'],$datas_rules['rules']);
		if($result!==true)
			return $result;
		return TestEnregistrement::create($datas_rules['datas']);
	}

	public function supprimer($id){
		TestEnregistrement::destroy($id);
		return ['result'=>true];
	}

	public function search(Request $req){
		return $this->myDataTable->filter($req);
	}

	public function getData(Request $req,$s){
		$listee = session($s);
		return $listee->filter($req);
	}
	
	public function getDataToExcel(Request $request,$s='',$nom=''){
		if($nom=='')
			$nom = 'Export_'.date('Y-m-d H-i-s').'.xlsx';
		$listee = session($s);
		$tab_reqs = $listee->select_request($request);

		$datas = \DB::select($tab_reqs['req']);
		$fields_object = $tab_reqs['object'];
        $table = $listee->htmlTable('f','');
		return 	\Excel::download((new \App\Exports\DataTableExport)->forData($datas,$fields_object,$table ), $nom );
	}

	public function deleteData(Request $req,$s='',$id=0){
		$listee = session($s);
		$r = $listee->deleteData($id);
		return ['result'=>true,$r];
	}
	

	public function get_data_table(Request $req,$s){
		$listee = session($s);
		return $listee->filter($req);
	}
	public function del_data_table(Request $req,$s='',$id=0){
		$listee = session($s);
		$r = $listee->deleteData($id);
		return ['result'=>true,$r];
	}

	public function selectData($cle=''){
		$d = \DB::select("select id, name as text from users where name like '%$cle%' ");
		return $d;
	}
}
