<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class SocketServerController extends Controller
{ 
	// set some variables
	$host = "127.0.0.1";
	$port = 55555;
	$spawn = $socket = null;
	public function start(){
		// don't timeout!
		set_time_limit(0);
		// create socket
		$this->socket = socket_create(AF_INET, SOCK_STREAM, 0) or die("Could not create socket\n");
		// bind socket to port
		try{
			$result = socket_bind($this->socket, $this->host, $this->port) or die("Could not bind to socket\n");
			// start listening for connections
			$result = socket_listen($this->socket, 3) or die("Could not set up socket listener\n");
			$this->accept();
			$this->read();
			$this->write('Bienvenu');	
			return true;
		}
		catch(ErrorException $e){
			return false;
		}
	}
	

	// ===========================================================================================
	public function accept(){
		// accept incoming connections
		// spawn another socket to handle communication
		$this->spawn = socket_accept($this->socket) or die("Could not accept incoming connection\n");
	}
	
	public function read(){
		// read client input
		$input = socket_read($this->spawn, 1024) or die("Could not read input\n");
		// clean up input string
		$input = trim($input);
		echo "Client Message : ".$input;
		// reverse client input and send back
		$output = strrev($input) . "\n";
	}
	
	public function write($output){
		socket_write($this->spawn, $output, strlen ($output)) or die("Could not write output\n");
	}
	
	// ============================================================================================
	// close sockets
	private function close(){		
		socket_close($this->spawn);
		socket_close($this->socket);
	}

	
	
}