<?php


namespace App\Http\Controllers;


use Illuminate\Http\Request;

use App\Config;
use App\Masomwetu\School\Personnel;
use App\Masomwetu\School\McFonction;
use App\Masomwetu\Presence\Pointage;
use App\Masomwetu\Presence\JustifAbsence;
use App\Masomwetu\Presence\JourOuvrable;
use App\Masomwetu\Presence\PrevisionArriveeSortie;

class PersonnelPresenceController extends Controller
{
    
	private $ecole_id = 0;
	private $req_rapport = "";
	public function __construct(){
	    $this->id_ecole = \App\Config::getEcoleId();
	    $this->req_rapport = "
    	SELECT `a`.`id` AS `id`,`a`.`noms` AS `noms`,`j`.`justification` AS `justification`,`j`.`abreviation` AS `abreviation`,
    	month( `p`.`jour`) AS `mois`,
    	year(`p`.`jour`) AS `annee`,
    
    	`p`.`jour` AS `jour`,`p`.`arrivee`,`p`.`sortie`,
    	`p`.`arrivee_prevue`,`p`.`sortie_prevue`,a.image
    	,TIME_FORMAT(`p`.`arrivee`, '%Hh:%i')arrivee_f
    	,TIME_FORMAT(`p`.`sortie`, '%Hh:%i')sortie_f
    	FROM personnels a 
    	LEFT JOIN `pointages` p on a.id = p.personnel_id  __AND__
    	LEFT JOIN `justif_absences` j on p.justif_absence_id = j.id
    	LEFT JOIN `jour_ouvrables` jo on jo.jour_ouvert = p.jour
    	where a.ecole_id = $this->id_ecole 
    	";
	}

    public function index()
    {
		//dd(5);
		$this->justifier_les_absences_du(date('w'),date('Y-m-d'));
		return $this->addUser('personnel_presence.accueil');
    }

    public function save_presence(Request $request){
		
		$message = "";
		
		$t = explode(' ',$request->id_personnel);
		
		$id_personnel = $t[0];
		$date_expi = date("Y-m-d");//isset($t[1])?$t[1]:false;
		return $this->save_presence_exec($id_personnel,$date_expi);
	}
	
    private function save_presence_exec($id_personnel,$date_expi){
		$agent = Personnel::with('agents.mcFonction')->where('id', $id_personnel)->first();
		
		$jour = date('Y-m-d');
		$action = "arrivee";
		
		$result='error';//,(time() + 3600)
		$heure = date('H:i:s');
		// dd($heure);
		if($agent and $date_expi and $date_expi >= $jour){
			$default_hr_arrivee_prevue = Config::getParamVal('HEURE-ARRIVEE-AGENT')??'08:30:00';// "08:00:00";
			$default_hr_sortie_prevue = Config::getParamVal('HEURE-SORTIE-AGENT')??'16:30:00';// "08:00:00";
			$jour_semaine = date('w');
			$jo = JourOuvrable::firstOrCreate(['jour_ouvert'=>$jour],['heure_arrivee'=>$default_hr_arrivee_prevue,'heure_sortie'=>$default_hr_sortie_prevue]);
			
			// si le jour ouvrable vient d'etre ajoute, alors il faudra pointer toutes les personne dont les absence sont justifiee
			if($jo->wasRecentlyCreated){
				//$this->justifier_les_absences_du($jour_semaine,$jour);
				// dd($jour_semaine,$jour);
			}
			// else dd("nono",$jo);
			$charge_hr = \DB::table("pointage_heures_arrivee_sorties")->where('personnel_id',$id_personnel)->where('jour_semaine',$jour_semaine)->first();
			
			$prevision = PrevisionArriveeSortie::with('justifAbsence')->where('personnel_id',$id_personnel)->where('jour_semaine',$jour_semaine)->first();
			if( !($jo->wasRecentlyCreated) and $prevision ){
				$default_hr_arrivee_prevue = $prevision->heure_arrivee;
				$default_hr_sortie_prevue = $prevision->heure_sortie;
			}
			else if($charge_hr){
				$default_hr_arrivee_prevue = $charge_hr->heure_arrivee;
				$default_hr_sortie_prevue = $charge_hr->heure_sortie;
			}
			
			
			//dd($prevision);
			if($prevision){
				$default_hr_arrivee_prevue = $prevision->heure_arrivee;
				$default_hr_sortie_prevue = $prevision->heure_sortie;
			}
			
			// si sur la prevision il y a une justification d'absence on enregistre pas la presence
			if($prevision and $prevision->justif_absence_id){
				$message = "Erreur, Motif: <b>".$prevision->justifAbsence->justification."</b>"; //Votre prévision indique que vous êtes absent";
				$p = Pointage::firstOrCreate(['jour'=>$jour,'personnel_id'=>$prevision->personnel_id],['observation'=>$prevision->observation,'justif_absence_id'=>$prevision->justif_absence_id]);
				if( !($p->wasRecentlyCreated) ){
					$p->arrivee_prevue = '';
					$p->sortie_prevue = '';
					$p->arrivee = '';
					$p->sortie = '';
					$p->save();
				}
			}
			else{
				 $message = "Entrée marquée";
				$p1 = $p = Pointage::firstOrCreate(['jour'=>$jour,'personnel_id'=>$id_personnel],['arrivee'=>$heure,'sortie_prevue'=>$default_hr_sortie_prevue,'arrivee_prevue'=>$default_hr_arrivee_prevue]);
			//dd($aget,$prevision,$p);
				if( !($p->wasRecentlyCreated) ){
					if($p->justif_absence_id)
						$message = "Votre pointage indique: <b>".$p->justifAbsence->justification."</b>";//" prévision indique que vous êtes absent";
					else{
					    if($p->sortie ==''){
    						$p->sortie = $heure;
    						$p->save();
    						$result='success';
					    }
					    else $message = "Sortie déjà Enregistrée à ".$p->sortie;
					} 
					$action = "sortie";				
				}
				else $result='success';
				// dd($p1,$p);
				
			}
			
			
		}
		else{
			if(!$date_expi)
				$message = "Carte non valide!!! ";
			else if($date_expi > $jour)
			$message = "Votre carte a déjà expirée depuis $date_expi ";
			else $message = "Votre carte a déjà expirée ou non valide!!! ";
		} 
		// else $result='error';
		
		$tab_pointage = $this->donnee_pointage_agent($jour,$id_personnel);
		return compact('agent','result','heure','jour','action','message','tab_pointage');
	}
	
	public function donnee_pointage_agent($jour,$id_personnel){
	    
		
		$req = str_replace('__AND__',"", $this->req_rapport);
		$req = $req." AND a.id = '$id_personnel' and jour = '$jour'  ";
		// dd(echo $req);
		$tab_pointage=[
		    "arrivee"=>["hr_pr"=>"","hr_po"=>"","retard"=>"","avance"=>""],
		    "sortie"=>["hr_pr"=>"","hr_po"=>"","retard"=>"","avance"=>""],
		    "duree"=>""
		];
		if($pointage = \DB::select($req)){
		    $p = $pointage[0];
		    
		    $tab_pointage["arrivee"]["hr_pr"] = $p->arrivee_prevue;
		    $tab_pointage["sortie"]["hr_pr"] = $p->sortie_prevue;
		    $tab_pointage["arrivee"]["hr_po"] = $p->arrivee;
		    $tab_pointage["sortie"]["hr_po"] = $p->sortie;
		    
			$avance = diff_times($p->arrivee_prevue,$p->arrivee);
			if($avance[0]=='-')
		        $tab_pointage["arrivee"]["retard"] = substr($avance,1);
		    else $tab_pointage["arrivee"]["avance"] = $avance;
		    
			$tard = diff_times($p->sortie_prevue,$p->sortie);
			if($tard[0]=='-')
		        $tab_pointage["sortie"]["retard"] = substr($tard,1);
		    else $tab_pointage["sortie"]["avance"] = $tard;
		    
			$duree = diff_times($p->sortie,$p->arrivee);
			$tab_pointage["duree"] = $duree;
		}
		return $tab_pointage;
	}
	
	public function justification(Request $request){
		// 
		if($request->personnel_id and $request->justif_absence_id and $request->date_fin_validite){
			foreach($request->jour_semaine as $jour){
				$datas = [
					'personnel_id'=>$request->personnel_id,
					'jour_semaine'=>$jour,
					'heure_arrivee'=>$request->heure_arrivee,
					'heure_sortie'=>$request->heure_sortie,
					'observation'=>$request->observation,
					'justif_absence_id'=>$request->justif_absence_id,
					'date_fin_validite'=>($request->date_fin_validite??''),
					'date_debut_validite'=>($request->date_debut_validite??date('Y-m-d')),
				];
				$rules = [
					'personnel_id'=>'required',
					'jour_semaine'=>'required',
					'heure_arrivee'=>'required',
					'heure_sortie'=>'required',
					'observation'=>'',
					'justif_absence_id'=>'',
					'date_fin_validite'=>'',
					'date_debut_validite'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$previsionarriveesortie = PrevisionArriveeSortie::create($datas);			

			}
			my_flash("Enregistrement effecté avec succès");				
			return redirect()->back();
		}
			
        $annee_mois = date('Y-m');
        $ecole_id = \App\Config::getEcoleId();
		$pointages = Pointage::with('personnel','justifAbsence')
		    ->where("jour","LIKE","$annee_mois-%")
		    ->where("jour","LIKE","$annee_mois-%")
		    ->whereRaw("justif_absence_id is not null")
		    ->whereHas("personnel",function($q)use($ecole_id){return $q->where("ecole_id",$ecole_id);})
		    ->get()->sortByDesc('jour');
		$pointage = new Pointage;
        $previsionarriveesortie = new PrevisionArriveeSortie;
		$personnels = Personnel::where('ecole_id',$ecole_id)->get();
		$justifAbsences = JustifAbsence::all();
		$SEMAINE = ['','Lundi','Mardi','Mercredi','Jeudi','Vendredi','Samedi','Dimanche'];
        $previsionarriveesorties = PrevisionArriveeSortie::with('personnel','justifAbsence')->whereRaw("justif_absence_id is not null")
		    ->whereHas("personnel",function($q)use($ecole_id){return $q->where("ecole_id",$ecole_id);})->get(); 
		
		$tab = compact('previsionarriveesortie','pointage','personnels','justifAbsences','pointages','previsionarriveesorties','SEMAINE');
		// dd($tab);
		return $this->addUser('personnel_presence.justification',$tab);
	}
	
	public function justifier_les_absences_du($jour_semaine,$jour){					
		$prevs = PrevisionArriveeSortie::with('personnel')
		->where('jour_semaine',$jour_semaine)
		->where('justif_absence_id','<>',null)
		->where('date_fin_validite','>=',$jour)
		->orWhere('date_fin_validite',null)
		->where('jour_semaine',$jour_semaine)
		->where('justif_absence_id','<>',null)
		->get();
		//dd($prevs->toSql(['jour_semaine'=>$jour_semaine]),$prevs);				
		// $prevs = PrevisionArriveeSortie::where('jour_semaine','3')->where('justif_absence_id','not',null)->where('date_fin_validite','>=','2020-03-11')->orWhere('date_fin_validite','')->where('jour_semainee','3')->get();
		foreach($prevs as $pr){
			$p = Pointage::firstOrCreate(['jour'=>$jour,'personnel_id'=>$pr->personnel_id],['observation'=>$pr->observation,'justif_absence_id'=>$pr->justif_absence_id]);
			///dd(['jour'=>$jour,'personnel_id'=>$pr->personnel_id]);
			if( !($p->wasRecentlyCreated) ){
				$p->arrivee_prevue = '';
				$p->sortie_prevue = '';
				$p->arrivee = '';
				$p->sortie = '';
				$p->save();
			}
		}
	}

	// faire un left join avec la table agent et trouver les jour d'un mois
	public function rapport_mensuel(Request $request){
		$annee = $request->annee??date('Y');
		$mois_choisi = $request->mois??date('m');
		// $pointages = Pointage::with('personnel','justifAbsence')->where("jour","LIKE","$annee-$mois_choisi-%")->get();
		
		$req = str_replace('__AND__'," AND jour LIKE '$annee-$mois_choisi-%' ", $this->req_rapport)." order by noms";
		$pointages = \DB::select($req);
		
		$tabPointage = $lesJoursDuMois = [];
		for($i=1;$i!=32;$i++){
			$i = $i<10?"0$i":$i;
			$lesJoursDuMois["$annee-$mois_choisi-$i"]=false;
		}
		foreach($pointages as $p){
			if(!isset($tabPointage[$p->id])){
				// $tabPointage[$p->personnel->id]['agent'] = $p->personnel->noms;
				// $tabPointage[$p->personnel->id]['presences'] = $lesJoursDuMois;
				$tabPointage[$p->id]['agent'] = $p->noms;
				$tabPointage[$p->id]['presences'] = $lesJoursDuMois;
			}
			$tabPointage[$p->id]['presences'][$p->jour] = $p;			
		}
		$type_rapport = 'mensuel';
		$tab = compact('lesJoursDuMois','tabPointage','annee','mois_choisi','type_rapport');
		// dd($tab);
		return $this->addUser('personnel_presence.rapport',$tab);
	}
	public function voir_pointage_agent(Request $request){
	    $id_personnel = $request->personnel_id;
	    $agent = Personnel::with('agents.mcFonction')->where('id', $id_personnel)->first();
		
		$jour = date('Y-m-d');
	    $tab_pointage = $this->donnee_pointage_agent($jour,$id_personnel);
		return compact('agent','jour','action','tab_pointage');
	}
	public function rapport_individuel(Request $request){
	    $annee = $request->annee??date('Y');
		$mois_choisi = $request->mois??date('m');
		$personnels = Personnel::where('ecole_id',\App\Config::getEcoleId())->get();
		
		$tabPointage = $lesJoursDuMois = [];
		
		$agent = false;
		$personnel_id = $request->personnel_id;
		$personnel = Personnel::with('agents.mcFonction')->find($personnel_id);
		if($personnel){
		
			$req = str_replace('__AND__',"", $this->req_rapport);
			$req = $req." AND a.id = '$personnel_id' and jour LIKE '$annee-$mois_choisi-%'  order by jour";
			// dd(echo $req);
			$pointages = \DB::select($req);
			for($i=1;$i!=32;$i++){
				$i = $i<10?"0$i":$i;
				$lesJoursDuMois["$annee-$mois_choisi-$i"]=false;
			}
			$tabPointage = $lesJoursDuMois;
			foreach($pointages as $p){
				$tabPointage[$p->jour] = $p;			
			}
		}
			
		$type_rapport = 'individuel';
		$tab = compact('personnels','personnel','lesJoursDuMois','tabPointage','annee','mois_choisi','type_rapport');
		 // dd($pointages);
		return $this->addUser('personnel_presence.rapport',$tab);
	}
		
	public function rapport_journalier(Request $request){
		$date = $request->date??date('Y-m-d');
		$annee = $request->annee??date('Y');
		$personnel_id = $request->personnel_id;
		$personnel = Personnel::find($personnel_id);
		$personnels = Personnel::where('ecole_id',$this->ecole_id)->get();
		
		$req = str_replace('__AND__'," AND jour LIKE '$date'", $this->req_rapport)." order by noms";
		$tabPointage = \DB::select($req);
		// echo $req;
		// dd($tabPointage);
				
		$type_rapport = 'journalier';
		$tab = compact('personnels','personnel','tabPointage','annee','date','type_rapport');
		
		return $this->addUser('personnel_presence.rapport',$tab);
	}
	
	public function agent_deja_arriver(Request $request){
		$date = $request->date??date('Y-m-d');
		$annee = $request->annee??date('Y');
		$personnel_id = $request->personnel_id;
		$personnel = Personnel::find($personnel_id);
		$personnels = Personnel::where('ecole_id',$this->ecole_id)->get();
		
		$req = str_replace('__AND__'," AND jour LIKE '$date'", $this->req_rapport)." order by noms";
		$tabPointage = \DB::select($req);
		// echo $req;
		// dd($tabPointage);
				
		$type_rapport = 'journalier';
		$tab = compact('personnels','personnel','tabPointage','annee','date','type_rapport');
		
		return $this->addUser('personnel_presence.agent_deja_arriver',$tab);
	}
		
	public function refresh_agent_deja_arriver(Request $request){
		$date = $request->date??date('Y-m-d');
		$annee = $request->annee??date('Y');
		$personnel_id = $request->personnel_id;
		$personnel = Personnel::find($personnel_id);
		$personnels = Personnel::where('ecole_id',$this->ecole_id)->get();
		
		$req = str_replace('__AND__'," AND jour LIKE '$date'", $this->req_rapport)." order by p.sortie,p.arrivee,noms";
		$tabPointage = \DB::select($req);
		// echo $req;
		// dd($tabPointage);
				
		$type_rapport = 'journalier';
		$semaine = ['Lundi','Mardi','Mercredi','Jeudi','Vendredi','Samedi','Dimanche'];
		$indice = 1;
		$nbrT = 0;
		$nbrA=$nbrAJ=0;
			$nbrP=0;
		$weekend=[];
		$JrsOff = [6];//[0,6];
		$tabAbsJust = [];
		$tabAbsNonJust = [];

		$divPres = ['present'=>[],'sortie'=>[]];
		$divAbsJust = [];
		$divAbsNonJust = [];
						 
		if(count($tabPointage)){
			$index=0;
			
			foreach($tabPointage as $p){
				$index++;
				$lien = route('personnel_presence.rapport.individuel')."?personnel_id=".$p->id;
			if(!$p->jour and !$p->justification){
				$divAbsNonJust[] = $p;
			}
			else{
				if($p->justification){
					$divAbsJust[] = $p;
				}							
				else{
					$divPres[$p->sortie?'sortie':'present'][] = $p;
				}
			}
			}		
		}
					
		
		return compact('personnels','personnel','tabPointage','annee','date','type_rapport','divPres','divAbsJust','divAbsNonJust');
		
		return $this->addUser('personnel_presence._agent_deja_arriver',$tab);
	}
	
	public function delete_pointage(Request $request){
	    $j = date("Y-m-d");
	    $id = $request->personnel_id;
		$p = Pointage::where("personnel_id",$id)->where("jour",$j)->first()->delete();
		return ["result"=>"ok"];
	}
	
	public function rapport(Request $request){
		if($request->type_rapport=='individuel')
			return $this->rapport_individuel($request);
		else if($request->type_rapport=='mensuel')
			return $this->rapport_mensuel($request);
		else if($request->type_rapport=='journalier')
			return $this->rapport_journalier($request);	
		else {
			return $this->rapport_mensuel($request);
		}
	}
	
   public function scanne_presence($agent_id){
	   $datas = $this->save_presence_exec($agent_id,date("Y-m-d"));
	   
	   return view('result_for_scan_presence',$datas);
   }
}