<?php


namespace App\Http\Controllers;


use Illuminate\Http\Request;
use App\Masomwetu\School\Agent;
use App\Masomwetu\School\Personnel;
use App\Masomwetu\School\ImgDocument;
use App\Masomwetu\School\DossierPersonnel;
use App\Masomwetu\School\McFonction; 
use App\Masomwetu\School\NiveauEtudePersonnel;


class PersonnelDossierController extends Controller
{

	private function return_data($view, $data=[]){		
		// $personnels = Personnel::all();
		$id_ecole = \App\Config::getEcoleId();
		$personnels = Personnel::where('ecole_id',$id_ecole)->get();
		$data['personnels'] = $personnels;
		return $this->addUser($view,$data);
	}
	
    public function index(Request $request)
    {
		$id_ecole = \App\Config::getEcoleId();
		$liste_agents = Personnel::where('ecole_id',$id_ecole)->with('agents.mcFonction')->get();
		$liste_agents = $liste_agents->sortBy('noms');
		
		if($request->cartes_personnel)
		return $this->return_data('personnel_dossier.cartes_personnel',compact('liste_agents'));
		else return $this->return_data('personnel_dossier.agents',compact('liste_agents'));
    }
    public function imprimer_liste(Request $request)
    {
		$id_ecole = \App\Config::getEcoleId();
		$liste_agents = Personnel::where('ecole_id',$id_ecole)->with('agents.mcFonction')->get();
		$liste_agents = $liste_agents->sortBy('noms');
		
		return $this->return_data('personnel_dossier.imprimer_liste',compact('liste_agents'));
    }

    public function niveau_etude_personnels()
    {
        $ecole_id = \App\Config::getEcoleId();
        $niveauetudepersonnels = NiveauEtudePersonnel::with('personnel')->whereHas('personnel',function($q) use($ecole_id){
			return $q->where('ecole_id',$ecole_id);
		})->get();
		return $this->return_data('personnel_dossier.niveau_etude',compact('niveauetudepersonnels'));

    }

    public function personnel_dossier($id=0)
    {
		$dossierpersonnel = new DossierPersonnel;
		$personnel = null;
		if($id){
		    $id_ecole = \App\Config::getEcoleId();
			$personnel = Personnel::with('agents','dossierPersonnels.imgDocuments','niveauEtudePersonnels')->where('ecole_id',$id_ecole)->where('id',$id)->first();
			$dossierpersonnel->personnel_id = $personnel->id;
		}
		// dd($personnel);
		return $this->return_data('personnel_dossier.dossier', compact('personnel','dossierpersonnel') );
    }

	
    public function personnel_new()
    {
		$personnel = new Personnel;
		return $this->return_data('personnel_dossier.new_personnel', compact('personnel') );
    }
	
    public function personnel_etude(Request $request)
    {
		$personnel = Personnel::find($request->personnel_id);
		$niveauetudepersonnel = new NiveauEtudePersonnel;
		$niveauetudepersonnel->personnel_id = $request->personnel_id;
		return $this->return_data('personnel_dossier.new_etude', compact('niveauetudepersonnel','personnel') );
    }
	
    public function personnel_edit($id)
    {
		$personnel = Personnel::find($id);
		return $this->return_data('personnel_dossier.edit_personnel', compact('personnel') );
    }	
	
	private $req_rapport = "
	SELECT `a`.`id` AS `id`,`a`.`noms` AS `noms`,`j`.`justification` AS `justification`,`j`.`abreviation` AS `abreviation`,
	month( `p`.`jour`) AS `mois`,
	year(`p`.`jour`) AS `annee`,

	`p`.`jour` AS `jour`,`p`.`arrivee`,`p`.`sortie`,`p`.`arrivee_prevue`,`p`.`sortie_prevue`
	FROM personnels a
	LEFT JOIN `pointages` p on a.id = p.personnel_id __AND__
	LEFT JOIN `justif_absences` j on p.justif_absence_id = j.id
	LEFT JOIN `jour_ouvrables` jo on jo.jour_ouvert = p.jour
	";
	public function personnel_presence(Request $request){
		$annee = $request->annee??date('Y');
		$mois_choisi = $request->mois??date('m');
		
		$tabPointage = $lesJoursDuMois = [];
		
		$agent = false;
		$personnel_id = $request->personnel_id;
		if($personnel_id){
			$personnel = Personnel::with('agents.mcFonction')->find($personnel_id);
		
			$req = str_replace('__AND__',"", $this->req_rapport);
			$req = $req." where a.id = '$personnel_id' and jour LIKE '$annee-$mois_choisi-%'  order by jour";
			// dd(echo $req);
			$pointages = \DB::select($req);
			for($i=1;$i!=32;$i++){
				$i = $i<10?"0$i":$i;
				$lesJoursDuMois["$annee-$mois_choisi-$i"]=false;
			}
			$tabPointage = $lesJoursDuMois;
			foreach($pointages as $p){
				$tabPointage[$p->jour] = $p;			
			}
		}
			
		$tab = compact('personnel','lesJoursDuMois','tabPointage','annee','mois_choisi');
		 // dd($pointages);
		return $this->return_data('personnel_dossier.presence',$tab);
	}
		
    public function accueil()
    {
		$id_ecole = \App\Config::getEcoleId();
		$liste_agents = Personnel::where('ecole_id',$id_ecole)->with('agents.mcFonction')->get();
		$liste_agents = $liste_agents->sortBy('noms');
		$personnel = new Personnel;
		return $this->return_data('personnel_dossier.accueil', compact('personnel','liste_agents') );
    }
	
    public function agent_new(Request $request)
    {
		$id_ecole = \App\Config::getEcoleId();
        if($request->fonction and $request->enregistrer_new_fonc){
            $description = $request->description;
            $fonction = $request->fonction;
            $alias = $request->alias;
            $ecole_id = $id_ecole;
            $mc_fonction_type_id = 0;
            $data = compact('description','fonction','alias','ecole_id','mc_fonction_type_id');
            $r = McFonction::create($data);
            // dd($r,$data);
    		my_flash("Enregistrement effecté avec succès");
    		return redirect()->back();
        }
		$agent = new Agent;
		$personnel = Personnel::find($request->personnel_id);
		$agent->personnel_id = $request->personnel_id;
		$mcFonctions = McFonction::where('ecole_id',$id_ecole)->get();
		return $this->return_data('personnel_dossier.new_agent', compact('agent','mcFonctions','personnel') );
    }

	
    public function storeDossier(Request $request)
    {
		// dd(request(),request()->file('scan'));
		$datas = [
		'personnel_id'=>$request->personnel_id,
			'titre_document'=>$request->titre_document,
			'description'=>$request->description,
		];
		
		$dossierpersonnel = DossierPersonnel::create($datas);
		
		$folder = 'public/imgdocument/scan/';
		foreach(request()->file('scan') as $f){
			$datas = [
			'dossier_personnel_id'=>$dossierpersonnel->id,
			];
			$imgdocument = ImgDocument::create($datas);
			$uploadedFile = $f;
			$filename = false;
			if($uploadedFile){
				$filename = $imgdocument->id.'.'.$uploadedFile->getClientOriginalExtension();
				$path = \Storage::disk('local')->putFileAs(
					$folder,
					$uploadedFile,
					$filename
				);
				
				$imgdocument->scan = $filename;
				$imgdocument->save();
			}
		}
		my_flash("Enregistrement effecté avec succès");
		return redirect()->back();
    }


	public function update_insc_image(Request $request){
		$perso = Personnel::find($request->personnel_id);
		// enregistrement de l'image de l'enfant
		if($request->image1){					
			$image_array_1 = explode(";", $request->image1);	
			$image_array_2 = explode(",", $image_array_1[1]);
			$data = $image_array_2[1];
			$data = str_replace(' ', '+', $data);
			$data = base64_decode($data);
			$n = $perso->id.'-'.time().'.jpeg';
			$folder = 'storage/personnel/image'; 
			if(!file_exists($folder))
				mkdir($folder,0777,true);
			file_put_contents("$folder/$n", $data);
			$perso->image = $n;
			$perso->save();
			$result = 'success';
			$token = csrf_token();
			return compact('result','token');
		}
	}


}