<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use \App\Masomwetu\Scholar\Tuteur;
use \App\Masomwetu\Scholar\Enfant;
// use \App\Enfant;

// le controlleur qui gère l'entrée à toutes les sous applications
class MasomwetuController extends Controller
{
	public function m_scholar($sysUserRole){
		session(['sys_user_role_id' => $sysUserRole]);
		
		return redirect()->route('scholar.accueil');			
	}

	// le point d'entrée de m-payment (affiche le formulaire d'inscription)
	public function m_payment($sysUserRole){
		session(['sys_user_role_id' => $sysUserRole]);
		
		// return redirect()->route('payment.faire.payer');
		// return redirect()->route('payment.payer.par.carte');
		return redirect()->route('payment.accueil');
	}

	// le point d'entrée de m-disciplinary (affiche le formulaire d'inscription)
	public function m_disciplinary($sysUserRole){
		session(['sys_user_role_id' => $sysUserRole]);
		
		return redirect()->route('disciplinary.accueil');
	}


	public function m_cash(Request $request,$sysUserRole){
		session(['sys_user_role_id' => $sysUserRole]);
		
		return redirect()->route('cash.index');
	}
	public function m_communication($sysUserRole){
		session(['sys_user_role_id' => $sysUserRole]);
		
		return redirect()->route('communication.index');
	}
	
	public function m_report($sysUserRole){
		//session(['sys_user_role_id' => $sysUserRole]);
		return "<script>window.open('https://bulletin.delardc.com');</script>";
		// return redirect()->route('report.accueil');
		// return redirect()->route('report.index');
	}
	
	public function m_salary($sysUserRole){
		session(['sys_user_role_id' => $sysUserRole]);
		
		return redirect()->route('salary.index');
	}
	
	public function m_personnel($sysUserRole){
		session(['sys_user_role_id' => $sysUserRole]);
		
		return redirect()->route('personnel.accueil');
	}
	
	public function m_presence($sysUserRole){
		session(['sys_user_role_id' => $sysUserRole]);
		
		return redirect()->route('personnel_presence.agent.deja.arriver');
	}
	public function m_scaner($sysUserRole){
		session(['sys_user_role_id' => $sysUserRole]);
		
		return redirect()->route('scaner.accueil');
	}
	
	//=====================================
	public function findTuteurByPhone($phone){	
		$tuteur = Tuteur::where('telephone',$phone)->first();
		//dd($tuteur,$phone);
		$result = $tuteur?'success':'fail';
		return compact('result','tuteur');
	}
	
	public function findEnfantByMatricule($matricule){	
		$enfant = Enfant::where('matricule',$matricule)->first();
		$noms = $id = "";$classe = "Jamais inscrit!";
		if($enfant){
			$id = $enfant->id;
			$noms = $enfant->matricule.' '.$enfant->nom.' '.$enfant->postnom.' '.$enfant->prenom.' '.$enfant->genre;
			if($eleves = $enfant->msEleves and count($eleves) ){
				$mseleve = $eleves[ count($eleves)-1 ];
				
				$classe = $mseleve->msClasse->classe.' '.$mseleve->msClasse->msPromotion->promotion.' '.$mseleve->msClasse->msPromotion->section->nom_sec;
			}
		}
		$result = $enfant?'success':'fail';
		return compact('result','noms','classe','id');
	}
	
	public function update_field(Request $request){
		$clas = $request->c;
		$f = $request->f;
		$k = $request->k;
		$v = $request->v;
		eval('use App\Masomwetu\School\Personnel;$obj = '.$clas.'::find('.$k.');');
		if($obj){
			eval('$obj->'.$f." = \$v;");
			$r = $obj->save();
			return ['r'=>$r];
		}
		return ['r'=>'no-found'];
	}
	
}
