<?php

namespace App\Http\Controllers\Masomwetu\Sys;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Sys\SysZone;
use App\Masomwetu\Sys\SysAccessLevel; 
class SysZonesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the syszones
        $syszones = SysZone::all();

        // load the view and pass the syszones
        return view('Masomwetu.Sys.syszones.index')
            ->with('syszones', $syszones);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/syszones/create.blade.php)
        $syszone = new SysZone;
        return view('Masomwetu.Sys.syszones.create',compact('syszone'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'zone'=>$request->zone,
					'zone_desc'=>$request->zone_desc,
				];
				$rules = [
				'zone'=>'required',
					'zone_desc'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$syszone = SysZone::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $syszone->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('syszone',$syszone);
					return redirect()->back();
				}return redirect()->route('syszones.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $syszone = SysZone::findOrFail($id);
				return view('Masomwetu.Sys.syszones.show',compact('syszone'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $syszone = SysZone::findOrFail($id);
				return view('Masomwetu.Sys.syszones.edit',compact('syszone'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$syszone = SysZone::findOrFail($id);
				$datas = [
				'zone'=>$request->zone,
					'zone_desc'=>$request->zone_desc,
				];
				$rules = [
				'zone'=>'required',
					'zone_desc'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$syszone->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('syszones.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        SysZone::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('syszones.index');
    }
}
