<?php

namespace App\Http\Controllers\Masomwetu\Sys;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Sys\Parametre;
class ParametresController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the parametres
        $parametres = Parametre::all();

        // load the view and pass the parametres
        return view('Masomwetu.Sys.parametres.index')
            ->with('parametres', $parametres);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/parametres/create.blade.php)
        $parametre = new Parametre;
        return view('Masomwetu.Sys.parametres.create',compact('parametre'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'name'=>$request->name,
					'value'=>$request->value,
					'active'=>$request->active,
				];
				$rules = [
				'name'=>'required',
					'value'=>'',
					'active'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$parametre = Parametre::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $parametre->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('parametre',$parametre);
					return redirect()->back();
				}return redirect()->route('parametres.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $parametre = Parametre::findOrFail($id);
				return view('Masomwetu.Sys.parametres.show',compact('parametre'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $parametre = Parametre::findOrFail($id);
				return view('Masomwetu.Sys.parametres.edit',compact('parametre'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$parametre = Parametre::findOrFail($id);
				$datas = [
				'name'=>$request->name,
					'value'=>$request->value,
					'active'=>$request->active,
				];
				$rules = [
				'name'=>'required',
					'value'=>'',
					'active'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$parametre->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('parametres.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        Parametre::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('parametres.index');
    }
}
