<?php

namespace App\Http\Controllers\Masomwetu\School;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\School\SiFamiliale;
class SiFamilialesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the sifamiliales
        $sifamiliales = SiFamiliale::all();

        // load the view and pass the sifamiliales
        return view('Masomwetu.School.sifamiliales.index')
            ->with('sifamiliales', $sifamiliales);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/sifamiliales/create.blade.php)
        $sifamiliale = new SiFamiliale;
        return view('Masomwetu.School.sifamiliales.create',compact('sifamiliale'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'noms'=>$request->noms,
					'type'=>$request->type,
				];
				$rules = [
				'noms'=>'required',
					'type'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$sifamiliale = SiFamiliale::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $sifamiliale->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('sifamiliale',$sifamiliale);
					return redirect()->back();
				}return redirect()->route('sifamiliales.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $sifamiliale = SiFamiliale::findOrFail($id);
				return view('Masomwetu.School.sifamiliales.show',compact('sifamiliale'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $sifamiliale = SiFamiliale::findOrFail($id);
				return view('Masomwetu.School.sifamiliales.edit',compact('sifamiliale'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$sifamiliale = SiFamiliale::findOrFail($id);
				$datas = [
				'noms'=>$request->noms,
					'type'=>$request->type,
				];
				$rules = [
				'noms'=>'required',
					'type'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$sifamiliale->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('sifamiliales.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        SiFamiliale::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('sifamiliales.index');
    }
}
