<?php

namespace App\Http\Controllers\Masomwetu\School;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\School\Section;
use App\Masomwetu\Scholar\MsPromotion; 
class SectionsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the sections
        $sections = Section::all();

        // load the view and pass the sections
        return view('Masomwetu.School.sections.index')
            ->with('sections', $sections);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/sections/create.blade.php)
        $section = new Section;
        return view('Masomwetu.School.sections.create',compact('section'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'nom_sec'=>$request->nom_sec,
				];
				$rules = [
				'nom_sec'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$section = Section::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $section->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('section',$section);
					return redirect()->back();
				}return redirect()->route('sections.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $section = Section::findOrFail($id);
				return view('Masomwetu.School.sections.show',compact('section'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $section = Section::findOrFail($id);
				return view('Masomwetu.School.sections.edit',compact('section'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$section = Section::findOrFail($id);
				$datas = [
				'nom_sec'=>$request->nom_sec,
				];
				$rules = [
				'nom_sec'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$section->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('sections.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        Section::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('sections.index');
    }
}
