<?php

namespace App\Http\Controllers\Masomwetu\School;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\School\Enseignant;
use App\Masomwetu\Report\MrCours;
use App\Masomwetu\School\Agent; 
class EnseignantsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the enseignants
        $enseignants = Enseignant::all();

        // load the view and pass the enseignants
        return view('Masomwetu.School.enseignants.index')
            ->with('enseignants', $enseignants);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/enseignants/create.blade.php)
        $enseignant = new Enseignant;
				$agents = Agent::all();
        return view('Masomwetu.School.enseignants.create',compact('enseignant','agents'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'agent_id'=>$request->agent_id,
					'journee_pedago'=>$request->journee_pedago,
					'code_couleur'=>$request->code_couleur,
					'couleur_text'=>$request->couleur_text,
				];
				$rules = [
				'agent_id'=>'required',
					'journee_pedago'=>'',
					'code_couleur'=>'',
					'couleur_text'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$enseignant = Enseignant::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $enseignant->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('enseignant',$enseignant);
					return redirect()->back();
				}return redirect()->route('enseignants.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $enseignant = Enseignant::findOrFail($id);
				return view('Masomwetu.School.enseignants.show',compact('enseignant'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $enseignant = Enseignant::findOrFail($id);
				$agents = Agent::all();
				return view('Masomwetu.School.enseignants.edit',compact('enseignant','agents'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$enseignant = Enseignant::findOrFail($id);
				$datas = [
				'agent_id'=>$request->agent_id,
					'journee_pedago'=>$request->journee_pedago,
					'code_couleur'=>$request->code_couleur,
					'couleur_text'=>$request->couleur_text,
				];
				$rules = [
				'agent_id'=>'required',
					'journee_pedago'=>'',
					'code_couleur'=>'',
					'couleur_text'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$enseignant->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('enseignants.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        Enseignant::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('enseignants.index');
    }
}
