<?php

namespace App\Http\Controllers\Masomwetu\School;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\School\Ecole;
use App\Masomwetu\Scholar\MsAnneeScolaire; 
class EcolesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the ecoles
        $ecoles = Ecole::all();

        // load the view and pass the ecoles
        return view('Masomwetu.School.ecoles.index')
            ->with('ecoles', $ecoles);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/ecoles/create.blade.php)
        $ecole = new Ecole;
        return view('Masomwetu.School.ecoles.create',compact('ecole'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'nom_ecole'=>$request->nom_ecole,
					'code_ecole'=>$request->code_ecole,
				];
				$rules = [
				'nom_ecole'=>'required',
					'code_ecole'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$ecole = Ecole::create($datas);
				if($logo_ecole = chado_saveFile('public/ecole/logo_ecole/','logo_ecole',$ecole->id)){
					$ecole->logo_ecole = $logo_ecole;
					$ecole->save();
				}
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $ecole->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('ecole',$ecole);
					return redirect()->back();
				}return redirect()->route('ecoles.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $ecole = Ecole::findOrFail($id);
				return view('Masomwetu.School.ecoles.show',compact('ecole'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $ecole = Ecole::findOrFail($id);
				return view('Masomwetu.School.ecoles.edit',compact('ecole'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$ecole = Ecole::findOrFail($id);
				$datas = [
				'nom_ecole'=>$request->nom_ecole,
					'code_ecole'=>$request->code_ecole,
				];
				$rules = [
				'nom_ecole'=>'required',
					'code_ecole'=>'',
				];
				
				if($request->check_logo_ecole or $request->logo_ecole){
					if($request->logo_ecole and ($logo_ecole = chado_saveFile('public/ecole/logo_ecole/','logo_ecole',$ecole->id)))
						$datas['logo_ecole'] = $logo_ecole;
					else $datas['logo_ecole'] = '';
					$rules['logo_ecole'] = '';
				}
					
				\Validator::make($datas,$rules)->validate();
				$ecole->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('ecoles.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        Ecole::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('ecoles.index');
    }
}
