<?php

namespace App\Http\Controllers\Masomwetu\School;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\School\Agent;
use App\Masomwetu\School\Enseignant;
use App\Masomwetu\School\Personnel;
use App\Masomwetu\School\McFonction; 
class AgentsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the agents
        $agents = Agent::all();

        // load the view and pass the agents
        return view('Masomwetu.School.agents.index')
            ->with('agents', $agents);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/agents/create.blade.php)
        $agent = new Agent;
				$personnels = Personnel::all();
				$mcFonctions = McFonction::all();
        return view('Masomwetu.School.agents.create',compact('agent','personnels','mcFonctions'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'personnel_id'=>$request->personnel_id,
					'mc_fonction_id'=>$request->mc_fonction_id,
					'date_engagement'=>($request->date_engagement??''),
				];
				$rules = [
				'personnel_id'=>'required',
					'mc_fonction_id'=>'required',
					'date_engagement'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$agent = Agent::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $agent->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('agent',$agent);
					return redirect()->back();
				}return redirect()->route('agents.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $agent = Agent::findOrFail($id);
				return view('Masomwetu.School.agents.show',compact('agent'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $agent = Agent::findOrFail($id);
				$personnels = Personnel::all();
				$mcFonctions = McFonction::all();
				return view('Masomwetu.School.agents.edit',compact('agent','personnels','mcFonctions'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$agent = Agent::findOrFail($id);
				$datas = [
				'personnel_id'=>$request->personnel_id,
					'mc_fonction_id'=>$request->mc_fonction_id,
					'date_engagement'=>($request->date_engagement??''),
				];
				$rules = [
				'personnel_id'=>'required',
					'mc_fonction_id'=>'required',
					'date_engagement'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$agent->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('agents.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {
				// 
        Agent::destroy($id);
		if ($request->has('redirectTo')){
			return \Redirect::to($request->redirectTo);
		}
				my_flash("Suppression effectée","danger");
				return redirect()->route('agents.index');
    }
}
