<?php

namespace App\Http\Controllers\Masomwetu\Scholar;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Scholar\Tuteur;
use App\Masomwetu\Scholar\MsInscription; 
class TuteursController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the tuteurs
        $tuteurs = Tuteur::all();

        // load the view and pass the tuteurs
        return view('Masomwetu.Scholar.tuteurs.index')
            ->with('tuteurs', $tuteurs);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/tuteurs/create.blade.php)
        $tuteur = new Tuteur;
        return view('Masomwetu.Scholar.tuteurs.create',compact('tuteur'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'nom_tuteur'=>$request->nom_tuteur,
					'telephone'=>$request->telephone,
					'adresse'=>$request->adresse,
				];
				$rules = [
				'nom_tuteur'=>'required',
					'telephone'=>'',
					'adresse'=>'required',
				];
        // return dd($request->has('redirectTo'),$request);
				\Validator::make($datas,$rules)->validate();
				$tuteur = Tuteur::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $tuteur->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('tuteur',$tuteur);
					return redirect()->back();
				}return redirect()->route('tuteurs.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $tuteur = Tuteur::findOrFail($id);
				return view('Masomwetu.Scholar.tuteurs.show',compact('tuteur'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $tuteur = Tuteur::findOrFail($id);
				return view('Masomwetu.Scholar.tuteurs.edit',compact('tuteur'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$tuteur = Tuteur::findOrFail($id);
				$datas = [
				'nom_tuteur'=>$request->nom_tuteur,
					'telephone'=>$request->telephone,
					'adresse'=>$request->adresse,
				];
				$rules = [
				'nom_tuteur'=>'required',
					'telephone'=>'',
					'adresse'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$tuteur->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('tuteurs.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        Tuteur::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('tuteurs.index');
    }
}
