<?php

namespace App\Http\Controllers\Masomwetu\Scholar;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Scholar\Parent;
class ParentsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the parents
        $parents = Parent::all();

        // load the view and pass the parents
        return view('Masomwetu.Scholar.parents.index')
            ->with('parents', $parents);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/parents/create.blade.php)
        $parent = new Parent;
        return view('Masomwetu.Scholar.parents.create',compact('parent'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'papa'=>$request->papa,
					'telephone_pa'=>$request->telephone_pa,
					'profession_pa'=>$request->profession_pa,
					'maman'=>$request->maman,
					'telephone_ma'=>$request->telephone_ma,
					'profession_ma'=>$request->profession_ma,
				];
				$rules = [
				'papa'=>'required',
					'telephone_pa'=>'',
					'profession_pa'=>'',
					'maman'=>'required',
					'telephone_ma'=>'',
					'profession_ma'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$parent = Parent::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					if($request->redirectTo=="AJAX")
						return $parent;
					$id = $parent->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('parent',$parent);
					return redirect()->back();
				}
				return redirect()->route('parents.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $parent = Parent::findOrFail($id);
				return view('Masomwetu.Scholar.parents.show',compact('parent'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $parent = Parent::findOrFail($id);
				return view('Masomwetu.Scholar.parents.edit',compact('parent'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$parent = Parent::findOrFail($id);
				$datas = [
				'papa'=>$request->papa,
					'telephone_pa'=>$request->telephone_pa,
					'profession_pa'=>$request->profession_pa,
					'maman'=>$request->maman,
					'telephone_ma'=>$request->telephone_ma,
					'profession_ma'=>$request->profession_ma,
				];
				$rules = [
				'papa'=>'required',
					'telephone_pa'=>'',
					'profession_pa'=>'',
					'maman'=>'required',
					'telephone_ma'=>'',
					'profession_ma'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$parent->update($datas);
				my_flash("Modification effectée avec succès");
				if ($request->has('redirectTo')){
					$id = $parent->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('parent',$parent);
					return redirect()->back();
				}
				return redirect()->route('parents.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        Parent::destroy( $id);
		if ($request->has('redirectTo')){
			return \Redirect::to($request->redirectTo);
		}
		my_flash("Suppression effectée","danger");
		return redirect()->route('parents.index');
    }
}
