<?php

namespace App\Http\Controllers\Masomwetu\Scholar;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Scholar\ParentEnfant;
use App\Masomwetu\Scholar\Enfant; 
class ParentEnfantsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the parentenfants
        $parentenfants = ParentEnfant::all();

        // load the view and pass the parentenfants
        return view('Masomwetu.Scholar.parentenfants.index')
            ->with('parentenfants', $parentenfants);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/parentenfants/create.blade.php)
        $parentenfant = new ParentEnfant;
        return view('Masomwetu.Scholar.parentenfants.create',compact('parentenfant'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'papa'=>$request->papa,
					'telephone_pa'=>$request->telephone_pa,
					'profession_pa'=>$request->profession_pa,
					'maman'=>$request->maman,
					'telephone_ma'=>$request->telephone_ma,
					'profession_ma'=>$request->profession_ma,
				];
				$rules = [
				'papa'=>'required',
					'telephone_pa'=>'',
					'profession_pa'=>'',
					'maman'=>'required',
					'telephone_ma'=>'',
					'profession_ma'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$parentenfant = ParentEnfant::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					if($request->redirectTo=="AJAX")
						return $parentenfant;
					$id = $parentenfant->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('parentenfant',$parentenfant);
					return redirect()->back();
				}
				return redirect()->route('parentenfants.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $parentenfant = ParentEnfant::findOrFail($id);
				return view('Masomwetu.Scholar.parentenfants.show',compact('parentenfant'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $parentenfant = ParentEnfant::findOrFail($id);
				return view('Masomwetu.Scholar.parentenfants.edit',compact('parentenfant'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$parentenfant = ParentEnfant::findOrFail($id);
				$datas = [
				'papa'=>$request->papa,
					'telephone_pa'=>$request->telephone_pa,
					'profession_pa'=>$request->profession_pa,
					'maman'=>$request->maman,
					'telephone_ma'=>$request->telephone_ma,
					'profession_ma'=>$request->profession_ma,
				];
				$rules = [
				'papa'=>'required',
					'telephone_pa'=>'',
					'profession_pa'=>'',
					'maman'=>'required',
					'telephone_ma'=>'',
					'profession_ma'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$parentenfant->update($datas);
				my_flash("Modification effectée avec succès");
				if ($request->has('redirectTo')){
					$id = $parentenfant->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('parentenfant',$parentenfant);
					return redirect()->back();
				}
				return redirect()->route('parentenfants.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request,$id)
    {
				// 
        ParentEnfant::destroy( $id);
		if ($request->has('redirectTo')){
			return \Redirect::to($request->redirectTo);
		}
		my_flash("Suppression effectée","danger");
		return redirect()->route('parentenfants.index');
    }
}
