<?php

namespace App\Http\Controllers\Masomwetu\Scholar;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Scholar\MsPromotion;
use App\Masomwetu\School\Section;
use App\Masomwetu\Scholar\MsAnneeScolaire;
use App\Masomwetu\Scholar\MsClasse;
use App\Masomwetu\Scholar\MsInscription;
use App\Masomwetu\Report\MrCoursPromotion; 
class MsPromotionsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the mspromotions
        $mspromotions = MsPromotion::all();

        // load the view and pass the mspromotions
        return view('Masomwetu.Scholar.mspromotions.index')
            ->with('mspromotions', $mspromotions);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/mspromotions/create.blade.php)
        $mspromotion = new MsPromotion;
				$sections = Section::all();
				$msAnneeScolaires = MsAnneeScolaire::all();
        return view('Masomwetu.Scholar.mspromotions.create',compact('mspromotion','sections','msAnneeScolaires'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'promotion'=>$request->promotion,
					'section_id'=>$request->section_id,
					'niveau'=>$request->niveau,
					'option'=>$request->option,
					//'frais_inscription'=>$request->frais_inscription,
					//'contrainte'=>$request->contrainte,
					//'ms_annee_scolaire_id'=>$request->ms_annee_scolaire_id,
				];
				$rules = [
				'promotion'=>'required',
					'section_id'=>'required',
					'niveau'=>'',
					'option'=>'',
					//'frais_inscription'=>'',
					//'contrainte'=>'',
					//'ms_annee_scolaire_id'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$mspromotion = MsPromotion::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $mspromotion->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('mspromotion',$mspromotion);
					return redirect()->back();
				}return redirect()->route('mspromotions.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $mspromotion = MsPromotion::findOrFail($id);
				return view('Masomwetu.Scholar.mspromotions.show',compact('mspromotion'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $mspromotion = MsPromotion::findOrFail($id);
				$sections = Section::all();
				$msAnneeScolaires = MsAnneeScolaire::all();
				return view('Masomwetu.Scholar.mspromotions.edit',compact('mspromotion','sections','msAnneeScolaires'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$mspromotion = MsPromotion::findOrFail($id);
				$datas = [
				'promotion'=>$request->promotion,
					'section_id'=>$request->section_id,
					'niveau'=>$request->niveau,
					'option'=>$request->option,
					//'frais_inscription'=>$request->frais_inscription,
					//'contrainte'=>$request->contrainte,
					//'ms_annee_scolaire_id'=>$request->ms_annee_scolaire_id,
				];
				$rules = [
				'promotion'=>'required',
					'section_id'=>'required',
					'niveau'=>'',
					'option'=>'',
					//'frais_inscription'=>'',
					//'contrainte'=>'',
					//'ms_annee_scolaire_id'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$mspromotion->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('mspromotions.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        MsPromotion::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('mspromotions.index');
    }
}
