<?php

namespace App\Http\Controllers\Masomwetu\Scholar;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Scholar\MsInscription;
use App\Masomwetu\Scholar\MsEleve;
use App\Masomwetu\Scholar\Enfant;
use App\Masomwetu\Scholar\MsPromotion;
use App\Masomwetu\Scholar\Tuteur; 
class MsInscriptionsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the msinscriptions
        $msinscriptions = MsInscription::all();

        // load the view and pass the msinscriptions
        return view('Masomwetu.Scholar.msinscriptions.index')
            ->with('msinscriptions', $msinscriptions);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/msinscriptions/create.blade.php)
        $msinscription = new MsInscription;
				$enfants = Enfant::all();
				$msPromotions = MsPromotion::all();
				$tuteurs = Tuteur::all();
        return view('Masomwetu.Scholar.msinscriptions.create',compact('msinscription','enfants','msPromotions','tuteurs'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'enfant_id'=>$request->enfant_id,
					'ms_promotion_id'=>$request->ms_promotion_id,
					'inscrit_le'=>($request->inscrit_le??''),
					'montant'=>$request->montant,
					'tuteur_id'=>$request->tuteur_id,
					'classer'=>$request->classer,
				];
				$rules = [
				'enfant_id'=>'required',
					'ms_promotion_id'=>'required',
					'inscrit_le'=>'required',
					'montant'=>'required',
					'tuteur_id'=>'required',
					'classer'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$msinscription = MsInscription::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $msinscription->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('msinscription',$msinscription);
					return redirect()->back();
				}return redirect()->route('msinscriptions.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $msinscription = MsInscription::findOrFail($id);
				return view('Masomwetu.Scholar.msinscriptions.show',compact('msinscription'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $msinscription = MsInscription::findOrFail($id);
				$enfants = Enfant::all();
				$msPromotions = MsPromotion::all();
				$tuteurs = Tuteur::all();
				return view('Masomwetu.Scholar.msinscriptions.edit',compact('msinscription','enfants','msPromotions','tuteurs'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$msinscription = MsInscription::findOrFail($id);
				$datas = [
				'enfant_id'=>$request->enfant_id,
					'ms_promotion_id'=>$request->ms_promotion_id,
					'inscrit_le'=>($request->inscrit_le??''),
					'montant'=>$request->montant,
					'tuteur_id'=>$request->tuteur_id,
					'classer'=>$request->classer,
				];
				$rules = [
				'enfant_id'=>'required',
					'ms_promotion_id'=>'required',
					'inscrit_le'=>'required',
					'montant'=>'required',
					'tuteur_id'=>'required',
					'classer'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$msinscription->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('msinscriptions.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        MsInscription::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('msinscriptions.index');
    }
}
