<?php

namespace App\Http\Controllers\Masomwetu\Scholar;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Scholar\MsEleve;
use App\Masomwetu\Scholar\Enfant;
use App\Masomwetu\Scholar\MsClasse;
use App\Masomwetu\Scholar\MsInscription;
use App\Masomwetu\Scholar\StatusEnfant;
use App\Masomwetu\Payment\MpFraisPaiement;
use App\Masomwetu\Disciplinary\MdCommentaire;
use App\Masomwetu\Disciplinary\MdRetard;
use App\Masomwetu\Disciplinary\MdAbsence;
use App\Masomwetu\Disciplinary\MdEleveRenvoyer;
use App\Masomwetu\Report\MrCote; 
class MsElevesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the mseleves
        $mseleves = MsEleve::all();

        // load the view and pass the mseleves
        return view('Masomwetu.Scholar.mseleves.index')
            ->with('mseleves', $mseleves);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/mseleves/create.blade.php)
        $mseleve = new MsEleve;
				$enfants = Enfant::all();
				$msClasses = MsClasse::all();
				$msInscriptions = MsInscription::all();
				$statusEnfants = StatusEnfant::all();
        return view('Masomwetu.Scholar.mseleves.create',compact('mseleve','enfants','msClasses','msInscriptions','statusEnfants'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'enfant_id'=>$request->enfant_id,
					'ms_classe_id'=>$request->ms_classe_id,
					'inscrit_le'=>($request->inscrit_le??''),
					'ms_inscription_id'=>$request->ms_inscription_id,
					'etat'=>$request->etat,
					'status_enfant_id'=>$request->status_enfant_id,
				];
				$rules = [
				'enfant_id'=>'required',
					'ms_classe_id'=>'required',
					'inscrit_le'=>'required',
					'ms_inscription_id'=>'required',
					'etat'=>'required',
					'status_enfant_id'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$mseleve = MsEleve::create($datas);
				if($img = chado_saveFile('public/mseleve/img/','img',$mseleve->id)){
					$mseleve->img = $img;
					$mseleve->save();
				}
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $mseleve->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('mseleve',$mseleve);
					return redirect()->back();
				}return redirect()->route('mseleves.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $mseleve = MsEleve::findOrFail($id);
				return view('Masomwetu.Scholar.mseleves.show',compact('mseleve'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $mseleve = MsEleve::findOrFail($id);
				$enfants = Enfant::all();
				$msClasses = MsClasse::all();
				$msInscriptions = MsInscription::all();
				$statusEnfants = StatusEnfant::all();
				return view('Masomwetu.Scholar.mseleves.edit',compact('mseleve','enfants','msClasses','msInscriptions','statusEnfants'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$mseleve = MsEleve::findOrFail($id);
				$datas = [
				'enfant_id'=>$request->enfant_id,
					'ms_classe_id'=>$request->ms_classe_id,
					'inscrit_le'=>($request->inscrit_le??''),
					'ms_inscription_id'=>$request->ms_inscription_id,
					'etat'=>$request->etat,
					'status_enfant_id'=>$request->status_enfant_id,
				];
				$rules = [
				'enfant_id'=>'required',
					'ms_classe_id'=>'required',
					'inscrit_le'=>'required',
					'ms_inscription_id'=>'required',
					'etat'=>'required',
					'status_enfant_id'=>'',
				];
				
				if($request->check_img or $request->img){
					if($request->img and ($img = chado_saveFile('public/mseleve/img/','img',$mseleve->id)))
						$datas['img'] = $img;
					else $datas['img'] = '';
					$rules['img'] = '';
				}
					
				\Validator::make($datas,$rules)->validate();
				$mseleve->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('mseleves.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        MsEleve::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('mseleves.index');
    }
}
