<?php

namespace App\Http\Controllers\Masomwetu\Scholar;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Scholar\MsClasse;
use App\Masomwetu\Scholar\MsPromotion;
use App\Masomwetu\Scholar\MsEleve;
use App\Masomwetu\Payment\MpFraisClasse;
use App\Masomwetu\Report\MrCours; 

use \App\Config;

class MsClassesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the msclasses
        $msclasses = MsClasse::all();

        // load the view and pass the msclasses
        return view('Masomwetu.Scholar.msclasses.index')
            ->with('msclasses', $msclasses);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/msclasses/create.blade.php)
        $msclasse = new MsClasse;
				$msPromotions = MsPromotion::all();
        return view('Masomwetu.Scholar.msclasses.create',compact('msclasse','msPromotions'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $ecole_id = Config::getEcoleId();
				// 
				$datas = [
				    'classe'=>$request->classe,
					'ms_promotion_id'=>$request->ms_promotion_id,
					'ecole_id'=>$ecole_id,
				];
				$rules = [
				'classe'=>'required',
					'ms_promotion_id'=>'required',
					'ecole_id'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$msclasse = MsClasse::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $msclasse->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('msclasse',$msclasse);
					return redirect()->back();
				}return redirect()->route('msclasses.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $msclasse = MsClasse::findOrFail($id);
				return view('Masomwetu.Scholar.msclasses.show',compact('msclasse'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $msclasse = MsClasse::findOrFail($id);
				$msPromotions = MsPromotion::all();
				return view('Masomwetu.Scholar.msclasses.edit',compact('msclasse','msPromotions'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$msclasse = MsClasse::findOrFail($id);
				$datas = [
				'classe'=>$request->classe,
					'ms_promotion_id'=>$request->ms_promotion_id,
				];
				$rules = [
				'classe'=>'required',
					'ms_promotion_id'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$msclasse->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('msclasses.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        MsClasse::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('msclasses.index');
    }
}
