<?php

namespace App\Http\Controllers\Masomwetu\Scholar;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Scholar\MsAnneeScolaire;
use App\Masomwetu\Scholar\MsPromotion;
use App\Masomwetu\School\Ecole;
use App\Masomwetu\Payment\MpFrais;
use App\Masomwetu\Sys\SysUserRole;
use App\Masomwetu\Cash\CashFicheSortie; 
class MsAnneeScolairesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the msanneescolaires
        $msanneescolaires = MsAnneeScolaire::all();

        // load the view and pass the msanneescolaires
        return view('Masomwetu.Scholar.msanneescolaires.index')
            ->with('msanneescolaires', $msanneescolaires);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/msanneescolaires/create.blade.php)
        $msanneescolaire = new MsAnneeScolaire;
				$ecoles = Ecole::all();
        return view('Masomwetu.Scholar.msanneescolaires.create',compact('msanneescolaire','ecoles'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'annee'=>$request->annee,
					'ecole_id'=>$request->ecole_id,
					'etat'=>$request->etat,
					'adresse_ecole'=>$request->adresse_ecole,
					'tel_ecole'=>$request->tel_ecole,
					'email'=>$request->email,
				];
				$rules = [
				'annee'=>'required',
					'ecole_id'=>'required',
					'etat'=>'',
					'adresse_ecole'=>'',
					'tel_ecole'=>'',
					'email'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$msanneescolaire = MsAnneeScolaire::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $msanneescolaire->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('msanneescolaire',$msanneescolaire);
					return redirect()->back();
				}return redirect()->route('msanneescolaires.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $msanneescolaire = MsAnneeScolaire::findOrFail($id);
				return view('Masomwetu.Scholar.msanneescolaires.show',compact('msanneescolaire'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $msanneescolaire = MsAnneeScolaire::findOrFail($id);
				$ecoles = Ecole::all();
				return view('Masomwetu.Scholar.msanneescolaires.edit',compact('msanneescolaire','ecoles'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$msanneescolaire = MsAnneeScolaire::findOrFail($id);
				$datas = [
				'annee'=>$request->annee,
					'ecole_id'=>$request->ecole_id,
					'etat'=>$request->etat,
					'adresse_ecole'=>$request->adresse_ecole,
					'tel_ecole'=>$request->tel_ecole,
					'email'=>$request->email,
				];
				$rules = [
				'annee'=>'required',
					'ecole_id'=>'required',
					'etat'=>'',
					'adresse_ecole'=>'',
					'tel_ecole'=>'',
					'email'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$msanneescolaire->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('msanneescolaires.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        MsAnneeScolaire::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('msanneescolaires.index');
    }
}
