<?php

namespace App\Http\Controllers\Masomwetu\Salary;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Salary\SaCategorieBulletin;
use App\Masomwetu\Salary\SaRubriqueCategorieBulletin;
use App\Masomwetu\Salary\SaSalarie; 
class SaCategorieBulletinsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the sacategoriebulletins
        $sacategoriebulletins = SaCategorieBulletin::all();

        // load the view and pass the sacategoriebulletins
        return view('Masomwetu.Salary.sacategoriebulletins.index')
            ->with('sacategoriebulletins', $sacategoriebulletins);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/sacategoriebulletins/create.blade.php)
        $sacategoriebulletin = new SaCategorieBulletin;
        return view('Masomwetu.Salary.sacategoriebulletins.create',compact('sacategoriebulletin'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'libelle'=>$request->libelle,
					'description'=>$request->description,
					'montant_sal_brute'=>$request->montant_sal_brute,
				];
				$rules = [
				'libelle'=>'required',
					'description'=>'',
					'montant_sal_brute'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$sacategoriebulletin = SaCategorieBulletin::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $sacategoriebulletin->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('sacategoriebulletin',$sacategoriebulletin);
					return redirect()->back();
				}return redirect()->route('sacategoriebulletins.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $sacategoriebulletin = SaCategorieBulletin::findOrFail($id);
				return view('Masomwetu.Salary.sacategoriebulletins.show',compact('sacategoriebulletin'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $sacategoriebulletin = SaCategorieBulletin::findOrFail($id);
				return view('Masomwetu.Salary.sacategoriebulletins.edit',compact('sacategoriebulletin'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$sacategoriebulletin = SaCategorieBulletin::findOrFail($id);
				$datas = [
				'libelle'=>$request->libelle,
					'description'=>$request->description,
					'montant_sal_brute'=>$request->montant_sal_brute,
				];
				$rules = [
				'libelle'=>'required',
					'description'=>'',
					'montant_sal_brute'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$sacategoriebulletin->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('sacategoriebulletins.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        SaCategorieBulletin::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('sacategoriebulletins.index');
    }
}
