<?php

namespace App\Http\Controllers\Masomwetu\Report;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Report\MrCours;
use App\Masomwetu\Report\MrCoursPromotion;
use App\Masomwetu\Scholar\MsClasse;
use App\Masomwetu\School\Enseignant;
use App\Masomwetu\Report\MrCote;
use App\Masomwetu\Schedule\ScHoraire; 
class MrCourssController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the mrcourss
        $mrcourss = MrCours::all();

        // load the view and pass the mrcourss
        return view('Masomwetu.Report.mrcourss.index')
            ->with('mrcourss', $mrcourss);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/mrcourss/create.blade.php)
        $mrcours = new MrCours;
				$mrCoursPromotions = MrCoursPromotion::all();
				$msClasses = MsClasse::all();
				$enseignants = Enseignant::all();
        return view('Masomwetu.Report.mrcourss.create',compact('mrcours','mrCoursPromotions','msClasses','enseignants'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'mr_cours_promotion_id'=>$request->mr_cours_promotion_id,
					'ms_classe_id'=>$request->ms_classe_id,
					'enseignant_id'=>$request->enseignant_id,
					'charge_hr'=>$request->charge_hr,
					'nbr_hr_par_jr'=>$request->nbr_hr_par_jr,
					'nbr_hr_daffilee_par_jr'=>$request->nbr_hr_daffilee_par_jr,
					'aligne_cette_annee'=>$request->aligne_cette_annee,
					'actif'=>$request->actif,
					'est_titulaire'=>$request->est_titulaire,
					'aliase_cours'=>$request->aliase_cours,
				];
				$rules = [
				'mr_cours_promotion_id'=>'required',
					'ms_classe_id'=>'required',
					'enseignant_id'=>'required',
					'charge_hr'=>'',
					'nbr_hr_par_jr'=>'',
					'nbr_hr_daffilee_par_jr'=>'',
					'aligne_cette_annee'=>'',
					'actif'=>'',
					'est_titulaire'=>'',
					'aliase_cours'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$mrcours = MrCours::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $mrcours->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('mrcours',$mrcours);
					return redirect()->back();
				}return redirect()->route('mrcourss.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $mrcours = MrCours::findOrFail($id);
				return view('Masomwetu.Report.mrcourss.show',compact('mrcours'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $mrcours = MrCours::findOrFail($id);
				$mrCoursPromotions = MrCoursPromotion::all();
				$msClasses = MsClasse::all();
				$enseignants = Enseignant::all();
				return view('Masomwetu.Report.mrcourss.edit',compact('mrcours','mrCoursPromotions','msClasses','enseignants'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$mrcours = MrCours::findOrFail($id);
				$datas = [
				'mr_cours_promotion_id'=>$request->mr_cours_promotion_id,
					'ms_classe_id'=>$request->ms_classe_id,
					'enseignant_id'=>$request->enseignant_id,
					'charge_hr'=>$request->charge_hr,
					'nbr_hr_par_jr'=>$request->nbr_hr_par_jr,
					'nbr_hr_daffilee_par_jr'=>$request->nbr_hr_daffilee_par_jr,
					'aligne_cette_annee'=>$request->aligne_cette_annee,
					'actif'=>$request->actif,
					'est_titulaire'=>$request->est_titulaire,
					'aliase_cours'=>$request->aliase_cours,
				];
				$rules = [
				'mr_cours_promotion_id'=>'required',
					'ms_classe_id'=>'required',
					'enseignant_id'=>'required',
					'charge_hr'=>'',
					'nbr_hr_par_jr'=>'',
					'nbr_hr_daffilee_par_jr'=>'',
					'aligne_cette_annee'=>'',
					'actif'=>'',
					'est_titulaire'=>'',
					'aliase_cours'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$mrcours->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('mrcourss.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        MrCours::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('mrcourss.index');
    }
}
