<?php

namespace App\Http\Controllers\Masomwetu\Report;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Report\MrCote;
use App\Masomwetu\Scholar\MsEleve;
use App\Masomwetu\Report\MrCours;
use App\Masomwetu\Report\MrCoteModifiee; 
class MrCotesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the mrcotes
        $mrcotes = MrCote::all();

        // load the view and pass the mrcotes
        return view('Masomwetu.Report.mrcotes.index')
            ->with('mrcotes', $mrcotes);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/mrcotes/create.blade.php)
        $mrcote = new MrCote;
				$msEleves = MsEleve::all();
				$mrCourss = MrCours::all();
        return view('Masomwetu.Report.mrcotes.create',compact('mrcote','msEleves','mrCourss'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'ms_eleve_id'=>$request->ms_eleve_id,
					'mr_cours_id'=>$request->mr_cours_id,
					'cote_1'=>$request->cote_1,
					'cote_2'=>$request->cote_2,
					'cote_3'=>$request->cote_3,
					'cote_4'=>$request->cote_4,
					'cote_5'=>$request->cote_5,
					'cote_6'=>$request->cote_6,
					'cote_7'=>$request->cote_7,
					'cote_8'=>$request->cote_8,
					'cote_9'=>$request->cote_9,
				];
				$rules = [
				'ms_eleve_id'=>'required',
					'mr_cours_id'=>'required',
					'cote_1'=>'',
					'cote_2'=>'',
					'cote_3'=>'',
					'cote_4'=>'',
					'cote_5'=>'',
					'cote_6'=>'',
					'cote_7'=>'',
					'cote_8'=>'',
					'cote_9'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$mrcote = MrCote::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $mrcote->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('mrcote',$mrcote);
					return redirect()->back();
				}return redirect()->route('mrcotes.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $mrcote = MrCote::findOrFail($id);
				return view('Masomwetu.Report.mrcotes.show',compact('mrcote'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $mrcote = MrCote::findOrFail($id);
				$msEleves = MsEleve::all();
				$mrCourss = MrCours::all();
				return view('Masomwetu.Report.mrcotes.edit',compact('mrcote','msEleves','mrCourss'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$mrcote = MrCote::findOrFail($id);
				$datas = [
				'ms_eleve_id'=>$request->ms_eleve_id,
					'mr_cours_id'=>$request->mr_cours_id,
					'cote_1'=>$request->cote_1,
					'cote_2'=>$request->cote_2,
					'cote_3'=>$request->cote_3,
					'cote_4'=>$request->cote_4,
					'cote_5'=>$request->cote_5,
					'cote_6'=>$request->cote_6,
					'cote_7'=>$request->cote_7,
					'cote_8'=>$request->cote_8,
					'cote_9'=>$request->cote_9,
				];
				$rules = [
				'ms_eleve_id'=>'required',
					'mr_cours_id'=>'required',
					'cote_1'=>'',
					'cote_2'=>'',
					'cote_3'=>'',
					'cote_4'=>'',
					'cote_5'=>'',
					'cote_6'=>'',
					'cote_7'=>'',
					'cote_8'=>'',
					'cote_9'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$mrcote->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('mrcotes.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        MrCote::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('mrcotes.index');
    }
}
