<?php

namespace App\Http\Controllers\Masomwetu\Report;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Report\MrCoteModifiee;
use App\Masomwetu\Report\MrCote;
use App\Masomwetu\School\Personnel; 
class MrCoteModifieesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the mrcotemodifiees
        $mrcotemodifiees = MrCoteModifiee::all();

        // load the view and pass the mrcotemodifiees
        return view('Masomwetu.Report.mrcotemodifiees.index')
            ->with('mrcotemodifiees', $mrcotemodifiees);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/mrcotemodifiees/create.blade.php)
        $mrcotemodifiee = new MrCoteModifiee;
				$mrCotes = MrCote::all();
				$personnels = Personnel::all();
        return view('Masomwetu.Report.mrcotemodifiees.create',compact('mrcotemodifiee','mrCotes','personnels'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'mr_cote_id'=>$request->mr_cote_id,
					'travail'=>$request->travail,
					'old_cote'=>$request->old_cote,
					'new_cote'=>$request->new_cote,
					'date_modif'=>($request->date_modif??''),
					'personnel_id'=>$request->personnel_id,
				];
				$rules = [
				'mr_cote_id'=>'required',
					'travail'=>'required',
					'old_cote'=>'required',
					'new_cote'=>'required',
					'date_modif'=>'required',
					'personnel_id'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$mrcotemodifiee = MrCoteModifiee::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $mrcotemodifiee->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('mrcotemodifiee',$mrcotemodifiee);
					return redirect()->back();
				}return redirect()->route('mrcotemodifiees.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $mrcotemodifiee = MrCoteModifiee::findOrFail($id);
				return view('Masomwetu.Report.mrcotemodifiees.show',compact('mrcotemodifiee'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $mrcotemodifiee = MrCoteModifiee::findOrFail($id);
				$mrCotes = MrCote::all();
				$personnels = Personnel::all();
				return view('Masomwetu.Report.mrcotemodifiees.edit',compact('mrcotemodifiee','mrCotes','personnels'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$mrcotemodifiee = MrCoteModifiee::findOrFail($id);
				$datas = [
				'mr_cote_id'=>$request->mr_cote_id,
					'travail'=>$request->travail,
					'old_cote'=>$request->old_cote,
					'new_cote'=>$request->new_cote,
					'date_modif'=>($request->date_modif??''),
					'personnel_id'=>$request->personnel_id,
				];
				$rules = [
				'mr_cote_id'=>'required',
					'travail'=>'required',
					'old_cote'=>'required',
					'new_cote'=>'required',
					'date_modif'=>'required',
					'personnel_id'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$mrcotemodifiee->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('mrcotemodifiees.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        MrCoteModifiee::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('mrcotemodifiees.index');
    }
}
