<?php

namespace App\Http\Controllers\Masomwetu\Presence;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Presence\Pointage;
use App\Masomwetu\School\Personnel;
use App\Masomwetu\Presence\JustifAbsence; 
class PointagesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the pointages
        $pointages = Pointage::all();

        // load the view and pass the pointages
        return view('Masomwetu.Presence.pointages.index')
            ->with('pointages', $pointages);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/pointages/create.blade.php)
        $pointage = new Pointage;
				$personnels = Personnel::all();
				$justifAbsences = JustifAbsence::all();
        return view('Masomwetu.Presence.pointages.create',compact('pointage','personnels','justifAbsences'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'jour'=>($request->jour??''),
					'arrivee'=>$request->arrivee,
					'sortie'=>$request->sortie,
					'personnel_id'=>$request->personnel_id,
					'justif_absence_id'=>$request->justif_absence_id,
					'arrivee_prevue'=>$request->arrivee_prevue,
					'sortie_prevue'=>$request->sortie_prevue,
					'observation'=>$request->observation,
				];
				$rules = [
				'jour'=>'required',
					'arrivee'=>'',
					'sortie'=>'',
					'personnel_id'=>'required',
					'justif_absence_id'=>'',
					'arrivee_prevue'=>'',
					'sortie_prevue'=>'',
					'observation'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$pointage = Pointage::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $pointage->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('pointage',$pointage);
					return redirect()->back();
				}return redirect()->route('pointages.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $pointage = Pointage::findOrFail($id);
				return view('Masomwetu.Presence.pointages.show',compact('pointage'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $pointage = Pointage::findOrFail($id);
				$personnels = Personnel::all();
				$justifAbsences = JustifAbsence::all();
				return view('Masomwetu.Presence.pointages.edit',compact('pointage','personnels','justifAbsences'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$pointage = Pointage::findOrFail($id);
				$datas = [
				'jour'=>($request->jour??''),
					'arrivee'=>$request->arrivee,
					'sortie'=>$request->sortie,
					'personnel_id'=>$request->personnel_id,
					'justif_absence_id'=>$request->justif_absence_id,
					'arrivee_prevue'=>$request->arrivee_prevue,
					'sortie_prevue'=>$request->sortie_prevue,
					'observation'=>$request->observation,
				];
				$rules = [
				'jour'=>'required',
					'arrivee'=>'',
					'sortie'=>'',
					'personnel_id'=>'required',
					'justif_absence_id'=>'',
					'arrivee_prevue'=>'',
					'sortie_prevue'=>'',
					'observation'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$pointage->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('pointages.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        Pointage::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('pointages.index');
    }
}
