<?php

namespace App\Http\Controllers\Masomwetu\Presence;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Presence\JourOuvrable;
class JourOuvrablesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the jourouvrables
        $jourouvrables = JourOuvrable::all();

        // load the view and pass the jourouvrables
        return view('Masomwetu.Presence.jourouvrables.index')
            ->with('jourouvrables', $jourouvrables);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/jourouvrables/create.blade.php)
        $jourouvrable = new JourOuvrable;
        return view('Masomwetu.Presence.jourouvrables.create',compact('jourouvrable'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'jour_ouvert'=>($request->jour_ouvert??''),
					'heure_arrivee'=>$request->heure_arrivee,
					'heure_sortie'=>$request->heure_sortie,
				];
				$rules = [
				'jour_ouvert'=>'required',
					'heure_arrivee'=>'required',
					'heure_sortie'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$jourouvrable = JourOuvrable::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $jourouvrable->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('jourouvrable',$jourouvrable);
					return redirect()->back();
				}return redirect()->route('jourouvrables.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $jourouvrable = JourOuvrable::findOrFail($id);
				return view('Masomwetu.Presence.jourouvrables.show',compact('jourouvrable'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $jourouvrable = JourOuvrable::findOrFail($id);
				return view('Masomwetu.Presence.jourouvrables.edit',compact('jourouvrable'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$jourouvrable = JourOuvrable::findOrFail($id);
				$datas = [
				'jour_ouvert'=>($request->jour_ouvert??''),
					'heure_arrivee'=>$request->heure_arrivee,
					'heure_sortie'=>$request->heure_sortie,
				];
				$rules = [
				'jour_ouvert'=>'required',
					'heure_arrivee'=>'required',
					'heure_sortie'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$jourouvrable->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('jourouvrables.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        JourOuvrable::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('jourouvrables.index');
    }
}
