<?php

namespace App\Http\Controllers\Masomwetu\Payment;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Payment\MpTypeFrais;
use App\Masomwetu\Payment\MpFrais; 
class MpTypeFraissController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the mptypefraiss
        $mptypefraiss = MpTypeFrais::all();

        // load the view and pass the mptypefraiss
        return view('Masomwetu.Payment.mptypefraiss.index')
            ->with('mptypefraiss', $mptypefraiss);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/mptypefraiss/create.blade.php)
        $mptypefrais = new MpTypeFrais;
        return view('Masomwetu.Payment.mptypefraiss.create',compact('mptypefrais'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'type'=>$request->type,
					'description'=>$request->description,
					'argent'=>$request->argent,
				];
				$rules = [
				'type'=>'required',
					'description'=>'',
					'argent'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$mptypefrais = MpTypeFrais::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $mptypefrais->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('mptypefrais',$mptypefrais);
					return redirect()->back();
				}return redirect()->route('mptypefraiss.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $mptypefrais = MpTypeFrais::findOrFail($id);
				return view('Masomwetu.Payment.mptypefraiss.show',compact('mptypefrais'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $mptypefrais = MpTypeFrais::findOrFail($id);
				return view('Masomwetu.Payment.mptypefraiss.edit',compact('mptypefrais'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$mptypefrais = MpTypeFrais::findOrFail($id);
				$datas = [
				'type'=>$request->type,
					'description'=>$request->description,
					'argent'=>$request->argent,
				];
				$rules = [
				'type'=>'required',
					'description'=>'',
					'argent'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$mptypefrais->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('mptypefraiss.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        MpTypeFrais::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('mptypefraiss.index');
    }
}
