<?php

namespace App\Http\Controllers\Masomwetu\Payment;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Payment\MpFraisPaiement;
use App\Masomwetu\Scholar\MsEleve;
use App\Masomwetu\Payment\MpFraisClasse; 
class MpFraisPaiementsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the mpfraispaiements
        $mpfraispaiements = MpFraisPaiement::all();

        // load the view and pass the mpfraispaiements
        return view('Masomwetu.Payment.mpfraispaiements.index')
            ->with('mpfraispaiements', $mpfraispaiements);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/mpfraispaiements/create.blade.php)
        $mpfraispaiement = new MpFraisPaiement;
				$msEleves = MsEleve::all();
				$mpFraisClasses = MpFraisClasse::all();
        return view('Masomwetu.Payment.mpfraispaiements.create',compact('mpfraispaiement','msEleves','mpFraisClasses'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'ms_eleve_id'=>$request->ms_eleve_id,
					'mp_frais_classe_id'=>$request->mp_frais_classe_id,
					'montant_payer'=>$request->montant_payer,
					'payer_le'=>($request->payer_le??''),
				];
				$rules = [
				'ms_eleve_id'=>'required',
					'mp_frais_classe_id'=>'required',
					'montant_payer'=>'required',
					'payer_le'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$mpfraispaiement = MpFraisPaiement::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $mpfraispaiement->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('mpfraispaiement',$mpfraispaiement);
					return redirect()->back();
				}return redirect()->route('mpfraispaiements.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $mpfraispaiement = MpFraisPaiement::findOrFail($id);
				return view('Masomwetu.Payment.mpfraispaiements.show',compact('mpfraispaiement'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $mpfraispaiement = MpFraisPaiement::findOrFail($id);
				$msEleves = MsEleve::all();
				$mpFraisClasses = MpFraisClasse::all();
				return view('Masomwetu.Payment.mpfraispaiements.edit',compact('mpfraispaiement','msEleves','mpFraisClasses'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$mpfraispaiement = MpFraisPaiement::findOrFail($id);
				$datas = [
				'ms_eleve_id'=>$request->ms_eleve_id,
					'mp_frais_classe_id'=>$request->mp_frais_classe_id,
					'montant_payer'=>$request->montant_payer,
					'payer_le'=>($request->payer_le??''),
				];
				$rules = [
				'ms_eleve_id'=>'required',
					'mp_frais_classe_id'=>'required',
					'montant_payer'=>'required',
					'payer_le'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$mpfraispaiement->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('mpfraispaiements.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        MpFraisPaiement::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('mpfraispaiements.index');
    }
}
