<?php

namespace App\Http\Controllers\Masomwetu\Payment;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Payment\MpFraisClasse;
use App\Masomwetu\Payment\MpFrais;
use App\Masomwetu\Scholar\MsClasse;
use App\Masomwetu\Payment\MpFraisPaiement; 
class MpFraisClassesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the mpfraisclasses
        $mpfraisclasses = MpFraisClasse::all();

        // load the view and pass the mpfraisclasses
        return view('Masomwetu.Payment.mpfraisclasses.index')
            ->with('mpfraisclasses', $mpfraisclasses);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/mpfraisclasses/create.blade.php)
        $mpfraisclasse = new MpFraisClasse;
				$mpFraiss = MpFrais::all();
				$msClasses = MsClasse::all();
        return view('Masomwetu.Payment.mpfraisclasses.create',compact('mpfraisclasse','mpFraiss','msClasses'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'mp_frais_id'=>$request->mp_frais_id,
					'ms_classe_id'=>$request->ms_classe_id,
					'montant'=>$request->montant,
				];
				$rules = [
				'mp_frais_id'=>'required',
					'ms_classe_id'=>'required',
					'montant'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$mpfraisclasse = MpFraisClasse::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $mpfraisclasse->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('mpfraisclasse',$mpfraisclasse);
					return redirect()->back();
				}return redirect()->route('mpfraisclasses.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $mpfraisclasse = MpFraisClasse::findOrFail($id);
				return view('Masomwetu.Payment.mpfraisclasses.show',compact('mpfraisclasse'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $mpfraisclasse = MpFraisClasse::findOrFail($id);
				$mpFraiss = MpFrais::all();
				$msClasses = MsClasse::all();
				return view('Masomwetu.Payment.mpfraisclasses.edit',compact('mpfraisclasse','mpFraiss','msClasses'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$mpfraisclasse = MpFraisClasse::findOrFail($id);
				$datas = [
				'mp_frais_id'=>$request->mp_frais_id,
					'ms_classe_id'=>$request->ms_classe_id,
					'montant'=>$request->montant,
				];
				$rules = [
				'mp_frais_id'=>'required',
					'ms_classe_id'=>'required',
					'montant'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$mpfraisclasse->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('mpfraisclasses.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        MpFraisClasse::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('mpfraisclasses.index');
    }
}
