<?php

namespace App\Http\Controllers\Masomwetu\Disciplinary;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Disciplinary\MotifCommentaire;
use App\Masomwetu\Disciplinary\MdCommentaire; 
class MotifCommentairesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the motifcommentaires
        $motifcommentaires = MotifCommentaire::all();

        // load the view and pass the motifcommentaires
        return view('Masomwetu.Disciplinary.motifcommentaires.index')
            ->with('motifcommentaires', $motifcommentaires);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/motifcommentaires/create.blade.php)
        $motifcommentaire = new MotifCommentaire;
        return view('Masomwetu.Disciplinary.motifcommentaires.create',compact('motifcommentaire'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'motif'=>$request->motif,
					'point'=>$request->point,
				];
				$rules = [
				'motif'=>'required',
					'point'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$motifcommentaire = MotifCommentaire::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $motifcommentaire->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('motifcommentaire',$motifcommentaire);
					return redirect()->back();
				}return redirect()->route('motifcommentaires.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $motifcommentaire = MotifCommentaire::findOrFail($id);
				return view('Masomwetu.Disciplinary.motifcommentaires.show',compact('motifcommentaire'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $motifcommentaire = MotifCommentaire::findOrFail($id);
				return view('Masomwetu.Disciplinary.motifcommentaires.edit',compact('motifcommentaire'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$motifcommentaire = MotifCommentaire::findOrFail($id);
				$datas = [
				'motif'=>$request->motif,
					'point'=>$request->point,
				];
				$rules = [
				'motif'=>'required',
					'point'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$motifcommentaire->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('motifcommentaires.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        MotifCommentaire::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('motifcommentaires.index');
    }
}
