<?php

namespace App\Http\Controllers\Masomwetu\Disciplinary;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Disciplinary\MdEleveRenvoyer;
use App\Masomwetu\Scholar\MsEleve; 
class MdEleveRenvoyersController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the mdeleverenvoyers
        $mdeleverenvoyers = MdEleveRenvoyer::all();

        // load the view and pass the mdeleverenvoyers
        return view('Masomwetu.Disciplinary.mdeleverenvoyers.index')
            ->with('mdeleverenvoyers', $mdeleverenvoyers);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/mdeleverenvoyers/create.blade.php)
        $mdeleverenvoyer = new MdEleveRenvoyer;
				$msEleves = MsEleve::all();
        return view('Masomwetu.Disciplinary.mdeleverenvoyers.create',compact('mdeleverenvoyer','msEleves'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'ms_eleve_id'=>$request->ms_eleve_id,
					'motif'=>$request->motif,
					'detail'=>$request->detail,
					'date_renvoi'=>($request->date_renvoi??''),
					'date_retour'=>($request->date_retour??''),
					'condition'=>$request->condition,
				];
				$rules = [
				'ms_eleve_id'=>'required',
					'motif'=>'required',
					'detail'=>'required',
					'date_renvoi'=>'required',
					'date_retour'=>'',
					'condition'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$mdeleverenvoyer = MdEleveRenvoyer::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $mdeleverenvoyer->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('mdeleverenvoyer',$mdeleverenvoyer);
					return redirect()->back();
				}return redirect()->route('mdeleverenvoyers.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $mdeleverenvoyer = MdEleveRenvoyer::findOrFail($id);
				return view('Masomwetu.Disciplinary.mdeleverenvoyers.show',compact('mdeleverenvoyer'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $mdeleverenvoyer = MdEleveRenvoyer::findOrFail($id);
				$msEleves = MsEleve::all();
				return view('Masomwetu.Disciplinary.mdeleverenvoyers.edit',compact('mdeleverenvoyer','msEleves'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$mdeleverenvoyer = MdEleveRenvoyer::findOrFail($id);
				$datas = [
				'ms_eleve_id'=>$request->ms_eleve_id,
					'motif'=>$request->motif,
					'detail'=>$request->detail,
					'date_renvoi'=>($request->date_renvoi??''),
					'date_retour'=>($request->date_retour??''),
					'condition'=>$request->condition,
				];
				$rules = [
				'ms_eleve_id'=>'required',
					'motif'=>'required',
					'detail'=>'required',
					'date_renvoi'=>'required',
					'date_retour'=>'',
					'condition'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$mdeleverenvoyer->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('mdeleverenvoyers.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        MdEleveRenvoyer::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('mdeleverenvoyers.index');
    }
}
