<?php

namespace App\Http\Controllers\Masomwetu\Disciplinary;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Disciplinary\MdAbsence;
use App\Masomwetu\Scholar\MsEleve;
use App\Masomwetu\Disciplinary\Periode; 
class MdAbsencesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the mdabsences
        $mdabsences = MdAbsence::all();

        // load the view and pass the mdabsences
        return view('Masomwetu.Disciplinary.mdabsences.index')
            ->with('mdabsences', $mdabsences);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/mdabsences/create.blade.php)
        $mdabsence = new MdAbsence;
				$msEleves = MsEleve::all();
				$periodes = Periode::all();
        return view('Masomwetu.Disciplinary.mdabsences.create',compact('mdabsence','msEleves','periodes'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'ms_eleve_id'=>$request->ms_eleve_id,
					'periode_id'=>$request->periode_id,
					'absence_date'=>($request->absence_date??''),
					'justif_date'=>($request->justif_date??''),
					'justif_detail'=>$request->justif_detail,
				];
				$rules = [
				'ms_eleve_id'=>'required',
					'periode_id'=>'required',
					'absence_date'=>'required',
					'justif_date'=>'',
					'justif_detail'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$mdabsence = MdAbsence::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $mdabsence->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('mdabsence',$mdabsence);
					return redirect()->back();
				}return redirect()->route('mdabsences.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $mdabsence = MdAbsence::findOrFail($id);
				return view('Masomwetu.Disciplinary.mdabsences.show',compact('mdabsence'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $mdabsence = MdAbsence::findOrFail($id);
				$msEleves = MsEleve::all();
				$periodes = Periode::all();
				return view('Masomwetu.Disciplinary.mdabsences.edit',compact('mdabsence','msEleves','periodes'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$mdabsence = MdAbsence::findOrFail($id);
				$datas = [
				'ms_eleve_id'=>$request->ms_eleve_id,
					'periode_id'=>$request->periode_id,
					'absence_date'=>($request->absence_date??''),
					'justif_date'=>($request->justif_date??''),
					'justif_detail'=>$request->justif_detail,
				];
				$rules = [
				'ms_eleve_id'=>'required',
					'periode_id'=>'required',
					'absence_date'=>'required',
					'justif_date'=>'',
					'justif_detail'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$mdabsence->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('mdabsences.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        MdAbsence::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('mdabsences.index');
    }
}
