<?php

namespace App\Http\Controllers\Masomwetu\Disciplinary;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Disciplinary\MdAbsJour;
use App\Masomwetu\Scholar\MsClasse;
use App\Masomwetu\Disciplinary\MdAbsence; 
class MdAbsJoursController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the mdabsjours
        $mdabsjours = MdAbsJour::all();

        // load the view and pass the mdabsjours
        return view('Masomwetu.Disciplinary.mdabsjours.index')
            ->with('mdabsjours', $mdabsjours);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/mdabsjours/create.blade.php)
        $mdabsjour = new MdAbsJour;
				$msClasses = MsClasse::all();
        return view('Masomwetu.Disciplinary.mdabsjours.create',compact('mdabsjour','msClasses'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'date_jour'=>($request->date_jour??''),
					'commentaire'=>$request->commentaire,
					'ms_classe_id'=>$request->ms_classe_id,
				];
				$rules = [
				'date_jour'=>'required',
					'commentaire'=>'',
					'ms_classe_id'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$mdabsjour = MdAbsJour::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					if($request->redirectTo=="AJAX")
						return $mdabsjour;
					$id = $mdabsjour->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('mdabsjour',$mdabsjour);
					return redirect()->back();
				}
				return redirect()->route('mdabsjours.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $mdabsjour = MdAbsJour::findOrFail($id);
				return view('Masomwetu.Disciplinary.mdabsjours.show',compact('mdabsjour'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $mdabsjour = MdAbsJour::findOrFail($id);
				$msClasses = MsClasse::all();
				return view('Masomwetu.Disciplinary.mdabsjours.edit',compact('mdabsjour','msClasses'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$mdabsjour = MdAbsJour::findOrFail($id);
				$datas = [
				'date_jour'=>($request->date_jour??''),
					'commentaire'=>$request->commentaire,
					'ms_classe_id'=>$request->ms_classe_id,
				];
				$rules = [
				'date_jour'=>'required',
					'commentaire'=>'',
					'ms_classe_id'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$mdabsjour->update($datas);
				my_flash("Modification effectée avec succès");
				if ($request->has('redirectTo')){
					$id = $mdabsjour->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('mdabsjour',$mdabsjour);
					return redirect()->back();
				}
				return redirect()->route('mdabsjours.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request,$id)
    {
				// 
        MdAbsJour::destroy( $id);
		if ($request->has('redirectTo')){
			return \Redirect::to($request->redirectTo);
		}
		my_flash("Suppression effectée","danger");
		return redirect()->route('mdabsjours.index');
    }
}
