<?php

namespace App\Http\Controllers\Masomwetu\Comptabilite;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Comptabilite\TauxChange;
class TauxChangesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the tauxchanges
        $tauxchanges = TauxChange::all();

        // load the view and pass the tauxchanges
        return view('Masomwetu.Comptabilite.tauxchanges.index')
            ->with('tauxchanges', $tauxchanges);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/tauxchanges/create.blade.php)
        $tauxchange = new TauxChange;
        return view('Masomwetu.Comptabilite.tauxchanges.create',compact('tauxchange'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'usd_cdf'=>$request->usd_cdf,
				];
				$rules = [
				'usd_cdf'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$tauxchange = TauxChange::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					if($request->redirectTo=="AJAX")
						return $tauxchange;
					$id = $tauxchange->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('tauxchange',$tauxchange);
					return redirect()->back();
				}
				return redirect()->route('tauxchanges.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $tauxchange = TauxChange::findOrFail($id);
				return view('Masomwetu.Comptabilite.tauxchanges.show',compact('tauxchange'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $tauxchange = TauxChange::findOrFail($id);
				return view('Masomwetu.Comptabilite.tauxchanges.edit',compact('tauxchange'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$tauxchange = TauxChange::findOrFail($id);
				$datas = [
				'usd_cdf'=>$request->usd_cdf,
				];
				$rules = [
				'usd_cdf'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$tauxchange->update($datas);
				my_flash("Modification effectée avec succès");
				if ($request->has('redirectTo')){
					$id = $tauxchange->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('tauxchange',$tauxchange);
					return redirect()->back();
				}
				return redirect()->route('tauxchanges.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request,$id)
    {
				// 
        TauxChange::destroy( $id);
		if ($request->has('redirectTo')){
			return \Redirect::to($request->redirectTo);
		}
		my_flash("Suppression effectée","danger");
		return redirect()->route('tauxchanges.index');
    }
}
