<?php

namespace App\Http\Controllers\Masomwetu\Comptabilite;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Comptabilite\RapportAnnuel;
class RapportAnnuelsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the rapportannuels
        $rapportannuels = RapportAnnuel::all();

        // load the view and pass the rapportannuels
        return view('Masomwetu.Comptabilite.rapportannuels.index')
            ->with('rapportannuels', $rapportannuels);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/rapportannuels/create.blade.php)
        $rapportannuel = new RapportAnnuel;
        return view('Masomwetu.Comptabilite.rapportannuels.create',compact('rapportannuel'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'report_cdf'=>$request->report_cdf,
					'report_usd'=>$request->report_usd,
					'encaissement_cdf'=>$request->encaissement_cdf,
					'encaissement_usd'=>$request->encaissement_usd,
					'decaissement_cdf'=>$request->decaissement_cdf,
					'decaissement_usd'=>$request->decaissement_usd,
					'annee_rapport'=>$request->annee_rapport,
					'deja_comptabiliser'=>$request->deja_comptabiliser,
					'date_rapport'=>($request->date_rapport??''),
				];
				$rules = [
				'report_cdf'=>'',
					'report_usd'=>'',
					'encaissement_cdf'=>'',
					'encaissement_usd'=>'',
					'decaissement_cdf'=>'',
					'decaissement_usd'=>'',
					'annee_rapport'=>'required',
					'deja_comptabiliser'=>'required',
					'date_rapport'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$rapportannuel = RapportAnnuel::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					if($request->redirectTo=="AJAX")
						return $rapportannuel;
					$id = $rapportannuel->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('rapportannuel',$rapportannuel);
					return redirect()->back();
				}
				return redirect()->route('rapportannuels.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $rapportannuel = RapportAnnuel::findOrFail($id);
				return view('Masomwetu.Comptabilite.rapportannuels.show',compact('rapportannuel'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $rapportannuel = RapportAnnuel::findOrFail($id);
				return view('Masomwetu.Comptabilite.rapportannuels.edit',compact('rapportannuel'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$rapportannuel = RapportAnnuel::findOrFail($id);
				$datas = [
				'report_cdf'=>$request->report_cdf,
					'report_usd'=>$request->report_usd,
					'encaissement_cdf'=>$request->encaissement_cdf,
					'encaissement_usd'=>$request->encaissement_usd,
					'decaissement_cdf'=>$request->decaissement_cdf,
					'decaissement_usd'=>$request->decaissement_usd,
					'annee_rapport'=>$request->annee_rapport,
					'deja_comptabiliser'=>$request->deja_comptabiliser,
					'date_rapport'=>($request->date_rapport??''),
				];
				$rules = [
				'report_cdf'=>'',
					'report_usd'=>'',
					'encaissement_cdf'=>'',
					'encaissement_usd'=>'',
					'decaissement_cdf'=>'',
					'decaissement_usd'=>'',
					'annee_rapport'=>'required',
					'deja_comptabiliser'=>'required',
					'date_rapport'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$rapportannuel->update($datas);
				my_flash("Modification effectée avec succès");
				if ($request->has('redirectTo')){
					$id = $rapportannuel->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('rapportannuel',$rapportannuel);
					return redirect()->back();
				}
				return redirect()->route('rapportannuels.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request,$id)
    {
				// 
        RapportAnnuel::destroy( $id);
		if ($request->has('redirectTo')){
			return \Redirect::to($request->redirectTo);
		}
		my_flash("Suppression effectée","danger");
		return redirect()->route('rapportannuels.index');
    }
}
