<?php

namespace App\Http\Controllers\Masomwetu\Comptabilite;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Comptabilite\MouvementCompte;
use App\Masomwetu\Comptabilite\MouvementCpteUtilise;
use App\Masomwetu\Comptabilite\Compte;
use App\Masomwetu\Sys\User; 
class MouvementComptesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the mouvementcomptes
        $mouvementcomptes = MouvementCompte::all();

        // load the view and pass the mouvementcomptes
        return view('Masomwetu.Comptabilite.mouvementcomptes.index')
            ->with('mouvementcomptes', $mouvementcomptes);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/mouvementcomptes/create.blade.php)
        $mouvementcompte = new MouvementCompte;
				$comptes = Compte::all();
				$users = User::all();
        return view('Masomwetu.Comptabilite.mouvementcomptes.create',compact('mouvementcompte','comptes','users'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'compte_id'=>$request->compte_id,
					'montant_cdf'=>$request->montant_cdf,
					'montant_usd'=>$request->montant_usd,
					'date_mouv'=>($request->date_mouv??''),
					'user_id'=>$request->user_id,
					'deja_comptabiliser'=>$request->deja_comptabiliser,
				];
				$rules = [
				'compte_id'=>'required',
					'montant_cdf'=>'',
					'montant_usd'=>'',
					'date_mouv'=>'required',
					'user_id'=>'required',
					'deja_comptabiliser'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$mouvementcompte = MouvementCompte::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					if($request->redirectTo=="AJAX")
						return $mouvementcompte;
					$id = $mouvementcompte->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('mouvementcompte',$mouvementcompte);
					return redirect()->back();
				}
				return redirect()->route('mouvementcomptes.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $mouvementcompte = MouvementCompte::findOrFail($id);
				return view('Masomwetu.Comptabilite.mouvementcomptes.show',compact('mouvementcompte'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $mouvementcompte = MouvementCompte::findOrFail($id);
				$comptes = Compte::all();
				$users = User::all();
				return view('Masomwetu.Comptabilite.mouvementcomptes.edit',compact('mouvementcompte','comptes','users'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$mouvementcompte = MouvementCompte::findOrFail($id);
				$datas = [
				'compte_id'=>$request->compte_id,
					'montant_cdf'=>$request->montant_cdf,
					'montant_usd'=>$request->montant_usd,
					'date_mouv'=>($request->date_mouv??''),
					'user_id'=>$request->user_id,
					'deja_comptabiliser'=>$request->deja_comptabiliser,
				];
				$rules = [
				'compte_id'=>'required',
					'montant_cdf'=>'',
					'montant_usd'=>'',
					'date_mouv'=>'required',
					'user_id'=>'required',
					'deja_comptabiliser'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$mouvementcompte->update($datas);
				my_flash("Modification effectée avec succès");
				if ($request->has('redirectTo')){
					$id = $mouvementcompte->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('mouvementcompte',$mouvementcompte);
					return redirect()->back();
				}
				return redirect()->route('mouvementcomptes.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request,$id)
    {
		// 
		$m = MouvementCompte::with('mouvementCpteUtilises')->find($id);
		foreach($m->mouvementCpteUtilises as $c)
			MouvementCpteUtilise::destroy( $c->id);
        MouvementCompte::destroy( $id);
		if ($request->has('redirectTo')){
			return \Redirect::to($request->redirectTo);
		}
		my_flash("Suppression effectée","danger");
					return redirect()->back();
		return redirect()->route('mouvementcomptes.index');
    }
}
