<?php

namespace App\Http\Controllers\Masomwetu\Comptabilite;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Comptabilite\CategorieCompte;
use App\Masomwetu\Comptabilite\Compte; 
class CategorieComptesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the categoriecomptes
        $categoriecomptes = CategorieCompte::all();

        // load the view and pass the categoriecomptes
        return view('Masomwetu.Comptabilite.categoriecomptes.index')
            ->with('categoriecomptes', $categoriecomptes);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/categoriecomptes/create.blade.php)
        $categoriecompte = new CategorieCompte;
        return view('Masomwetu.Comptabilite.categoriecomptes.create',compact('categoriecompte'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'categorie'=>$request->categorie,
					'entree'=>$request->entree,
				];
				$rules = [
				'categorie'=>'required',
					'entree'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$categoriecompte = CategorieCompte::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					if($request->redirectTo=="AJAX")
						return $categoriecompte;
					$id = $categoriecompte->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('categoriecompte',$categoriecompte);
					return redirect()->back();
				}
				return redirect()->route('categoriecomptes.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $categoriecompte = CategorieCompte::findOrFail($id);
				return view('Masomwetu.Comptabilite.categoriecomptes.show',compact('categoriecompte'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $categoriecompte = CategorieCompte::findOrFail($id);
				return view('Masomwetu.Comptabilite.categoriecomptes.edit',compact('categoriecompte'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$categoriecompte = CategorieCompte::findOrFail($id);
				$datas = [
				'categorie'=>$request->categorie,
					'entree'=>$request->entree,
				];
				$rules = [
				'categorie'=>'required',
					'entree'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$categoriecompte->update($datas);
				my_flash("Modification effectée avec succès");
				if ($request->has('redirectTo')){
					$id = $categoriecompte->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('categoriecompte',$categoriecompte);
					return redirect()->back();
				}
				return redirect()->route('categoriecomptes.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request,$id)
    {
				// 
        CategorieCompte::destroy( $id);
		if ($request->has('redirectTo')){
			return \Redirect::to($request->redirectTo);
		}
		my_flash("Suppression effectée","danger");
		return redirect()->route('categoriecomptes.index');
    }
}
