<?php

namespace App\Http\Controllers\Masomwetu\Communication;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Communication\McSms;
use App\Masomwetu\Communication\McSmsType; 
class McSmssController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the mcsmss
        $mcsmss = McSms::all();

        // load the view and pass the mcsmss
        return view('Masomwetu.Communication.mcsmss.index')
            ->with('mcsmss', $mcsmss);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/mcsmss/create.blade.php)
        $mcsms = new McSms;
				$mcSmsTypes = McSmsType::all();
        return view('Masomwetu.Communication.mcsmss.create',compact('mcsms','mcSmsTypes'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'telephone'=>$request->telephone,
					'message'=>$request->message,
					'proprietaire'=>$request->proprietaire,
					'status'=>$request->status,
					'date_send'=>($request->date_send??''),
					'mc_sms_type_id'=>$request->mc_sms_type_id,
				];
				$rules = [
				'telephone'=>'required',
					'message'=>'required',
					'proprietaire'=>'required',
					'status'=>'required',
					'date_send'=>'required',
					'mc_sms_type_id'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$mcsms = McSms::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $mcsms->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('mcsms',$mcsms);
					return redirect()->back();
				}return redirect()->route('mcsmss.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $mcsms = McSms::findOrFail($id);
				return view('Masomwetu.Communication.mcsmss.show',compact('mcsms'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $mcsms = McSms::findOrFail($id);
				$mcSmsTypes = McSmsType::all();
				return view('Masomwetu.Communication.mcsmss.edit',compact('mcsms','mcSmsTypes'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$mcsms = McSms::findOrFail($id);
				$datas = [
				'telephone'=>$request->telephone,
					'message'=>$request->message,
					'proprietaire'=>$request->proprietaire,
					'status'=>$request->status,
					'date_send'=>($request->date_send??''),
					'mc_sms_type_id'=>$request->mc_sms_type_id,
				];
				$rules = [
				'telephone'=>'required',
					'message'=>'required',
					'proprietaire'=>'required',
					'status'=>'required',
					'date_send'=>'required',
					'mc_sms_type_id'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$mcsms->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('mcsmss.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        McSms::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('mcsmss.index');
    }
}
