<?php

namespace App\Http\Controllers\Masomwetu\Communication;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Communication\McSmsType;
use App\Masomwetu\Communication\McSms; 
class McSmsTypesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the mcsmstypes
        $mcsmstypes = McSmsType::all();

        // load the view and pass the mcsmstypes
        return view('Masomwetu.Communication.mcsmstypes.index')
            ->with('mcsmstypes', $mcsmstypes);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/mcsmstypes/create.blade.php)
        $mcsmstype = new McSmsType;
        return view('Masomwetu.Communication.mcsmstypes.create',compact('mcsmstype'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'type'=>$request->type,
					'description'=>$request->description,
				];
				$rules = [
				'type'=>'required',
					'description'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$mcsmstype = McSmsType::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $mcsmstype->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('mcsmstype',$mcsmstype);
					return redirect()->back();
				}return redirect()->route('mcsmstypes.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $mcsmstype = McSmsType::findOrFail($id);
				return view('Masomwetu.Communication.mcsmstypes.show',compact('mcsmstype'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $mcsmstype = McSmsType::findOrFail($id);
				return view('Masomwetu.Communication.mcsmstypes.edit',compact('mcsmstype'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$mcsmstype = McSmsType::findOrFail($id);
				$datas = [
				'type'=>$request->type,
					'description'=>$request->description,
				];
				$rules = [
				'type'=>'required',
					'description'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$mcsmstype->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('mcsmstypes.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        McSmsType::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('mcsmstypes.index');
    }
}
