<?php

namespace App\Http\Controllers\Masomwetu\Cash;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Cash\CashCategorie;
use App\Masomwetu\Cash\CashFicheSortie; 
class CashCategoriesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the cashcategories
        $cashcategories = CashCategorie::all();

        // load the view and pass the cashcategories
        return view('Masomwetu.Cash.cashcategories.index')
            ->with('cashcategories', $cashcategories);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/cashcategories/create.blade.php)
        $cashcategorie = new CashCategorie;
        return view('Masomwetu.Cash.cashcategories.create',compact('cashcategorie'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'categorie'=>$request->categorie,
					'description'=>$request->description,
				];
				$rules = [
				'categorie'=>'required',
					'description'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$cashcategorie = CashCategorie::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $cashcategorie->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('cashcategorie',$cashcategorie);
					return redirect()->back();
				}return redirect()->route('cashcategories.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $cashcategorie = CashCategorie::findOrFail($id);
				return view('Masomwetu.Cash.cashcategories.show',compact('cashcategorie'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $cashcategorie = CashCategorie::findOrFail($id);
				return view('Masomwetu.Cash.cashcategories.edit',compact('cashcategorie'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$cashcategorie = CashCategorie::findOrFail($id);
				$datas = [
				'categorie'=>$request->categorie,
					'description'=>$request->description,
				];
				$rules = [
				'categorie'=>'required',
					'description'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$cashcategorie->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('cashcategories.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        CashCategorie::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('cashcategories.index');
    }
}
