<?php

namespace App\Http\Controllers\Masomwetu\Allocation;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Allocation\Materiel;
use App\Masomwetu\Allocation\Emprunt; 
class MaterielsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the materiels
        $materiels = Materiel::all();

        // load the view and pass the materiels
        return view('Masomwetu.Allocation.materiels.index')
            ->with('materiels', $materiels);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/materiels/create.blade.php)
        $materiel = new Materiel;
        return view('Masomwetu.Allocation.materiels.create',compact('materiel'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
					'materiel'=>$request->materiel,
					'quantite'=>$request->quantite,
					''=>$request->,
				];
				$rules = [
					'materiel'=>'required',
					'quantite'=>'',
					''=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$materiel = Materiel::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					if($request->redirectTo=="AJAX")
						return $materiel;
					$id = $materiel->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('materiel',$materiel);
					return redirect()->back();
				}
				return redirect()->route('materiels.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $materiel = Materiel::findOrFail($id);
				return view('Masomwetu.Allocation.materiels.show',compact('materiel'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $materiel = Materiel::findOrFail($id);
				return view('Masomwetu.Allocation.materiels.edit',compact('materiel'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$materiel = Materiel::findOrFail($id);
				$datas = [
					'materiel'=>$request->materiel,
					'quantite'=>$request->quantite,
					''=>$request->,
				];
				$rules = [
					'materiel'=>'required',
					'quantite'=>'',
					''=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$materiel->update($datas);
				my_flash("Modification effectée avec succès");
				if ($request->has('redirectTo')){
					$id = $materiel->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('materiel',$materiel);
					return redirect()->back();
				}
				return redirect()->route('materiels.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request,$id)
    {
				// 
        Materiel::destroy( $id);
		if ($request->has('redirectTo')){
			return \Redirect::to($request->redirectTo);
		}
		my_flash("Suppression effectée","danger");
		return redirect()->route('materiels.index');
    }
}
