<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request; 
use App\Masomwetu\School\Section;
use App\Masomwetu\Salary\SaSalarie;
use App\Masomwetu\Salary\SaRubriquePaie;
use App\Masomwetu\Salary\SaPaiementSalaire;
use App\Masomwetu\Salary\SaOperationSalaire;
use App\Masomwetu\Salary\SaCategorieBulletin;
use App\Masomwetu\Salary\SaRubriqueCategorieBulletin;
use App\Masomwetu\School\Personnel;

use App\Masomwetu\Comptabilite\MouvementCompte;
use App\Masomwetu\Comptabilite\MouvementCpteUtilise;

use App\SysUserRole;
use App\Config;
use App\Masomwetu\Sys\User; 

// le controlleur qui gère l'entrée à toutes les sous applications
class MSalaryController extends Controller
{
		
	private $v_path = 'mes_vues.Salary.';
	
	public function index(){
		$sacategoriebulletins = SaCategorieBulletin::with('saRubriqueCategorieBulletins.saRubriquePaie')/* ->where('actif','1') */->get();
		return $this->addUser($this->v_path.'index', compact('sacategoriebulletins') );
		
	}
	
	public function save_operation(Request $request){
			$datas = [
			'sa_salarie_id'=>$request->sa_salarie_id,
				'sa_paiement_salaire_id'=>$request->sa_paiement_salaire_id,
				'sa_rubrique_categorie_bulletin_id'=>$request->sa_rubrique_categorie_bulletin_id,
				'montant'=>$request->montant,
				'jour'=>$request->jour,
				'mois'=>$request->mois,
			];
			$rules = [
			'sa_salarie_id'=>'required',
				'sa_paiement_salaire_id'=>'required',
				'sa_rubrique_categorie_bulletin_id'=>'required',
				'montant'=>'required',
				'mois'=>'required',
				'jour'=>'required',
			];
			// \Validator::make($datas,$rules)->validate();
			$result = AjaxValidator::validate($datas,$rules);
			if($result!==true){
				$result['result'] = 'error';
				return $result;
			}
			$saoperationsalaire = SaOperationSalaire::create($datas);
			
			if($saoperationsalaire->saRubriqueCategorieBulletin->saRubriquePaie->compte_id)
			    $this->passer_ecriture_avance_salaire($saoperationsalaire);
			
			
			return $saoperationsalaire;	
		$p = SaPaiementSalaire::where('deja_fait',false)->orWhere('deja_fait',null)->first();
		if($p){
		}
		else return ['result'=>'error'];
	}
	
	public function datatable_salary($table="bulletin_users"){
		$table_name =  $table;
	    $ecole_id = \App\Config::getEcoleId();
	    
	    $default['ecole_id'] = $ecole_id;
        $default['bulletin_ecole_id'] = $ecole_id;
        session(['defaultInsertedValues'=>$default]);
		return $this->addUser($this->v_path.'datatables',compact('table_name'));
		
	}
	
	public function passer_ecriture_avance_salaire($saoperationsalaire){
	    $rub = $saoperationsalaire->saRubriqueCategorieBulletin->saRubriquePaie ;
	    $salarier = $saoperationsalaire->saSalarie->personnel;
	    $date_mouv = date('Y-m-d');
		$user_id = \Auth::user()->id;
		$user = User::with('cptComptables.cptSecteur')->find($user_id);
		$secteur_id = $user->cptComptables->count()==1?$user->cptComptables->first()->cpt_secteur_id:3;
		
		$datas = [
			'libelle'=>$salarier->noms.' - '.$rub->libelle.' sur la periode '.$saoperationsalaire->saPaiementSalaire->periode,
			'demander_par'=>$salarier->noms,
			'autoriser_par'=>'',
			'date_mouv'=>$date_mouv,
			'ms_annee_scolaire_id'=>\App\Config::getIdAnnee(),
			'description_mouv'=>'',
			'faire_suivi'=>false,
			'user_id'=>$user_id,
			'cpt_secteur_id'=>$secteur_id,
		];
		$rules = [
			'libelle'=>'required',
			'demander_par'=>'',
			'autoriser_par'=>'',
			'date_mouv'=>'required',
			'ms_annee_scolaire_id'=>'required',
			'description_mouv'=>'',
			'faire_suivi'=>'',
			'user_id'=>'required',
			'cpt_secteur_id'=>'',
		];
		
		$datas_c = [
			'montant'=>$saoperationsalaire->montant,
			'montant_usd'=> null,
			'montant_cdf'=>$saoperationsalaire->montant,
			//'user_id'=>$user_id,
			//'cpt_secteur_id'=>$secteur_id,
			'compte_initial'=>$rub->compte_id, 
			'compte_final'=>null, 
		];
		$rules_c = [
			'montant'=>'required',
			'montant_usd'=>'',
			'montant_cdf'=>'',
			//'user_id'=>'required',
			//'cpt_secteur_id'=>'',
			'compte_initial'=>'', 
			'compte_final'=>'', 
		];
		$f = MouvementCompte::create($datas);

		$datas_c['mouvement_compte_id'] = $f->id;
		$m = MouvementCpteUtilise::create($datas_c);
	}
	
	public function payer(Request $request){ 
		$ecole_id = \App\Config::getEcoleId();
		$saPaiementSalaires = SaPaiementSalaire::where('ecole_id',$ecole_id)->get();
		$sa_paiement_salaire_id = $request->sa_paiement_salaire_id;
		$sasalaries = false;
		$sapaiementsalaire = SaPaiementSalaire::where('id',$sa_paiement_salaire_id)
		->first();
		//for($p=3;$p<102;$p++)
		//	SaSalarie::create(['id'=>$p,'personnel_id'=>$p,'sa_categorie_bulletin_id'=>28,	'actif'=>1]);

		if($sapaiementsalaire){		
			$sasalaries = SaSalarie::with('personnel','saCategorieBulletin.saRubriqueCategorieBulletins.saRubriquePaie','saOperationSalaires.saRubriqueCategorieBulletin.saRubriquePaie')
			->whereHas('personnel',function($r)use($ecole_id){return $r->where('ecole_id',$ecole_id);})
			->whereHas('saCategorieBulletin',function($r)use($ecole_id){return $r->where('ecole_id',$ecole_id);})
			->get()->map(function ($item, $key)  use($sa_paiement_salaire_id) {
				$item->saOperationSalaires = $item->saOperationSalaires
				->where('sa_paiement_salaire_id', $sa_paiement_salaire_id);
				return $item;
			});
		}
		
	    $ecole = \App\Config::$ecole;
	    //dd($ecole);
		$f_sapaiementsalaire = new SaPaiementSalaire;
		//$personnels = collect([]);
		return $this->addUser($this->v_path.'payer', compact('ecole','f_sapaiementsalaire','saPaiementSalaires','sasalaries','sapaiementsalaire') );
		
		
	}
	public function find_rubrique_operation(Request $request){
			$sa_paiement_salaire_id = $request->sa_paiement_salaire_id;
		$salarier = SaSalarie::with(
			[
				'personnel',
				'saOperationSalaires'=>function($r)use($sa_paiement_salaire_id){
					return $r->with('saRubriqueCategorieBulletin.saRubriquePaie')
					->where('sa_paiement_salaire_id',$sa_paiement_salaire_id);
				},
				'saCategorieBulletin.saRubriqueCategorieBulletins.saRubriquePaie'
			])
			->whereHas('personnel',function($r){return $r->where('ecole_id',\App\Config::getEcoleId());})
			->find($request->sa_salarie_id);
		if($salarier){
			$sa_categorie_bulletin_id = $salarier->sa_categorie_bulletin_id;
			$oprs = $salarier->saOperationSalaires->filter(function($v,$k)use($sa_paiement_salaire_id){
				return $v->sa_paiement_salaire_id==$sa_paiement_salaire_id;
			});
			$salarier->saOperationSalaires = $oprs;
			$sa_rubrique_paie_id = $request->sa_rubrique_paie_id;
			$rub = SaRubriqueCategorieBulletin::with('saRubriquePaie','saCategorieBulletin')
			// ->where('sa_rubrique_paie_id',$sa_rubrique_paie_id)
			->where('sa_categorie_bulletin_id',$sa_categorie_bulletin_id)->first();	
			//dd($rub,$oprs,$salarier);
			return ['rub'=>$rub, 'agent'=>$salarier];
		}
		return null;
		
	}
	public function operations(){
		$saoperationsalaire = new SaOperationSalaire;
		$ecole_id = \App\Config::getEcoleId();
		$saSalaries = SaSalarie::whereHas('personnel',function($r)use($ecole_id){return $r->where('ecole_id',$ecole_id);})->get();
			
		$saRubriquePaies = SaRubriquePaie::where('ecole_id',$ecole_id)->get();
		//dd($saRubriquePaies);

		$saPaiementSalaires = SaPaiementSalaire::where('ecole_id',$ecole_id)->get();
        
		return $this->addUser($this->v_path.'operations',compact('saPaiementSalaires','saoperationsalaire','saSalaries','saRubriquePaies'));
		
	}
	public function rapport_paie(){
		
		return $this->addUser($this->v_path.'rapport_paie');
		
	}
	public function voir_les_salaries(){
		$ecole_id = \App\Config::getEcoleId();
		$personnels = Personnel::with('saSalaries.saCategorieBulletin')->where('ecole_id',$ecole_id)->get();
		$saCategorieBulletins = SaCategorieBulletin::where('ecole_id',$ecole_id)->get();
		
		return $this->addUser($this->v_path.'salarie', compact('personnels','saCategorieBulletins') );
		
	}
	
}

