<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;

use \App\Masomwetu\Sys\SysUserRole;
use \App\Masomwetu\Scholar\MsEleve;
use \App\Masomwetu\Scholar\MsClasse;
use \App\Masomwetu\Report\MrCoursPromotion;
use \App\Masomwetu\Report\MrCote;
use \App\Masomwetu\Scholar\MsPromotion;
use \App\Masomwetu\School\Personnel;
use \App\Masomwetu\Report\MrCours;
use \App\Imports\CoteImport;
use \App\Imports\CoursPromotionImport;
use \App\Imports\CoteConduiteImport;
use \App\Imports\CoteAllClassImport;
use \App\Imports\CoteFeuilImport;
use \App\Exports\ImportErrorExport;
use \Excel;
use \App\Config;

// le controlleur qui gère l'entrée à toutes les sous applications
class MReportController extends Controller
{
	private $v_path = 'mes_vues.Report.';
	
	public function index(){
		
		return $this->import_export();//addUser('m_report.index');
	}
	
    public function accueil(){
		$id_annee = Config::getIdAnnee();
		$msClasses = MsClasse::with('msPromotion.section')
							->whereHas('msPromotion', function($q) use($id_annee){								
								$q->where("ms_annee_scolaire_id",$id_annee);									
							})->get();
		$nombre_cours = MrCours::with('mrCoursPromotion.msPromotion.section')
							->whereHas('mrCoursPromotion.msPromotion', function($q) use($id_annee){								
								$q->where("ms_annee_scolaire_id",$id_annee);									
							})->count();
		$nombre_cote=0;
		return $this->addUser($this->v_path.'accueil', compact('msClasses','nombre_cours','nombre_cote'));
	}
	
    public function get_id_cours(Request $r){
		$id_annee = Config::getIdAnnee();
		$ids = MrCours::with('mrCoursPromotion.msPromotion.section')
							->whereHas('mrCoursPromotion.msPromotion', function($q) use($id_annee){								
								$q->where("ms_annee_scolaire_id",$id_annee);									
							})
							->get();
		$tabIdCls = [];
		if($r->cls){
			$tabIdCls = explode('-',$r->cls);
			$ids = $ids->filter(function ($value, $key) use($tabIdCls) {
								return in_array($value->ms_classe_id,$tabIdCls);
							});
		}
		
		$ids = $ids->map(function ($item, $key) {
				return $item->id;
			});
		// dd($ids);
		return $ids;
	}
		
    public function get_nombre_cote(){
		$id_annee = Config::getIdAnnee();
		
		$nombre_cote = MrCote::with('mrCours.mrCoursPromotion.msPromotion.section')
							->whereHas('mrCours.mrCoursPromotion.msPromotion', function($q) use($id_annee){								
								$q->where("ms_annee_scolaire_id",$id_annee);									
							})->count();
		return $nombre_cote;
	}
		
	public function mini(Request $request){
		$travail = $request->travail;
		$s = in_array($request->format,['primaire','ed_base'])?'_prim':'';
		return $this->addUser($this->v_path.'mini_bulletin'.$s);
	}
	public function grand(Request $request,$id_eleve=0){
		$dossier_eleve = $tab=false;
		$s = '';
		if($id_eleve){
			$s = " where id_eleve = $id_eleve ";
			$dossier_eleve = true;
			$req = 'select * from cotes_eleves  '.$s;
			$tab = \DB::select($req);
		}
		$f = $request->format;
		$bulltin_view = $f=="primaire"?'grand_bulletin_prim':($f=="secondaire"?'grand_bulletin':'grand_bulletin_ed_base');
		
		// dd($req);
		return $this->addUser($this->v_path.$bulltin_view,compact('tab','dossier_eleve'));
	}
	
	public function import_export($tab=[]){			
		if(!isset($tab['msClasse']))$tab['msClasse'] = null;
		if(!isset($tab['mrcourspromotions']))$tab['mrcourspromotions'] = null;
			
		$msClasses = MsClasse::all();
		$mrCourss = MrCours::all();
		// dd($mrCourss);
		return $this->addUser($this->v_path.'aligner_cours',array_merge( $tab,compact('msClasses','mrCourss')));
	}
	
	public function cours_cotes($id){
		$mrCours = MrCours::with('msClasse','personnel','mrCoursPromotion.msPromotion.section')->find($id);
		$mrcotes = MrCote::with('msEleve.enfant','mrCours.mrCoursPromotion.msPromotion')->where('mr_cours_id',$id)->get();
		// dd($mrCours);
		return $this->addUser($this->v_path.'cours_cote_classe',compact('mrcotes','mrCours'));
	}
	
	
	public function cours_promotion($id){
		$table = 'cours_promotion';
		$title = 'Importation des cours faite correctement.';
		$mrcourspromotions = MrCoursPromotion::where('ms_promotion_id',$id)->get();
		return $this->import_export(compact('mrcourspromotions','table'));
	}
	
	// ici on souhaite aligner un cours dans une classe et en suite afficher la liste de tous les cours de la classe
	public function aligner(Request $request){
		$this->save_or_update_cours($request);
		
		$msClasse = $mrcourspromotions = null;
		if($ms_classe_id = $request->ms_classe_id){ // si l'id de la classe a ete indiquee
			if($ms_classe_id=='all')
				return redirect()->route('report.cours');
			
			$msClasse = MsClasse::find($ms_classe_id); // on retrouve la classe et les cours qui sont supposes y etre dispenses
			$mrcourspromotions = MrCoursPromotion::with('mrCourss')->where('ms_promotion_id',$msClasse->ms_promotion_id)->get();// 
		}
		$personnels = Personnel::all();
		// return redirect()->back();
		return $this->import_export(compact('personnels','msClasse','mrcourspromotions'));
	}
	
	public function voir_cours_classse($id_classe=0){
		$msClasse = $mrcourspromotions = null;
		if($id_classe){ // si l'id de la classe a ete indiquee
			$msClasse = MsClasse::find($id_classe); // on retrouve la classe et les cours qui sont supposes y etre dispenses
			$mrcourspromotions = MrCoursPromotion::with('mrCourss')->where('ms_promotion_id',$msClasse->ms_promotion_id)->get();// 
		}
		$personnels = Personnel::all();
		return $this->addUser($this->v_path.'cours_classe',compact('personnels','msClasse','mrcourspromotions'));
	}
	
	public function save_or_update_cours(Request $request){
		// on verifie si un enseignant a ete indique, cela voudra dire qu'un cours doit etre aligner ou modifier d'enseignant
		
		if($personnel_id = $request->personnel_id){
			if($cours = MrCours::with('mrCoursPromotion')->find($request->mr_cours_id)){
				$cours->personnel_id = $personnel_id;
				$cours->aligne_cette_annee = $request->aligne_cette_annee?1:0;				
				$cours->save();
				
				$mrCoursPromotion = $cours->mrCoursPromotion;
				$mrCoursPromotion->coter_examen =  $request->coter_examen?1:0;
				$mrCoursPromotion->save();
			}
			else{
				$datas = [
					'mr_cours_promotion_id'=>$request->mr_cours_promotion_id,
					'ms_classe_id'=>$request->ms_classe_id,
					'personnel_id'=>$request->personnel_id,
					'aligne_cette_annee'=>$request->aligne_cette_annee?1:0,
					'actif'=>1,
				];
				$cours = MrCours::create($datas);
				$cours = MrCours::with('mrCoursPromotion')->find($cours->id);
			}
			return $cours ;
		}
		return [];
	}
	public function setCoursCoterExamen(){
		
	}
	public function palmarese(){
		
		return $this->addUser($this->v_path.'palmarese');
	}
	
	public function afficher_cours(){
		$table = 'cours';
		$title = 'LES COURS ALIGNES DANS DIFFERENTES CLASSES';
		$msclasses = MsClasse::with('mrCourss.personnel','mrCourss.mrCoursPromotion')->get();
		return $this->import_export(compact('msclasses','table','title'));
	}

	public function import_cotes(Request $request){
		$tabErreur = [];
		foreach($request->file('select_file') as $file){
			$nomFicher = $file->getClientOriginalName();
			$tab = explode('-',$nomFicher);
			$onlyName = $tab[0].'-'.( $tab[1]??'');
			$classe = ( $tab[2]??'');
			$classe = explode('.',$classe)[0];
			$id = '0';
			// 
			// dd($request);
			// importation des conduites
			if( strpos(strtolower($nomFicher),"conduite" )!==false ){			
				// dd( pathinfo($request->file('select_file')[0]) );	
				Excel::import( new CoteConduiteImport($request->travaux), $file);
				continue;
			}			
			// dd($nomFicher,$file);	
			// importation des cotes
			if('yes'!=$request->grilleSyn and $request->grilleSyn!='all-class'){
				if(count($tab)>=3)
					$id = $tab[ count($tab)-2 ];
				else $id = $request->mr_cours_id;
				// dd("chado",$id,$tab,$nomFicher);		
				if($id and $cr = MrCours::where('id',$id)->first()){
					$coteImport = new CoteImport($cr,$request->travaux);
					Excel::import($coteImport , $file);			
					if(count($t=$coteImport->getErreur()))// retourner les message d'erreur dans une grille excel
						$tabErreur[$onlyName] = $t;
				}
			} 
			else{
				// $coteImport = new CoteImport(0,$request->travail,true);
				// Excel::import( $coteImport, $file);
				// if(count($t=$coteImport->getErreur()))// retourner les message d'erreur dans une grille excel
					// $tabErreur[$onlyName] = $t;
					
					// dd("on passe par ici");
				if($request->grilleSyn=='all-class'){
					$id_annee = \App\Config::getIdAnnee();
					$msClasses = MsClasse::with('msPromotion')
								->whereHas('msPromotion', function($q) use($id_annee){								
									$q->where("ms_annee_scolaire_id",$id_annee);									
								})->get();
					$classe_ids = [];
					foreach($msClasses as $cls)
						$classe_ids[$cls->id] = $cls->classe;
						
					$coteImport = (new CoteAllClassImport($classe_ids,$request->travaux[0]));
					Excel::import( $coteImport, $file);
					$lesImports = $coteImport->getSheets();
					// dd($lesImports);
					foreach($lesImports as $name=>$coIp){
						if(count($t=$coIp->getErreur()))// retourner les message d'erreur dans une grille excel
						{
							$tabErreur[$name] = $t;
						}						
					}
				}
				else{
					// dd("on passe par ici");
					$coteImport = new CoteFeuilImport($request->travaux);
					Excel::import( $coteImport, $file);
					// dd($coteImport->getSheets());
					$TravauxLBL = ",1ère Période,2ème Période,1er Examen,3ème Période,4ème Période,2ème Examen,5ème Période,6ème Période,3ème Examen";
					$TravauxLBL = explode(',',$TravauxLBL);
			
					$lesImports = $coteImport->getSheets();
					foreach($lesImports as $coIp){
						if(count($t=$coIp->getErreur()))// retourner les message d'erreur dans une grille excel
						{
							$onlyName = $TravauxLBL[$coIp->getPeriode()];
							$tabErreur[$classe.' '.$onlyName] = $t;
						}						
					}
				}
					
				
			}
		}
		// dd($tabErreur);
		if(count($tabErreur))
			return (new ImportErrorExport($tabErreur))->download('ImportError.xlsx');
		// dd($id);
		
		return redirect()->back();
		
		// if('no'!=$request->grilleSyn)
			// return redirect()->route('report.aligner');
		// else if($id)
			// return redirect()->route('report.cours.cote',['id'=>$id]);
		// return redirect()->back();
	}
	
	// permet d'aligner tous les cours de toutes les classes d'une promotion
	public function aligner_tous_les_cours_dela_promotion($id_promo){
		$personnel = Personnel::all()->first();
		if(!$personnel){
			$datas = [
				'noms'=>'Enseignant par DEFAUT',
				'genre'=>'M',
				'adresse'=>'',
				'telephone'=>'243243243',
				'mc_fonction_id'=>'',
				'login'=>'log-prof',
				'password'=>'pwd-prof',
			];
			$personnel = Personnel::create($datas);
		}
		
		$mrcourspromotions = MrCoursPromotion::where('ms_promotion_id',$id_promo)->get();
		$msclasses = MsClasse::where('ms_promotion_id',$id_promo)->get();			
		
		foreach($msclasses as $cl){
			foreach($mrcourspromotions as $cr){
				$datas = [
				'mr_cours_promotion_id'=>$cr->id,
				'ms_classe_id'=>$cl->id,
				'personnel_id'=>$personnel->id,
				'aligne_cette_annee'=>($cr->aligner??1),
				'actif'=>1,
				];
				MrCours::create($datas);				
			}
		}
	}
	
	
	public function import_cours(Request $request){
		$file = $request->file('select_file');
		 // dd( $request);
		$this->validate($request,[
			// 'ms_classe_id' => 'required',
			// 'select_file' => 'required|mimes:xls,xlsx'
			'select_file' => 'required'
		]);/*  */
		if($request->ms_classe_id and $request->ms_classe_id!='all' and !is_array($file)){
			$classe = MsClasse::find($request->ms_classe_id);
			$id = $classe->ms_promotion_id;
			
			Excel::import( new CoursPromotionImport($id), $file); // on importe
			$this->aligner_tous_les_cours_dela_promotion($id); // on importe tous les cours de la promotion dans toutes les classes de la promotion
		
		}
		else {
			foreach($request->file('select_file') as $file){
				$file_name = $file->getClientOriginalName();
				$tab = explode('_',$file_name);
				if(count($tab)>=3){
					$id = $tab[ count($tab)-2 ];
					Excel::import( new CoursPromotionImport($id), $file); // on importe
					$this->aligner_tous_les_cours_dela_promotion($id); // on importe tous les cours de la promotion dans toutes les classes de la promotion
				}		
			}
			return redirect()->back();
		}
		
		// route('report.cours');// on retourne les cours de la promotion
	}
				
		
}

