<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use \App\Masomwetu\Payment\MpTypeFrais;
use \App\Masomwetu\Payment\MpFraisPaiement;
use \App\Masomwetu\Payment\MpFrais;
use \App\Masomwetu\Payment\MpFraisClasse;
use \App\Masomwetu\Payment\MpRecu;
use App\Masomwetu\Payment\MpFraisPaiementExpetionnel;
use App\Masomwetu\Payment\MpFraisInclu;
use App\Masomwetu\Payment\MpFraisIncluNom;
use \App\Masomwetu\Sys\SysUserRole;
use \App\Masomwetu\Scholar\MsPromotion;
use \App\Masomwetu\Scholar\MsEleve;
use \App\Masomwetu\Scholar\MsInscription;
use \App\Masomwetu\Scholar\MsClasse;
use \App\Masomwetu\Sys\Parametre;
use \App\Masomwetu\Comptabilite\Compte;
use \App\Masomwetu\Scholar\MsEleveDeroger;
use \App\Config;

class MPaymentController extends Controller
{
	private $v_path = 'mes_vues.Payment.';
	
	/* 
	private function addUser($path,$tab=[]){
		$sysUserRole = Config::initUser() ;
		return view($path, array_merge( $tab,compact('sysUserRole')) );
	} */
		
    public function faire_payer(){
		$id_annee = Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		/*$mpFrais = MpFrais::with('mpFraisClasses.msClasse')
		    ->whereHas('mpFraisClasses',function($q)use($id_annee){return $q->where('ms_annee_scolaire_id',$id_annee);})
		    ->whereHas('mpFraisClasses.msClasse',function($q)use($ecole_id){return $q->where('ecole_id',$ecole_id);})
		    ->get();*/
		$mpFrais = MpFrais::with('mpFraisClasses.msClasse')
			->whereHas('mpFraisClasses',function($q)use($id_annee,$ecole_id){ 
			    return $q->whereHas('msClasse',function($q)use($ecole_id){ return $q->where('ecole_id',$ecole_id); })
    			->where('ms_annee_scolaire_id',$id_annee); }
    		)->get();
    		
		
		// $msEleves = MsEleve::with('mpFraisPaiementExpetionnels','enfant','msClasse.msPromotion.section')->get();
		$par_carte = false;
		return $this->addUser($this->v_path.'paiement', compact('par_carte','mpFrais'));
	}
	
    public function accueil(){
		$annee_id = Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		$mpfraispaiements = MpFraisPaiement::with('mpFraisClasse.msClasse')
		->where("payer_le",date("Y-m-d"))
		->whereHas('mpFraisClasse.msClasse',function($q)use($ecole_id){return $q->where('ecole_id',$ecole_id);})
		//->whereHas('mpFraisClasse',function($q)use($annee_id){return $q->where('ms_annee_scolaire_id',$annee_id);})
		->get();
		
		$nombre_paiement = $mpfraispaiements->count();
		return $this->addUser($this->v_path.'accueil', compact('nombre_paiement'));
	}
		
    public function faire_payer_via_carte(){
		$mpTypeFraiss = MpTypeFrais::All(); 
		$par_carte = true;
		return $this->addUser($this->v_path.'paiement', compact('par_carte','mpTypeFraiss'/* ,'msEleves' */));
	}
		
	public function payer_frais_importation(Request $request)
    {
		$p = new \App\Imports\PaiementImport;
		\Excel::import($p, $request->file('select_file'));
		if($p->erreur){
			$table=''; 
			foreach($p->erreur as $e){
				$table.='<tr><td>'.implode('</td><td>',$e).'</td></tr>';
			}
			return "<table border=1 >$table</table>";
		}
			
		return  redirect()->back();
	}
	
	
	public function payer_frais(Request $request)
    {
		//ms_sms("970521106","P20200552 ILUNGA MUTOMBO XXX A PAYE 1000 CDF pour MIN-OCT");
		// 
		//dd($request);
		$tab_frais = $request->id_frais;
		$tab_eleve = $request->id_eleve;
		$message ="";
		$send_sms = $request->send_sms;
		if( !is_array($tab_eleve) ){
			$result = "fail";
			$message = "Resélectionnez les élèves svp!";
		}
		else if( !is_array($tab_frais) ){
			if($request->montant_payer_cdf_solde or $request->montant_payer_usd_solde)
				return $this->payer_les_frais_en_retard($request ,$send_sms);
			$result = "fail";
			$message = "Resélectionnez les frais svp!";
		}
		else{
			// $tab_frais = $this->trier_frais_apeyer_par_priorite();// du plus prioritaire au moins prioritaire
			
			foreach($tab_eleve as $id_eleve){				
				if($id_eleve=="-")continue;
				$return = $this->verifier_eleve_el_payer($request,$id_eleve,$tab_frais,$send_sms);
				$message .= count(isset($return['result'])?$return['result']:[])? implode("<hr>",$return['result']):"";
			}
			$result = $message?"fail":"success";
		}
		
		$id_paiements = $this->id_paiements;
		$id_eleves = $this->id_eleves;
		// dd(compact('result','message','id_paiements','id_eleves'));
		
        return compact('result','message','id_paiements','id_eleves');
				
	}
	
	public function supprimer_paiement(Request $request){
		
		$result = 'success';
		$message='';
		if($request->sup_recu){
			$recu = MpRecu::with('mpFraisPaiements')->find($request->mp_recu_id);
			if($recu){
				foreach($recu->mpFraisPaiements as $p)
					MpFraisPaiement::destroy($p->id);
				MpRecu::destroy($request->mp_recu_id);
			}
			else{ 
				$result = "fail";
				$message="Ce paiement est déja supprimé!";
			}
		}
		else MpFraisPaiement::destroy($request->mp_frais_paiement_id);
		return compact('result','message');
		
	}

	public function verifier_eleve_el_payer($request,$id_eleve,$tab_frais,$send_sms){
		$ecole = Config::getEcole();
		$id_annee = Config::getIdAnnee();
		$observation = $request->observation.' !! ';
		$date = $request->date??date('Y-m-d');
		$return = ['result'=>[],'mp'=>[],'sms_text'=>[],'recu'=>[]];
		$eleve = MsEleve::with('mpFraisPaiementExpetionnels','msClasse','enfant','tuteur')->find($id_eleve);
		foreach($tab_frais as $id_frais){
			if($id_frais=="-")continue;
			$montant_cdf = (double)$request->get("montant_payer_cdf_".$id_frais);
			$montant_usd = (double)$request->get("montant_payer_usd_".$id_frais);
			//dd($eleve,$id_frais,$montant_cdf, $montant_usd,$tab_frais,$send_sms,$return);
			
			$return = $this->payer($eleve,$id_frais,$montant_cdf, $montant_usd,$tab_frais,$send_sms,$return,$date);
			
		}
		if(isset($return['result']) and count($return['mp'])){
			$recu = $this->create_recu($id_eleve,$date,$observation);
			foreach($return['mp'] as $p){
				if($p)$p->update(['mp_recu_id'=>$recu->id]);
			}
			$return['recu'] =  $recu->id;
			$this->id_paiements[] = $recu->id;
			$this->id_eleves[] = $id_eleve;	
		}
		if(isset($return['sms_text']) and count($return['sms_text']) and $send_sms and ($tut = $eleve->tuteur??false) and $tut->telephone ){
			$enfant = $eleve->enfant;
			$noms = "$enfant->nom $enfant->postnom $enfant->prenom";
			$classe = $eleve->msClasse->classe;
			$sms_text = "$noms $classe A PAYE ".implode("; ",$return['sms_text'])." \nLA DIRECTION";
			$num = $tut->telephone;
			// $msg = $sms_text.' xxxxxxxxxxxxxxxxxxx '.$num;
			ms_sms($num,$sms_text);
		}
		return $return;
	}
	// retrouver tous les frais non payer de priorite inferieur
	public function infos_eleve($id=0,$mp_type_frais_id=0){
	    /// $id = str_replace("-","6",$id);
		$id_annee = Config::getIdAnnee();
		$msEleve = MsEleve::with('msClasse','msPromotion','msAnneeScolaire','enfant')->find($id);
		if($msEleve){
			if($mp_type_frais_id===0)
				return ['id'=>$msEleve->id];
			
			$eleve = $msEleve->enfant->nom.' '.$msEleve->enfant->postnom.' '.$msEleve->enfant->prenom.' '.$msEleve->enfant->genre.' ';
			$classe = $msEleve->msClasse->classe;
			$src = asset($msEleve->img?('storage/mseleve/img/'.$msEleve->img):'img/users25.png');
			
			$msEleve = MsEleve::with('mpFraisPaiementExpetionnels','mpFraisPaiements.mpFraisClasse.mpFrais.mpTypeFrais')->find($id);
			$ms_classe_id = $msEleve->ms_classe_id;
			$id_annee = $msEleve->ms_annee_scolaire_id;
			$req = 'SELECT fc.id,fc.ms_annee_scolaire_id
			,fc.taux, fc.montant_usd, fc.montant_cdf
			,(fc.montant - ifnull(SUM(mp_frais_paiements.montant_payer),0)) peyer 
			,mp_frais.mp_type_frais_id,mp_frais.frais
			,montant_fixer
			FROM `mp_frais_classes` fc
			INNER JOIN mp_frais on mp_frais.id = fc.mp_frais_id 
			and mp_frais.mp_type_frais_id='.$mp_type_frais_id.' and fc.ms_annee_scolaire_id=\''.$id_annee.'\'
			LEFT JOIN mp_frais_paiements ON mp_frais_paiements.ms_eleve_id = '.$id.' and fc.id = mp_frais_paiements.mp_frais_classe_id
			LEFT JOIN mp_frais_paiement_expetionnels fexp ON mp_frais_paiements.ms_eleve_id = fexp.ms_eleve_id and fc.id = fexp.mp_frais_classe_id
			GROUP BY mp_frais_paiements.ms_eleve_id, fc.ms_classe_id,fc.id,fc.montant,montant_fixer
			HAVING fc.ms_classe_id='.$ms_classe_id.' and 0 <  peyer and fc.ms_annee_scolaire_id=\''.$id_annee.'\'
			ORDER BY mp_frais.priorite ASC limit 1';
			//echo $req;
			
			
			$tab = \DB::select($req);
			$true = true;
			if(!count($tab)) {
				$selected_frais=false;
			}
			else $selected_frais = $tab[0];
			$ms_annee_scolaire_id = $id_annee;
			$arrierer = $this->arrierer_paiement($msEleve->enfant->id,$msEleve->id);
			
			return view($this->v_path.'partials._dossier', compact('msEleve','selected_frais','arrierer','ms_annee_scolaire_id') );			
		}
		else {
			$message = 'Erreur de scan AUCUN ELEVE TROUVE!';
			return compact('message');
		}
	}

	// ajout de frais exceptionnel
	public function frais_optionnel(Request $request){
		$user_id = \Auth::user()->id;
	    
		$id_annee = Config::getIdAnnee(); 
		$ecole_id = Config::getEcoleId();
		$msClasses = MsClasse::with('msPromotion')->where('ecole_id',$ecole_id)->get(); 
		
		$mpFraiss =  $msEleves=[]; 
		 
		if($request->mp_frais_id and $request->ms_eleve_id){
		    foreach($request->ms_eleve_id as $id){
		        $data=[]; 
		        foreach($request->mp_frais_id as $f) 
		            $data[]=['ms_eleve_id'=>$id,'mp_frais_id'=>$f];
		        \DB::table('mp_frais_optionnels')->insert($data);
		        /*->updateOrInsert(
                    ['email' => 'john@example.com', 'name' => 'John'],
                    ['votes' => '2']
                ); */
		    }
		}
		
		$mpFraiss = MpFrais::with('mpFraisClasses.msClasse')
		    ->whereHas('mpFraisClasses',function($q)use($id_annee){return $q->where('ms_annee_scolaire_id',$id_annee);})
		    ->whereHas('mpFraisClasses.msClasse',function($q)use($ecole_id){return $q->where('ecole_id',$ecole_id);})
		    ->get();
		
		if($request->ms_classe_id){
		    $frais_t =""; 
		    $t = $request->ms_classe_id;
    		$id_cls = implode(",",$t);
		    $req="select el.id,classe,matricule,nom,postnom,prenom,genre __S__
    		from bulletin_ms_eleves partition (p$ecole_id)  el
            inner join enfants ef on el.enfant_id=ef.id 
            inner join bulletin_ms_classes cl on cl.id = el.ms_classe_id 
            __FR__
            where el.ms_annee_scolaire_id = $id_annee and el.etat='Actif' and cl.id in ($id_cls) ";
            
            
            $__FR__ = '';
            $__S__ = ",'' as mp_frais_id,'' as frais"; 
            if($request->mp_frais_id){
		        $__FR__ = "left join mp_frais_optionnels fo on fo.ms_eleve_id=el.id and fo.mp_frais_id in (".implode(",",$request->mp_frais_id).") left join mp_frais f on f.id=fo.mp_frais_id";
		        $__S__ = ",fo.mp_frais_id,f.frais";
            }
            $req = str_replace("__S__",$__S__,$req);
            $req = str_replace("__FR__",$__FR__,$req);
    		$msEleves = \DB::select($req);
		}
		
		return $this->addUser($this->v_path.'frais_optionnel', compact('mpFraiss','msClasses','msEleves'));
	}

	// ajout de frais exceptionnel
	public function creer_frais_exceptionnel(Request $request){
		$user_id = \Auth::user()->id;
		$data = [
			'ms_eleve_id'=>$request->ms_eleve_id,
			'mp_frais_classe_id'=>$request->mp_frais_classe_id,
			'montant_fixer'=>$request->montant_fixer,
			'raison'=>$request->raison,
			'user_id'=>$user_id,
		];
		$rules = [];
		$rules['ms_eleve_id']='required|numeric';
		$rules['mp_frais_classe_id']='required|numeric';			
		$rules['montant_fixer']='numeric';			
		$rules['raison']='required|min:3';
		
		
		//dd($request);
		// on exécute les régles de validation sur les données
		$result = AjaxValidator::validate($data,$rules);
		if($result!==true)
			return $result;

		$fc = MpFraisPaiementExpetionnel::firstOrcreate(['ms_eleve_id'=>$request->ms_eleve_id,'mp_frais_classe_id'=>$request->mp_frais_classe_id],$data);
		if(!$fc->waRecentlyCreated)
			$fc->update($data);
		$result = 'success';
		return compact('result');
		//return "Operation effectuee!!";
	}
	// validation d'un paiement sur les arriere
	public function valider_paiement_arrierer($request){
		return $this->valider_paiement_arrierer_val(
			$request->ms_eleve_id,
			$request->mp_type_frais_id,
			$request->mp_frais_classe_id,
			$request->montant_payer_cdf??0,
			$request->montant_payer_usd??0,
			$request->send_sms,
			$request->inscription,
			$request->date,
			$request->observation);
	}

	public function valider_paiement_arrierer_val($ms_eleve_id,$mp_type_frais_id,$mp_frais_classe_id,$montant_cdf,$montant_usd,$send_sms,$inscription=false, $date_payer = false ,$observation=''){
		//$ms_eleve_id = $request->ms_eleve_id;
		//$mp_type_frais_id = $request->mp_type_frais_id;
		$date = $date_payer??date("Y-m-d");
		$user_id = \Auth::user()->id;
		//dd($request);
		$msEleve = $eleve = MsEleve::with('msClasse','enfant','tuteur')->find($ms_eleve_id);
		$classe = $msEleve->msClasse->classe;

		$eleve_id = $msEleve->id;
		if($inscription=='ok')$eleve_id=0;
		$arrierer = $this->arrierer_paiement($msEleve->enfant->id,$eleve_id);

		//$mp_frais_classe_id = $request->mp_frais_classe_id;
		$dette = collect($arrierer)->firstWhere('mp_frais_classe_id',$mp_frais_classe_id);
		$dette_ms_eleve_id = $dette->eleve_id;
		$mpFraisClasse = MpFraisClasse::find($mp_frais_classe_id);
		$compte = $this->trouver_classe_comptable($mp_frais_classe_id, $date ); //
		$reste_a_peyr = $dette->reste;
		$frais = $dette->frais;
		
		//$montant_cdf = $request->montant_payer_cdf??0;
		//$montant_usd = $request->montant_payer_usd??0;
		$montant_cdf_usd = $montant_cdf + $montant_usd*$mpFraisClasse->taux;
		
		// $str .= $lg->frais.' '. ($lg->peyer). $lg->devise.'<br/>';
		if($montant_cdf_usd){
			if($montant_cdf_usd>$reste_a_peyr){
				$message="Montant trop grand ".chiffre($montant_cdf_usd)." !!!";
				return compact('false','message');
			}
			$montant = $montant_cdf_usd;
		}
		else {
			$montant = $reste_a_peyr;
			// determiner la monnaie prise en charge
			if($mpFraisClasse->montant_usd){
				$montant_usd = (int)($montant / $mpFraisClasse->taux);
				$montant_usd = $montant_usd - ($montant_usd % 5);// on garde un multiple de 5$
				$montant_cdf = $montant - ($montant_usd * $mpFraisClasse->taux) + (($montant_usd % 5)*$mpFraisClasse->taux);
			}	
			else 
				$montant_cdf = $montant ;
		}

		//dd($ms_eleve_id,$mp_frais_classe_id,$montant,$montant_cdf,$montant_usd,$date,$compte,$user_id);
		$recu = $this->create_recu($dette_ms_eleve_id,$date,$observation.($observation?' !! ':''));
		//dd($arrierer,$dette,$dette_ms_eleve_id,$mp_frais_classe_id);
		$result = $this->inser_paiement($dette_ms_eleve_id,$mp_frais_classe_id,$montant,$montant_cdf,$montant_usd,$date,$compte,$user_id);
		if(is_string($result)){
		    $message = $result ;
		    return compact('message');
		}
		$sms_derrog = isset($result['derrogations'])?' MERCI D\'HONORER VOTRE DERROGATION':'';
		$mp = $result['mp'];
		if($mp)
			$mp->update(['mp_recu_id'=>$recu->id]);
		if($send_sms and ($tut = $msEleve->tuteur??false) and $tut->telephone ){
			$num = $tut->telephone;
			$nom = $msEleve->enfant->nom." ".($msEleve->enfant->prenom?$msEleve->enfant->prenom:$msEleve->enfant->postnom);
			// $ecole = Config::getEcole();
			$sms_text = "$nom $classe A PAYE ".($montant_cdf?"$montant_cdf CDF ":"")." ".($montant_usd?(($montant_cdf?"et ":"")."$montant_usd USD "):"")." : $frais $sms_derrog \nLA DIRECTION";
			// $msg = "L'enfant ".$msEleve->enfant->nom." a été en retard de $nbr min.";
			ms_sms($num,$sms_text);
			// dd($num,$sms_text);
			
		}
		//else dd("$num,$sms_text");
		$id = $recu->id;
		//$this->informer_le_promoteur();
		return compact('ms_eleve_id','id','eleve','classe');
	}

	// retrouver tous les frais non payer de priorite inferieur
	public function payer_par_carte(Request $request){
		
		$ms_eleve_id = $request->ms_eleve_id;
		$mp_type_frais_id = $request->mp_type_frais_id;
		$date = date("Y-m-d");
		$user_id = \Auth::user()->id;
		
		if(!$ms_eleve_id or !$mp_type_frais_id){
			$message = 'Scannez une carte et Indiquez le type de frais SVP!';
			return compact('message');
		}
		
		$msEleve = MsEleve::with('msClasse','enfant','tuteur')->find($ms_eleve_id);
		$eleve = $msEleve->enfant->nom.' '.$msEleve->enfant->postnom.' '.$msEleve->enfant->prenom.' '.$msEleve->enfant->genre.' ';
		$classe = $msEleve->msClasse->classe;
		
		if($request->arrierer_eleve_id){
			return $this->valider_paiement_arrierer($request);
		}
		
		$ms_classe_id = $msEleve->ms_classe_id;
	
		$req = 'SELECT mp_frais_classes.id
		,mp_frais_classes.taux, mp_frais_classes.montant_usd, mp_frais_classes.montant_cdf
		,(ifnull(fexp.montant_fixer,mp_frais_classes.montant) - ifnull(SUM(mp_frais_paiements.montant_payer),0)) peyer 
		,mp_frais.mp_type_frais_id,mp_frais.frais
		FROM `mp_frais_classes` 
		INNER JOIN mp_frais on mp_frais.id = mp_frais_classes.mp_frais_id 
		and mp_frais.mp_type_frais_id='.$mp_type_frais_id.' and mp_frais_classes.ms_annee_scolaire_id=\''.$msEleve->ms_annee_scolaire_id.'\'
		LEFT JOIN mp_frais_paiements ON mp_frais_paiements.ms_eleve_id = '.$ms_eleve_id.'  and mp_frais_classes.id = mp_frais_paiements.mp_frais_classe_id
		LEFT JOIN mp_frais_paiement_expetionnels fexp ON fexp.ms_eleve_id = '.$ms_eleve_id.' and mp_frais_classes.id = fexp.mp_frais_classe_id
		GROUP BY mp_frais_paiements.ms_eleve_id, mp_frais_classes.ms_classe_id,mp_frais_classes.id,mp_frais_classes.montant
		HAVING mp_frais_classes.ms_classe_id='.$ms_classe_id.' and 0 <  peyer
		ORDER BY mp_frais.priorite ASC limit 1';
		
		$tab = \DB::select($req);
		//dd($req,$tab,$request);
		$true = true;
		if(!count($tab)) {
			return compact('true','eleve','classe');
		}
		
		$false = false;
		$str = "doit d'abord payer  ";
		$observation = $request->observation;
		
		foreach($tab as $lg){ // cette boucle ne tournera qu'une seule fois
			$montant_cdf = $request->montant_payer_cdf??0;
			$montant_usd = $request->montant_payer_usd??0;
			$montant_cdf_usd = $montant_cdf + $montant_usd*$lg->taux;
			// $str .= $lg->frais.' '. ($lg->peyer). $lg->devise.'<br/>';
			if($montant_cdf_usd){
				if($montant_cdf_usd>$lg->peyer){
					$message="Montant trop grand ".chiffre($montant_cdf_usd)." !!!";
					return compact('false','message');
				}
				$montant = $montant_cdf_usd;
			}
			else {
				$montant = $lg->peyer;
				// determiner la monnaie prise en charge
				if($lg->montant_usd){
					$montant_usd = (int)($montant / $lg->taux);
					$montant_usd = $montant_usd - ($montant_usd % 5);// on garde un multiple de 5$
					$montant_cdf = $montant - ($montant_usd * $lg->taux) + (($montant_usd % 5)*$lg->taux);
				}	
				else 
					$montant_cdf = $montant ;
			}
			// dd($request);
			// trouver la compte auquel associe le paiement en cours
			$compte = $this->trouver_classe_comptable($lg->id, $date ); //
			// enregistrement du frais
			$recu = $this->create_recu($ms_eleve_id,$date,$observation.($observation?' !! ':''));
			$result = $this->inser_paiement($ms_eleve_id,$lg->id,$montant,$montant_cdf,$montant_usd,$date,$compte,$user_id);
			if(is_string($result)){
			    $message = $result ;
			    return compact('message');
			}else{
    			$sms_derrog = isset($result['derrogations'])?' MERCI D\'HONORER VOTRE DERROGATION':'';
    			$mp = $result['mp'];
    			if($mp)
    				$mp->update(['mp_recu_id'=>$recu->id]);
    			// dd($sms_derrog);
    			//
    			// if(($tut = $el->tuteur) and $tut->telephone ){
    			if($request->send_sms and ($tut = $msEleve->tuteur??false) and $tut->telephone ){
    				$num = $tut->telephone;
    				$nom = $msEleve->enfant->nom." ".($msEleve->enfant->prenom?$msEleve->enfant->prenom:$msEleve->enfant->postnom);
    				// $ecole = Config::getEcole();
    				$sms_text = "$nom $classe A PAYE ".($montant_cdf?"$montant_cdf CDF ":"")." ".($montant_usd?(($montant_cdf?"et ":"")."$montant_usd USD "):"")." : $lg->frais $sms_derrog \nLA DIRECTION";
    				// $msg = "L'enfant ".$msEleve->enfant->nom." a été en retard de $nbr min.";
    				ms_sms($num,$sms_text);
    				// dd($num,$sms_text);
    				
    			}
    			//else dd("$num,$sms_text");
    			$id = $recu->id;
    			//$this->informer_le_promoteur();
    			return compact('ms_eleve_id','id','eleve','classe');
			}
		}	
		return compact('false');
		
	}

	function create_recu($ms_eleve_id,$date='',$obs='',$num_recu=null){
	    
		$ecole_id = Config::getEcoleId();
		if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
			$ip = $_SERVER['HTTP_CLIENT_IP'];
		} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
			$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
		} else {
			$ip = $_SERVER['REMOTE_ADDR'];
		}
		
		$obs.=gethostbyaddr($ip)."/$ip";
		
		$user_id = \Auth::user()->id;
		$datas = [
			'date_recu'=>$date??date('Y-m-d H:i:s'),
				'num_recu'=>$num_recu,
				'ms_eleve_id'=>$ms_eleve_id,
				// 'montant_recu_usd'=>$montant_recu_usd,
				// 'montant_recu_cdf'=>$montant_recu_cdf,
				// 'montant_recu'=>$montant_recu,
				'user_id'=>$user_id,
				'ms_annee_scolaire_id'=>Config::getIdAnnee(),
				'observation'=>$obs,
				'ecoleid'=>$ecole_id
			];
			if($num_recu)
			$mprecu = MpRecu::firstOrCreate([
				'date_recu'=>$date??date('Y-m-d H:i:s'),
				'num_recu'=>$num_recu,
				'ms_eleve_id'=>$ms_eleve_id],$datas);
			else {
				$mprecu = MpRecu::create($datas);
				$mprecu->num_recu = sprintf('%04.d',$mprecu->id);//'-'.date('y')
				$mprecu->save();
			}				
			return $mprecu;
	}
	
	function trouver_classe_comptable($frais_classe_id, $date ){
		$frais_classe = MpFraisClasse::with('mpFrais')->find($frais_classe_id);//
		if($frais_classe->mpFrais->multicompte){
			if($frais_classe->compte_avant and $date < $frais_classe->mpFrais->date_debut_paiement){
				return $frais_classe->compte_avant;
			}
			else if($frais_classe->compte_apres and $date > $frais_classe->mpFrais->date_fin_paiement){
				return $frais_classe->compte_apres;
			}
			return $frais_classe->compte;
		}
		else return $frais_classe->compte;
	}

	public function informer_le_promoteur(){
		$date = date("Y-m-01");
		$som_mo = $this->montant_des_minerval_du_mois();
		$som_jr = $this->montant_des_minerval_du_jour();
		$msg = "Bonjour Mr le Promo. Montant paye aujourd'hui ".chiffre($som_jr)."CDF. Total du Mois depuis $date ".chiffre($som_mo)."CDF MASOMWETU-CS.ELIEL";
		
		ms_sms("243971695208",$msg);
		
		$param = Parametre::where('name','INFORMER_PROMO')->where('active',true)->first();
		if($param){
			$tel_promo = $param['value'];
			ms_sms($tel_promo,$msg);
		}
		
	}
	private function montant_des_minerval_du_jour(){
		$date = date("Y-m-d");
		
		$annee_id = Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		
		$mp_type_frais_id = 1;
		return MpFraisPaiement::with('mpFraisClasse.mpFrais','mpFraisClasse.msClasse')
		    ->whereHas('mpFraisClasse.msClasse',function($q)use($ecole_id){return $q->where('ecole_id',$ecole_id);})
			//->whereHas('mpFraisClasse',function($q)use($annee_id){return $q->where('ms_annee_scolaire_id',$annee_id);})
		    ->where('payer_le',$date)->get()
				->filter(function($p,$k) use($mp_type_frais_id){
					// dd($p,$k);
					$ok = ($p->mpFraisClasse->mpFrais)??false;
					if($ok)
						return ($p->mpFraisClasse->mpFrais->mp_type_frais_id == $mp_type_frais_id );
					return false;
					})->sum('montant_payer');
		
	}
	private function montant_des_minerval_du_mois(){
		$date = date("Y-m-01");
		$annee_id = Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		$mp_type_frais_id = 1;
		return MpFraisPaiement::with('mpFraisClasse.mpFrais','mpFraisClasse.msClasse')
		    ->whereHas('mpFraisClasse.msClasse',function($q)use($ecole_id){return $q->where('ecole_id',$ecole_id);})
			//->whereHas('mpFraisClasse',function($q)use($annee_id){return $q->where('ms_annee_scolaire_id',$annee_id);})
		    ->where('payer_le','>=',$date)->get()
				->filter(function($p,$k) use($mp_type_frais_id){
					// dd($p,$k);
					$ok = ($p->mpFraisClasse->mpFrais)??false;
					if($ok)
						return ($p->mpFraisClasse->mpFrais->mp_type_frais_id == $mp_type_frais_id );
					return false;
					})->sum('montant_payer');
		
	}
	
	// retrouver tous les frais non payer de priorite inferieur
	public function pas_de_frais_en_retard($id_eleve,$id_classe, $frais, $tab_frais){
		$eleve = MsEleve::find($id_eleve);
		$annee_id = Config::getIdAnnee();
		
		$frais_classe = MpFraisClasse::where('ms_annee_scolaire_id',$annee_id)->where('ms_classe_id',$id_classe)->where('mp_frais_id',$frais->id)->first();
		// dd($frais_classe,$id_classe,$frais);
		if(!$frais_classe) 
		    return '<br/>Le frais: <b>'.$frais->frais.'</b> n\'est pas encore parametré <b>dans la classe de cet élève</b>s';
		
		$user_id = \Auth::user()->id;
		if($frais_classe->sans_priorite)
		    return true;
		$inscrit_le = $eleve->inscrit_le;
		
		$suite = $inscrit_le?('and  \''.$inscrit_le.'\' < fc.date_butoire'):'';
		$req = 'SELECT mp_frais.devise,mp_frais.frais,
		((case pe.id is null when 1 then fc.montant else pe.montant_fixer end)  - ifnull(SUM(mp_frais_paiements.montant_payer),0)) peyer,
		mp_frais.priorite ,fc.date_butoire 
		FROM `mp_frais_classes` fc
		INNER JOIN mp_frais on mp_frais.id = fc.mp_frais_id 
			and (mp_frais.priorite < '.$frais->priorite.' )		
			and mp_frais.mp_type_frais_id='.$frais->mp_type_frais_id.' 
			'.($suite).' 	
			and mp_frais.id NOT IN ('.implode(',',$tab_frais).')
		LEFT JOIN mp_frais_paiement_expetionnels pe ON pe.ms_eleve_id='.$id_eleve.' and pe.mp_frais_classe_id = fc.id
		LEFT JOIN mp_frais_paiements ON mp_frais_paiements.ms_eleve_id = '.$id_eleve.' AND mp_frais_paiements.mp_frais_classe_id = fc.id
		GROUP BY mp_frais_paiements.ms_eleve_id,fc.id,fc.ms_classe_id,fc.ms_annee_scolaire_id
		,(case pe.id is null when 1 then fc.montant else pe.montant_fixer end)
		HAVING fc.ms_classe_id='.$id_classe.' and 0 <  peyer and fc.ms_annee_scolaire_id = \''.$eleve->ms_annee_scolaire_id.'\'
		ORDER BY mp_frais.priorite ASC';
		
	
		$tab = \DB::select($req);
		// dd($tab);
		/*if($user_id==32){
		     echo $req;
		    dd($user_id,$tab);
		}*/
		if(!count($tab)) return true;
		// dd( $req);
		$str = "doit d'abord payer ";
		foreach($tab as $lg){
			$str .= '  '.$lg->frais.' '. ($lg->peyer).' ';//. $lg->devise
		}
		return $str.'avant de payer <b>'.$frais->frais.'</b><br/>';
														

		/*  $ms_eleve_id = 1;
		MsClasse::with('mpFraisClasses.mpFrais.mpTypeFrais','mpFraisClasses.mpFraisPaiements')->mpFraisClasses->find(1)->filter(function($p,$k) use($frais,$ms_eleve_id){return ($p['mpFrais']['priorite'] < $frais->priorite and $p['mpFrais']['mp_type_frais_id']== $frais->mp_type_frais_id and  $p['mpFraisPaiements']['ms_eleve_id']==$ms_eleve_id );});
															
		MsClasse::with('mpFraisClasses.mpFrais.mpTypeFrais','mpFraisClasses.mpFraisPaiements')->find($id_classe)->mpFraisClasses->filter(function($p,$k) use($frais,$ms_eleve_id){return ($p['mpFrais']['priorite'] < $frais->priorite and $p['mpFrais']['mp_type_frais_id']== $frais->mp_type_frais_id and (!count($p['mpFraisPaiements']) or $p['mpFraisPaiements']['ms_eleve_id']==$ms_eleve_id) );}); 

		MsClasse::with('mpFraisClasses.mpFrais.mpTypeFrais','mpFraisClasses.mpFraisPaiements')->find($id_classe)->mpFraisClasses->filter(function($p,$k) use($frais,$ms_eleve_id){ return ($p['mpFrais']['priorite'] < $frais->priorite and $p['mpFrais']['mp_type_frais_id']== $frais->mp_type_frais_id   );});  */

		
	}
	
	// retrouver tous les frais non payer de priorite inferieur
	public function payer_les_frais_en_retard(Request $request, $mp_type_frais_id=1){
		$tab_eleve = $request->id_eleve;
		$message ="";
		foreach($tab_eleve as $id_eleve){				
			if($id_eleve=="-")continue;
				
		
			// $eleve = MsEleve::with('msInscription')->find($id_eleve);
			$eleve = MsEleve::with('mpFraisPaiementExpetionnels','msClasse','enfant','tuteur')->find($id_eleve);
			$inscrit_le = $eleve->inscrit_le;
			
			$suite = $inscrit_le?('and  \''.$inscrit_le.'\' < mp_frais_classes.date_butoire'):'';
			$req = 'SELECT mp_frais.devise,mp_frais.frais,mp_frais.id mp_frais_id,
			((case pe.id is null when 1 then mp_frais_classes.montant else pe.montant_fixer end)  - ifnull(SUM(mp_frais_paiements.montant_payer),0)) rest_a_peyer,
			mp_frais.priorite ,mp_frais_classes.date_butoire 
			FROM `mp_frais_classes` 
			INNER JOIN mp_frais on mp_frais.id = mp_frais_classes.mp_frais_id 
				and mp_frais.mp_type_frais_id='.$mp_type_frais_id.' 
				'.($suite).' 	
			LEFT JOIN mp_frais_paiement_expetionnels pe ON pe.ms_eleve_id='.$id_eleve.' and pe.mp_frais_classe_id = mp_frais_classes.id
			LEFT JOIN mp_frais_paiements ON mp_frais_paiements.ms_eleve_id = '.$id_eleve.' AND mp_frais_paiements.mp_frais_classe_id = mp_frais_classes.id
			GROUP BY mp_frais_paiements.ms_eleve_id,mp_frais_classes.id,mp_frais_classes.ms_classe_id
			,(case pe.id is null when 1 then mp_frais_classes.montant else pe.montant_fixer end)
			HAVING mp_frais_classes.ms_annee_scolaire_id=\''.$eleve->ms_annee_scolaire_id.'\' and mp_frais_classes.ms_classe_id='.$eleve->ms_classe_id.' and 0 <  rest_a_peyer
			ORDER BY mp_frais.priorite ASC ';
			// echo $req;
			// dd( $req);
		
			$tab = \DB::select($req);
			
			if(!count($tab)) return true;
			
			$montant_cdf = (double)$request->get("montant_payer_cdf_solde");
			$montant_usd = (double)$request->get("montant_payer_usd_solde");
			$send_sms = true;
			$observation="";
			$date = $request->date??date('Y-m-d');
			$return = ['result'=>[],'mp'=>[],'sms_text'=>[],'recu'=>[],'mt'=>[]];
			foreach($tab as $lg){
				$return = $this->payer($eleve,$lg->mp_frais_id,$montant_cdf, $montant_usd,[$lg->mp_frais_id],$send_sms,$return,$date,true);
				// dd($tab,$return);
				$t = count($return['mt'])-1;
				if(($return['mt'][$t]['rest'])){
					$montant_usd = ($return['mt'][$t]['montant_usd'])?($montant_usd - $return['mt'][$t]['montant_usd']  ):$montant_usd;
					$montant_cdf = ($return['mt'][$t]['montant_cdf'])?($montant_cdf - $return['mt'][$t]['montant_cdf']  ):$montant_cdf;
				}
				else break;
			}
			if(isset($return['result']) and count($return['mp'])){
				$recu = $this->create_recu($id_eleve,$date,$observation);
				foreach($return['mp'] as $p){
					if($p)$p->update(['mp_recu_id'=>$recu->id]);
				}
				$return['recu'] =  $recu->id;
				$this->id_paiements[] = $recu->id;
				$this->id_eleves[] = $id_eleve;	
			}
			if(isset($return['sms_text']) and count($return['sms_text']) and $send_sms and ($tut = $eleve->tuteur??false) and $tut->telephone ){
				$enfant = $eleve->enfant;
				$noms = "$enfant->nom $enfant->postnom $enfant->prenom";
				$classe = $eleve->msClasse->classe;
				$sms_text = "$noms de la $classe, a PAYE ".implode("; ",$return['sms_text'])." \nLA DIRECTION";
				$num = $tut->telephone;
				// $msg = $sms_text.' xxxxxxxxxxxxxxxxxxx '.$num;
				ms_sms($num,$sms_text);
			}
		}
		
		$message = count(isset($return['result'])?$return['result']:[])? implode("<hr>",$return['result']):"";
		$result = $message?"fail":"success";
		
		
		$id_paiements = $this->id_paiements;
		$id_eleves = $this->id_eleves;
		// dd(compact('result','message','id_paiements','id_eleves'));
		
        return compact('result','message','id_paiements','id_eleves');
		
	}
	
	// retrouver tous les frais non payer de priorite inferieur
	public function arrierer_paiement($enfant_id,$eleve_id){
		$id_annee = Config::getIdAnnee();
		$req = "SELECT d.non_obligatoire,d.nepasvoir_litige ,d.id eleve_id,frais,ifnull(pe.montant_fixer,montant) sur, 
		( ifnull(pe.montant_fixer,montant) - sum(ifnull(montant_payer,0))) reste, 
		enfant_id,d.mp_frais_classe_id,taux, d.id eleve_id,type_frais,priorite,
		d.ms_annee_scolaire_id, a.annee
		FROM `vp_frasis_classe_paiement`d 
		INNER JOIN bulletin_ms_annee_scolaires a on a.id = d.ms_annee_scolaire_id
		LEFT join mp_frais_paiement_expetionnels pe on pe.ms_eleve_id = d.id and d.mp_frais_classe_id=pe.mp_frais_classe_id
		where enfant_id='$enfant_id' and d.ms_annee_scolaire_id <> '$id_annee'
		and d.date_butoire > d.inscrit_le  and d.nepasvoir_litige=0
		group by d.id,d.mp_frais_classe_id 
		HAVING (reste<>0  or reste is null)".($eleve_id?" and d.id <> '$eleve_id'":"")." 
		order by d.non_obligatoire ,priorite ";
		$tab = \DB::select($req);
		//echo $req;
		if(!count($tab)) return false;
		return $tab;
		
	}
		
	// retrouver tous les frais non payer de priorite inferieur
	public function importer_lacolombe_paiement_auto(){
		$id_annee = Config::getIdAnnee();
		$user_id = \Auth::user()->id;
		$req = "SELECT * FROM `paiement`WHERE Annee_scol='20232024' ;";
		$tab = \DB::select($req);
		foreach($tab as $p){
		    $req="SELECT el.id,el.ms_classe_id FROM `enfants` e inner join bulletin_ms_eleves el on el.enfant_id=e.id WHERE matricule = '$p->Eleve';";
		    $eleve = \DB::select($req);
		    $eleve_id = $eleve[0]->id;
		    $ms_classe_id = $eleve[0]->ms_classe_id;
		    $req="SELECT sum(Montant_percu)Montant_percu,group_concat(distinct observ) observ, group_concat(distinct Frais) observation FROM `detail_paiement` WHERE Numrecu = '$p->Numrecu' and Monnaie='USD';";
		    $dpt = \DB::select($req)[0];
	        $mnt_dispo = $dpt->Montant_percu;
	        $obser = "$p->percepteur $dpt->observation";
	        if(!$mnt_dispo)continue;
		    //var_dump($req);
		    
		    $req = "SELECT fc.compte compte_id ,fc.id,fc.montant_usd,fc.taux,sum(ifnull(fp.montant_payer_usd,0)) montant_payer_usd ,f.frais,(fc.montant_usd-sum(ifnull(fp.montant_payer_usd,0)))reste
                FROM `mp_frais_classes` fc 
                left join mp_frais_paiements fp on fc.id = fp.mp_frais_classe_id and fp.ms_eleve_id='$eleve_id'
                left join mp_frais f on f.id = fc.mp_frais_id
                where ms_classe_id=$ms_classe_id and ms_annee_scolaire_id=3 
                group by fc.id 
                HAVING sum(ifnull(fp.montant_payer_usd,0))<fc.montant_usd
                order by f.mp_type_frais_id, f.priorite;";
		    $dettes = \DB::select($req);
		    foreach($dettes as $dt){
		        $reste = $dt->reste;
		        if(!$reste)continue;
	            if($mnt_dispo<$reste){
	                $reste-=$mnt_dispo;
	                $mnt_pcdf = $mnt_dispo*$dt->taux;
	                $mnt_p=$mnt_dispo;
	                $mnt_dispo=0;
	            }
	            else {
	                $mnt_pcdf = $reste*$dt->taux;
	                $mnt_p=$reste;
	                $mnt_dispo-=$reste;
	            }
                //$req = "INSERT INTO `mp_frais_paiements`(`ms_eleve_id`, `mp_frais_classe_id`, `montant_payer`, `montant_payer_usd`, `compte_id`, `payer_le`, `user_id`, `created_at`, `updated_at`) 
                //VALUES ($eleve_id,$dt->id,$mnt_pcdf,$mnt_p,$dt->compte_id,'$p->Date_paie',$user_id,now(),now());";
                \DB::table('mp_frais_paiements')->insert(['ms_eleve_id'=>$eleve_id ,'mp_frais_classe_id'=>$dt->id ,'montant_payer'=>$mnt_pcdf ,
                'montant_payer_usd'=>$mnt_p ,'montant_payer_cdf'=>0 ,'compte_id'=>$dt->compte_id ,'payer_le'=>$p->Date_paie ,'user_id'=>$user_id
                ,'created_at'=>$p->Date_paie ,'updated_at'=>$p->Date_paie]);
                $pId = \DB::getPdo()->lastInsertId();
	            
		        // création du recu
		        if(($pId)){
		            $r = \DB::table('mp_recus')->where('num_recu', $p->Numrecu)->first();
    		        if(!$r){
        		        \DB::table('mp_recus')->insert(['ms_eleve_id'=>$eleve_id ,'ms_annee_scolaire_id'=>3,
                        'Observation'=>"$obser" ,'num_recu'=>$p->Numrecu ,'date_recu'=>$p->Date_paie ,'user_id'=>$user_id
                        ,'created_at'=>$p->Date_paie ,'updated_at'=>$p->Date_paie]);
        		        $recu_Id = \DB::getPdo()->lastInsertId();
    		        }
    		        else $recu_Id = $r->id;
    		        // $req="UPDATE mp_frais_paiements set mp_recu_id=$recu_Id where id =$pId )";
    		        \DB::table('mp_frais_paiements')->where('id',$pId)->update(['mp_recu_id'=>$recu_Id]);
		        }
		        if($mnt_dispo==0)break;
		    }
		}
		dd("chado c'est bon");
		
	}
	
	private $id_paiements = [];
	private $id_eleves = [];
	public function payer($eleve,$id_frais,$montant_cdf, $montant_usd,$tab_frais, $send_sms,$return,$date,$solder_paiement=false){
		$msg = "";
		$id_eleve = $eleve->id;
		$frais = MpFrais::with('mpTypeFrais' )->find($id_frais);
		$enfant = $eleve->enfant;
		$noms = "$enfant->nom $enfant->postnom $enfant->prenom";
		$classe = $eleve->msClasse->classe;
		$id_classe = $eleve->msClasse->id;
		$pas_de_frais_en_retard = $this->pas_de_frais_en_retard($id_eleve, $id_classe, $frais, $tab_frais);
		//dd($pas_de_frais_en_retard);
		if($pas_de_frais_en_retard !== true ){
			$msg = "<b>$noms</b> ".$pas_de_frais_en_retard;
			$return['result'][]=$msg;
			return $return;
		}
		// dd($noms,$pas_de_frais_en_retard);
		$annee_id = \App\Config::getIdAnnee();
		$frais_apayer = MpFraisClasse::
									where("ms_classe_id",$id_classe)->
									where("ms_annee_scolaire_id",$annee_id)->
									where("mp_frais_id",$frais->id)->first();
		//dd($pas_de_frais_en_retard,$frais_apayer);
		$mp=null;
		$sms_text='';
		if($frais_apayer){
			$id_frais_classe = $frais_apayer->id;
															
			$result = MpFraisPaiement::groupBy('ms_eleve_id','mp_frais_classe_id')
										->selectRaw('sum(montant_payer) as sum, group_concat(payer_le) date_paye')
										->where('mp_frais_classe_id',$id_frais_classe)
										->where('ms_eleve_id',$eleve->id)
										->get();
			$total_payer = count($result)?$result[0]->sum:0;
			$date_p = count($result)?$result[0]->date_paye:0;
			
			if(($frais_ex = $eleve->mpFraisPaiementExpetionnels->where('mp_frais_classe_id',$id_frais_classe)->first()))
				$montant_du_frais = (double)$frais_ex->montant_fixer;
			else $montant_du_frais = (double)$frais_apayer->montant;
			
			if($total_payer > $montant_du_frais){
				$msg = "$noms a déjà payé plus que prevu : $frais->frais ($total_payer/$montant_du_frais) le $date_p";
			}
			else if($total_payer == $montant_du_frais){
				$msg = "$noms a déjà tout payé : $frais->frais ($total_payer/$montant_du_frais) le $date_p";
			}
			else{
				
				$user_id = \Auth::user()->id;
				$compte = $this->trouver_classe_comptable($id_frais_classe, $date ); //


				$monnaie = $frais_apayer->montant_usd?'usd':'cdf';
				$taux = $frais_apayer->taux;
				$montants = $this->calculer_montant($montant_cdf,$montant_usd,$montant_du_frais ,$total_payer,$monnaie,$taux);
				// if($user_id==14) dd($montants);
				$result = $this->inser_paiement($id_eleve,$id_frais_classe,$montants['montant'] ,$montants['montant_cdf'],$montants['montant_usd'],$date,$compte,$user_id);
				if(is_string($result))$msg = $result ;
				else{
    				$mp = $result['mp'];
    				$sms_derrog = isset($result['derrogations'])?' MERCI D\'HONORER VOTRE DERROGATION':'';
    				$rest = $montants['rest'];
    				$return['mt'][] = $montants;
    				if($mp and !$solder_paiement){
    					if($rest)
    						$msg = "Rembourssez SVP $rest à $noms pour: $frais->frais, "
    							.($total_payer?"il a déjà payé $total_payer/$montant_du_frais":"");
    							//." Il veut payer $montant_entrer";
    					$sms_text = ($montants['montant_cdf']?"$montants[montant_cdf]".($frais->mpTypeFrais->argent?"Fc":""):"")." ".($montants['montant_usd']?(($montants['montant_cdf']?"et ":"")."$montants[montant_usd]$"):"")." : $frais->frais $sms_derrog";
    				}
				}
			}
		}
		else $msg = "$noms ne paie pas: $frais->frais";

		if($msg)$return['result'][]=$msg;
		if($mp)$return['mp'][]=$mp;
		if($sms_text)
		    $return['sms_text'][]=$sms_text;
		// dd($return);
		return $return;			
	}

    function getMontantApplicable($id_eleve, $id_frais_classe){
         $montant_total_frais = \DB::table('mp_frais_classes as fc')
            ->leftJoin('mp_frais_paiement_expetionnels as fpe', function($join) use ($id_eleve) {
                $join->on('fpe.mp_frais_classe_id', '=', 'fc.id')
                     ->where('fpe.ms_eleve_id', '=', $id_eleve);
            })
            ->where('fc.id', $id_frais_classe)
            ->select(\DB::raw('COALESCE(fpe.montant_fixer, fc.montant) as montant_applicable'))
            ->value('montant_applicable'); // <-- récupère directement la valeur

        return $montant_total_frais;
    }
        
    private function set_verrouillage($action_key,$id=0){
		if($id==0)$user_id = 0;
		else $user_id = \Auth::user()->id;
        try {
            // 1. Tentative de verrouillage 
            \DB::table('verrous_actions')->insert([
                'user_id' => $user_id,
                'action' => $action_key,
                'date_creation' => now(),
            ]);
            return true;
        } catch (PDOException $e) {
            // Si la clé existe déjà : un traitement est déjà en cours
            return false;
        }
        
    }
    private function del_verrouillage($action_key,$id=0){
		if($id==0)$user_id = 0;
		else $user_id = \Auth::user()->id;
        // 4. Libérer le verrou après réussite
        \DB::table('verrous_actions')->where('user_id', $user_id)->where('action', $action_key)->delete();
    }
	public function inser_paiement($id_eleve,$id_frais_classe,$montant,$montant_cdf,$montant_usd,$date,$compte,$user_id){
	    
		$ecole_id = Config::getEcoleId();
		
        $montant_total_frais = $this->getMontantApplicable($id_eleve, $id_frais_classe);
        
        
        // Définir l'action de verrouillage (unique par élève et période)
        $action_key = "paiement_{$id_eleve}_{$id_frais_classe}";
        $error_msg = "Paiement déjà en cours, veuillez patienter...";
        if($this->set_verrouillage($action_key)!==true)return $error_msg;
    
        try {
            // 2. Vérifier si un paiement a déjà été effectué
            // Étape 2 : total déjà payé par cet élève pour ce frais
            $montant_deja_paye = \DB::table('mp_frais_paiements')
                ->where('ms_eleve_id', $id_eleve)
                ->where('mp_frais_classe_id', $id_frais_classe)
                ->sum('montant_payer');
            
            // Étape 3 : vérifier si l’ajout dépasse
            if (($montant_deja_paye + $montant) > $montant_total_frais) {
                
                return 'Le montant payé dépasse le montant exigé pour ce frais.';
            }
        
            // 3. Enregistrer le paiement
            // dd($id_eleve,$id_frais_classe,$montant,$montant_cdf,$montant_usd,$date,$compte,$user_id);
    		$mp = MpFraisPaiement::create(['ms_eleve_id'=>$id_eleve
    				,'mp_frais_classe_id'=>$id_frais_classe
    				,'montant_payer'=>$montant
    				,'montant_payer_cdf'=>$montant_cdf
    				,'montant_payer_usd'=>$montant_usd
    				,'payer_le'=>$date
    				,'compte_id'=>$compte
    				,'user_id'=>$user_id
        			,'ecoleid'=>$ecole_id
    				,]);
    				
    				$derrogations = MsEleveDeroger::where('montant','>',0)->where('ms_eleve_id',$id_eleve)->where('mp_frais_classe_id',$id_frais_classe)->get();
    
    				foreach($derrogations as $d){
    					if($d->montant and $montant){
    						$s = $d->montant - $montant;
    						$retrait = $s>=0?$s:0;
    						$d->montant = $retrait;
    						$d->save();
    						$montant = $s<=0?$montant - $d->montant:0;
    					}
    				}
        
            // 4. Libérer le verrou après réussite
            $this->del_verrouillage($action_key);
        
    		if($derrogations and $derrogations->count())
    			return compact('mp','derrogations') ;		
    		else return compact('mp') ;
        } catch (Exception $e) {
            // En cas d'erreur : libérer le verrou et retourner une erreur
            $this->del_verrouillage($action_key);
            return "Erreur lors de l'enregistrement : " . $e->getMessage();
        }
        
		
		
	}

	public function tous_les_frais(){
		$id_annee = Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		$mpfraiss = MpFrais::with('mpFraisClasses.msClasse')
		    ->whereHas('mpFraisClasses',function($q)use($id_annee){return $q->where('ms_annee_scolaire_id',$id_annee);})
		    ->whereHas('mpFraisClasses.msClasse',function($q)use($ecole_id){return $q->where('ecole_id',$ecole_id);})
		    ->get();
		return $this->addUser($this->v_path.'les_frais' ,compact('mpfraiss') );
	}
	

	private function preparer_montant_en_usd($montant_cdf,$montant_usd,$montant_usd_en_fr ,$rest_a_payer,$taux){
		// si l'usd est > au reste_a_payer alors on paye le tout en usd et on recalcule le reste
		if($montant_usd_en_fr >= $rest_a_payer){
			$montant_usd = (int)($rest_a_payer /$taux) ; // on concertie le reste a payer en usd
			$montant_usd = $montant_usd - ($montant_usd % 5);// on garde un multiple de 5 et le reste est reconverti en cdf et rajouter au cdf
			$peu = $rest_a_payer % $taux; // ce qui ne peut etre converti en usd (on le prend en cdf)
			$montant_cdf = $peu + (($montant_usd % 5)*$taux);;
		}
		else { // sinon alors on garde ca premierement et on voit combien rajouter en cdf
			$complement = $rest_a_payer - $montant_usd_en_fr; // donc dans le reste a payer on retire les usd(cdf) et le reste est suppose etre le cdf a rajouter
			// si il y'a des cdf
			if($montant_cdf >= $complement)
				$montant_cdf = $complement;
			else $montant_cdf = $montant_cdf; // sinon on rajouter le tout
		}
		return compact('montant_cdf','montant_usd');
	}

	private function preparer_montant_en_cdf($montant_cdf_usd,$montant_cdf,$montant_usd,$montant_usd_en_fr ,$rest_a_payer,$taux){
		// si le cdf est > au reste_a_payer alors on paye le tout en cdf et on recalcule le reste
		if($montant_cdf >= $rest_a_payer){
			$montant_cdf =  $rest_a_payer ; // on paie directement
			$montant_usd = 0;
		}
		else { // sinon alors on garde ca premierement et on voit combien rajouter en usd
			$complement = $rest_a_payer - $montant_cdf; // donc dans le reste a payer on retire les cdf et le reste est suppose etre converti en usd et rajouter a la somme
			// si il y'a des cdf
			if($montant_usd_en_fr >= $complement){
				$montant_usd = (int)( $complement / $taux);
				$peu = $complement % $taux; // ce qui ne peut etre converti en usd (?????)
				if($peu>0){
					// on doit rappler la fonction en priorisant les usd
					return $this->deduire_les_montant_a_payer($montant_cdf_usd,$montant_cdf,$montant_usd,$montant_usd_en_fr ,$rest_a_payer,$taux,'usd');
				}
			}
			else $montant_usd = $montant_usd; // sinon on rajouter le tout
		}
		return compact('montant_cdf','montant_usd');
	}

	// $frais_apayer->montant_usd
	private function deduire_les_montant_a_payer($montant_cdf_usd,$montant_cdf,$montant_usd,$montant_usd_en_fr ,$rest_a_payer,$taux,$monnaie='usd'){
		// si on doit payer en usd
		if($monnaie=='usd'){
			$r = $this->preparer_montant_en_usd($montant_cdf,$montant_usd,$montant_usd_en_fr ,$rest_a_payer,$taux);
		}
		// et si on doit payer en cdf
		else $r = $this->preparer_montant_en_cdf($montant_cdf_usd,$montant_cdf,$montant_usd,$montant_usd_en_fr ,$rest_a_payer,$taux);
		$r['rest'] = $montant_cdf_usd - $rest_a_payer;
		return $r;
	}
	
	private function calculer_montant($montant_cdf,$montant_usd,$montant_du_frais ,$total_payer,$monnaie,$taux){
		$rest = 0;
		$montant_usd_en_fr = $montant_usd*$taux;
		$montant_cdf_usd = $montant_cdf + $montant_usd_en_fr;
		$rest_a_payer = $montant_du_frais - $total_payer; // 

		if($montant_cdf_usd){
			if($montant_cdf_usd > $rest_a_payer){
				$m = $this->deduire_les_montant_a_payer($montant_cdf_usd,$montant_cdf,$montant_usd,$montant_usd_en_fr ,$rest_a_payer,$taux,$monnaie);
				$montant_cdf = $m['montant_cdf'];
				$montant_usd = $m['montant_usd'];
				$rest 		 = $m['rest'];
				$montant 	 = $rest_a_payer;
				$msg="Montant trop grand ".chiffre($montant_cdf_usd)." CDF !!!";
				
			}
			else  $montant = $montant_cdf_usd;					
		}
		else {
			$montant = $rest_a_payer;
			// determiner la monnaie prise en charge
			if($monnaie == 'usd'){
				$montant_usd = (int)($montant / $taux);
				$montant_usd = $montant_usd - ($montant_usd % 5);
				$montant_cdf = $montant - ($montant_usd * $taux) + (($montant_usd % 5)*$taux);
			}						
			else $montant_cdf = $montant ;
		}
		
		return compact('montant_cdf','montant_usd','montant','rest');
	}
	
	public function creer_frais(Request $request){
		$annee_id = Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		//->whereHas('msPromotion',function($q)use($annee_id){return $q->where('ms_annee_scolaire_id',$annee_id);})
		$msClasses = MsClasse::with('msPromotion')->where('ecole_id',$ecole_id)->get();
		$tabFrais = [];
		$mpfraisinclunoms = MpFraisIncluNom::where('ecole_id',$ecole_id)->get();
		
		if($request->ids){
		    $tab = explode(",",$request->ids);
		    $datas = [];
		    if($request->date_but)$datas["date_butoire"]=$request->date_but;
		    if($request->fixer_compte)$datas["compte"]=$request->fixer_compte;
		    if($request->taux){
		        $datas["taux"]=$request->taux;
		    }
		    if($request->sans_priorite!=''){
		        $datas["sans_priorite"]=$request->sans_priorite=='oui'?1:null;
		    }
		    if(count($datas)==0){
		        flash("Erruer Le formulaire est vide!!!");
		    }
		    else {
		        // on adapte les paiement des élèves qui sont déjà en ordre avant changement de taux de sorte qu'ils restent toujour en ordre même après changement de taux
		        if($request->taux and  $request->update_paiement_excep){
    		        $req = "SELECT p.ms_eleve_id,p.mp_frais_classe_id, sum(p.montant_payer) mt,ifnull(pe.montant_fixer,fc.montant)prix
    		        FROM `mp_frais_classes` fc inner join mp_frais_paiements p on fc.id=p.mp_frais_classe_id
    		        Left Join mp_frais_paiement_expetionnels pe on (pe.ms_eleve_id=p.ms_eleve_id and pe.mp_frais_classe_id=p.mp_frais_classe_id)
    		        where fc.id 
    		        in ($request->ids) group by p.ms_eleve_id having sum(p.montant_payer) = prix; ";
    		        $eleves_en_ordre = \DB::select($req); 
    		        
    		        $user_id  = \Auth::user()->id;
    		        foreach($eleves_en_ordre as $el){
    		            $d = MpFraisPaiementExpetionnel::firstOrCreate(['ms_eleve_id' => $elid,'mp_frais_classe_id' => $fid,'montant_fixer' => $mnt,'raison' => 'ELEVE DEJA EN ORDRE AVANT LE CHANGEMENT TAUX'
        		        ,'user_id' => $user_id,'created_at' => date('Y-m-d H:i:s'),'updated_at' => date('Y-m-d H:i:s')]);
    		        }
    		        
    		    }
    		    $r = \DB::table("mp_frais_classes")->whereIn('id',$tab)->update($datas);
    		    if($request->fixer_compte){
    		        if($request->uniquement_sur_les_frais);
    		        else \DB::table("mp_frais_paiements")->whereIn('mp_frais_classe_id',$tab)->update(['compte_id'=>$request->fixer_compte]);
    		    }
    		        
    		    flash("$r Enregistrements modifiés avec succès");
		    }
    		return redirect()->back();
		} 
		// dd($request);
		// si on souhaite voir la page pour creer un nouveau frais
		if(!$request->has('frais')){
			$mpfrais = new MpFrais;
			$mpTypeFraiss = MpTypeFrais::all();
			$comptes =  Compte::where('ecole_id',$ecole_id)->get();
			$mpfraisclasses = MpFraisClasse::with('lecompte','msClasse.msPromotion','mpFrais')
			->whereHas('msClasse',function($q)use($ecole_id){return $q->where('ecole_id',$ecole_id);})
			->where('ms_annee_scolaire_id',$annee_id)->get();
			
			$mpfraisinclus = MpFraisInclu::with('mpFraisIncluNom','mpFraisClasse.msClasse')
			->whereHas('mpFraisClasse',function($q)use($annee_id){return $q->where('ms_annee_scolaire_id',$annee_id);})
			->whereHas('mpFraisClasse.msClasse',function($q)use($ecole_id){return $q->where('ecole_id',$ecole_id);})
			->whereHas('mpFraisIncluNom',function($q)use($ecole_id){return $q->where('ecole_id',$ecole_id);})
			->get();
			// dd($mpfraisclasses);
			$mpfraisclasse = new MpFraisClasse;
			$mpFraiss = MpFrais::all();
			return  $this->addUser($this->v_path.'creer',compact('mpfraisinclus','mpfraisinclunoms','comptes','mpfrais','mpTypeFraiss','mpfraisclasses','mpFraiss','msClasses','mpfraisclasse'));
		}
		
		
		
		if(!$request->all_classes)
			$tab_classes_id = $request->ms_classe_id;// si on veut passer par des classe specifiques		 	
		else $tab_classes_id = $msClasses->map(function ($item, $key) { return $item->id; })->toArray();
		
        if($request->nouveau_inclu!='frais-inclu'){
    		// soummission du formulaire,  cas d'un nouveau frais
    		if($request->nouveau=='nouveau'){
    			$datas = [
    				'frais'=>$request->frais,
    					'default_montant'=>$request->default_montant,
    					'mp_type_frais_id'=>$request->mp_type_frais_id,
    					'devise'=>$request->devise,
    					'priorite'=>$request->priorite,
    					'mc_mois_id'=>1,
    					'date_debut_paiement'=>$request->date_debut_paiement, // pour savoir si le paiement est fait a l'avance(dans la comptabilite)
    					'date_fin_paiement'=>$request->date_fin_paiement, // pour savoir si le paiement est fait a en retard (dans la comptabilite)
    					// 'date_butoire'=>$request->date_butoire, // pour faire certaines chose telle que rappeler les paiement aux parents
    				];
    			$rules = [
    			'frais'=>'required',
    				'default_montant'=>'',
    				'mp_type_frais_id'=>'required',
    				'devise'=>'',
    				'priorite'=>'',
    				'mc_mois_id'=>'',
    				'date_debut_paiement'=>'',
    				'date_fin_paiement'=>'',
    				//'date_butoire'=>'',
    			];
    			\Validator::make($datas,$rules)->validate();
    			$frais = MpFrais::create($datas);
    			$tabFrais[] = $frais->id;
    		}
    		else $tabFrais = $request->mp_frais_id;
    		
    		// ===========================================
    		
    		// si on souhaite uniquement modifier les comptes de la comptabilite des frais
    		if($request->update_compte and $request->compte){
    			$req = "update mp_frais_classes set compte=".$request->compte." where ms_classe_id in (".implode(",",$tab_classes_id).") and  mp_frais_id in (".implode(",",$tabFrais).") ";
    			\DB::select($req);
    		}
    		else{
    			foreach($tab_classes_id as $classe_id){
    				foreach($tabFrais as $id_frais){					
    					$datas = [
    						'montant_cdf'=>$request->montant_cdf,
    						'montant_usd'=>$request->montant_usd,
    						'montant'=>$request->montant_usd?$request->montant_usd*$request->taux:$request->montant_cdf,
    						'taux'=>$request->taux,
    						'date_butoire'=>$request->date_butoire,
    						'ms_annee_scolaire_id'=>$annee_id,
    						'ecoleid'=>$ecole_id,
    					];
    					if($request->compte)
    						$datas['compte']=$request->compte;
    					
    					$fc = MpFraisClasse::firstOrCreate(['ms_annee_scolaire_id'=>$annee_id,'mp_frais_id'=>$id_frais,'ms_classe_id'=>$classe_id],$datas);
    					if(!$fc->waRecentlyCreated)
    						$fc->update($datas);
    				}
    			}
    		}
		}
		else {
		    $tabFrais = $request->mp_frais_id;
		    if(!$request->mp_frais_inclu_nom_id){
		        $intitule_frais = $request->frais_incul;
		        $fc_nom = MpFraisIncluNom::firstOrCreate(['intitule_frais'=>$intitule_frais,'ecole_id'=>$ecole_id],[]);
				$mp_frais_inclu_nom_id =  $fc_nom->id;
		    }
		    else $mp_frais_inclu_nom_id =  $request->mp_frais_inclu_nom_id;
		    // dd($tab_classes_id,$mp_frais_inclu_nom_id);
			foreach($tab_classes_id as $classe_id){
				foreach($tabFrais as $id_frais){					
					$fc = MpFraisClasse::where(['ms_annee_scolaire_id'=>$annee_id,'mp_frais_id'=>$id_frais,'ms_classe_id'=>$classe_id])->first();
					$datas = [
						'montant_cdf'=>$request->montant_cdf,
						'montant_usd'=>$request->montant_usd,
						'montant'=>$request->montant_usd?$request->montant_usd*$request->taux:$request->montant_cdf,
						'taux'=>$request->taux,
						'mont_necessaire'=>$request->mont_necessaire
					];
					if($fc){
    					$fcI = MpFraisInclu::firstOrCreate(['mp_frais_classe_id'=>$fc->id,'mp_frais_inclu_nom_id'=>$mp_frais_inclu_nom_id],$datas);
    					if(!$fcI->waRecentlyCreated)
    						$fcI->update($datas);
					}
				}
			}
		}
		flash("Enregistrement effecté avec succès");
		return redirect()->back();
	}
	// =========================================================================
	
	public function inscrire(Request $request){
		if ($request->isMethod('get')) {
			$msPromotions = MsPromotion::all();
			return $this->addUser($this->v_path.'inscription', compact('sysUserRole','msPromotions'));
		}
	}
				
	public function eleves_inscrits(){
		$msinscriptions = MsInscription::all();
		return $this->addUser($this->v_path.'eleves_inscrits', compact('msinscriptions') );
	}
	
	public function lister_promotions(){
		$mspromotions = MsPromotion::all();
		return $this->addUser($this->v_path.'classer_eleves', compact('mspromotions') );
	}
	
	public function classer_eleves_promotion(MsPromotion  $promotion){
		$promotion = MsPromotion::with('msClasses','msInscriptions.enfant','msInscriptions.msEleves')->find($promotion->id);
		$classes = $promotion->msClasses ; // toutes les classes de la promotion
		$inscriptions = $promotion->msInscriptions;// toutes les inscriptions faites dans la promotion
		
		if(!$classes or !count($classes)){
			my_flash("Commencer par creer des classes dans la promotion SVP!","error");
			return redirect()->back();
		}
		
		// grouper les eleves par sexe
		$fille_garcon_insc = $inscriptions->groupBy(function ($insc, $key) {
			return $insc->enfant->genre;
		});

		// parcourir tous les genres et les repartir dans les differentes classes
		foreach($fille_garcon_insc as $les_inscrits)
			$this->classement_effectif($classes, $les_inscrits);
		
		return redirect()->route('payment.promotion.eleves', ['promotion'=>$promotion->id] );
	}
	
	private function classement_effectif($classes, $inscriptions){
		$i = 0;
		$inscriptions = $inscriptions->sortByDesc('test_pourcentage');
		// dd($inscriptions);
		$tot_insc = count($inscriptions);
		$all_eleves_classer = false; // tous les eleves ont ete classees
		
		while(!$all_eleves_classer and count($classes)){
			foreach($classes as $classe){
				if( $i >= $tot_insc ){// indice de l'inscription a classer
					$all_eleves_classer = true;
					break;
				}
				$insc = $inscriptions[$i++];// on passe d'une inscription a une autre
				
				//dd($insc->msEleves ?1:2);
				if($insc->msEleves and count($insc->msEleves)){ // si il existe une classification de l'inscription alors on saute
					continue;
				}
				
				MsEleve::create([
					'enfant_id'=>$insc->enfant->id
					,'ms_classe_id'=>$classe->id
					,'inscrit_le'=>$insc->inscrit_le
					,'img'=>'-'
					,'ms_inscription_id'=>$insc->id
				]);
				$insc->classer = true;
				$insc->save();
			}
		}
	}

	public function eleves_in_promotion(MsPromotion  $promotion){
		
		$msclasses = $promotion->msClasses;
		return $this->addUser($this->v_path.'eleves', compact('promotion','msclasses') );
	}
	
	// ===========================================================================
	// RAPPORTS			
	public function rapport_periodique(Request $request) {
		$mpfraispaiements = [];
		$total_payer = 0;
		$devise = "Fc";
		$usd_cdf = '';
		
		
		$annee_id = Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		
		if($request->has('date_debut')){
			$d1 = explode("/",$request->date_debut);
			$d2 = explode("/",$request->date_fin);
			$usd_cdf = $request->usd_cdf;
			$date1 = $d1[2].'-'.$d1[1].'-'.$d1[0];
			$date2 = $d2[2].'-'.$d2[1].'-'.$d2[0];
			$mpfraispaiements = MpFraisPaiement::with(
														'msEleve.enfant',
														'msEleve.msClasse.msPromotion.section',
														'mpFraisClasse.msClasse','mpFraisClasse.mpFrais.mpTypeFrais')
													->where("payer_le" ,'>=',$date1 )
													->where("payer_le" ,'<=',$date2 )
		    ->whereHas('mpFraisClasse.msClasse',function($q)use($ecole_id){return $q->where('ecole_id',$ecole_id);})
			->whereHas('mpFraisClasse',function($q)use($annee_id){return $q->where('ms_annee_scolaire_id',$annee_id);})
		    ->get();
			
			$total_payer = MpFraisPaiement::with('mpFraisClasse.msClasse','mpFraisClasse.mpFrais.mpTypeFrais')//groupBy('ms_eleve_id','mp_frais_classe_id')
		    ->whereHas('mpFraisClasse.msClasse',function($q)use($ecole_id){return $q->where('ecole_id',$ecole_id);})
			->whereHas('mpFraisClasse',function($q)use($annee_id){return $q->where('ms_annee_scolaire_id',$annee_id);})
															// ->selectRaw('sum(montant_payer) as sum')
															->where("payer_le" ,'>=',$date1 )
															->where("payer_le" ,'<=',$date2 )
															->get()
															->sum(function($it){
																if($it->mpFraisClasse->mpFrais->mpTypeFrais->argent)
																	return $it->montant_payer;
																return 0;
															} )//"mpFraisClasse_mpFrais_mpTypeFrais_argent" ,true 
															;				
		
		}
		return $this->addUser($this->v_path.'rapport', compact('mpfraispaiements','total_payer','devise','usd_cdf') );
		
	}

	public function rapport_tableau_bord() {
		$id_annee = Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		$tous_les_frais = collect([]);
		
	    
			    /*
	    $mpFraiss = MpFrais::with('mpFraisClasses.msClasse','mpTypeFrais')
			->whereHas('mpFraisClasses',function($q)use($id_annee,$ecole_id){ 
			    return 
			    $q->whereHas('msClasse',function($q)use($ecole_id){
			        return $q->where('ecole_id',$ecole_id); 
			    })
    			->where('ms_annee_scolaire_id',$id_annee); }
    		)->get();
    		*/
    	$mpFraiss = MpFrais::with('mpTypeFrais')->get();
    	
    	$liste_frais = [];
    	foreach($mpFraiss as $f){
    	    $req = "select * from mp_frais_classes fcl 
    	    inner join bulletin_ms_classes partition (p$ecole_id) cl on cl.id=fcl.ms_classe_id
    	    where mp_frais_id=$f->id and fcl.ms_annee_scolaire_id=$id_annee ";
    	    $existe =  \DB::select($req);
    	    if($existe)$liste_frais[] = $f;
    	}
	    // dd($mpFraiss,$liste_frais);
	    
	    $tous_les_frais = [];
		foreach($liste_frais as $f){
			$req = "select 
			sum(montant) m_usd_cdf, 
			sum(montant_cdf)m_cdf, 
			sum(montant_usd) m_usd, 
			sum(montant_payer_usd) usd, 
			sum(montant_payer_cdf) cdf, 
			sum(montant_payer) usd_cdf,
			mp_frais_id
			
			from bulletin_ms_eleves partition (p$ecole_id) e 
			inner join bulletin_ms_classes partition (p$ecole_id) cl on cl.id = e.ms_classe_id and cl.ecole_id = '$ecole_id' and e.ms_annee_scolaire_id=$id_annee
			inner join mp_frais_classes partition (p$ecole_id) fcl on e.ms_classe_id = fcl.ms_classe_id and fcl.ms_annee_scolaire_id=$id_annee
			left join mp_frais_paiements partition (p$ecole_id) p on fcl.id = p.mp_frais_classe_id and e.id = p.ms_eleve_id
			
			where e.ms_annee_scolaire_id=$id_annee and  fcl.mp_frais_id = $f->id
			";
			$tous_les_frais["_$f->id"] =  \DB::select($req)[0];
			
		}
		
		$mpFraiss = collect($liste_frais);
		//dd($tous_les_frais,$mpFraiss);
		return $this->addUser($this->v_path.'rapport_general', compact('tous_les_frais','mpFraiss') );
	}
	// affiche les paiement sur les mois
	public function rapport_mensuel(Request $request) {
		
		$id_annee = Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		$mp_type_frais_id = $request->mp_type_frais_id;
		$mpTypeFrais = '';
		if($mp_type_frais_id){
			$tab = MpFraisPaiement::with('mpFraisClasse.mpFrais','mpFraisClasse.msClasse')
			->whereHas('mpFraisClasse.msClasse',function($q)use($ecole_id){return $q->where('ecole_id',$ecole_id);})
			->whereHas('mpFraisClasse',function($q)use($id_annee){return $q->where('ms_annee_scolaire_id',$id_annee);})
			->selectRaw('id,ms_eleve_id,mp_frais_classe_id,montant_payer,payer_le,MONTH(payer_le) as mois')
			->get()
			->filter(function($p,$k) use($mp_type_frais_id){
				// dd($p,$k);
				$ok = ($p->mpFraisClasse->mpFrais)??false;
				if($ok)
					return ($p->mpFraisClasse->mpFrais->mp_type_frais_id == $mp_type_frais_id );
				return false;
				})
			->groupBy('mois');
			$mpTypeFrais = MpTypeFrais::find($mp_type_frais_id);
		}
			
		else $tab = [];
		$mpTypeFraiss = MpTypeFrais::all();
		return $this->addUser($this->v_path.'rapport_mensuel', compact('tab','mpTypeFrais','mpTypeFraiss') );
	}
	
	// affiche les effectifs des eleves inscrits, abandon, et inscrits en retard par rapport a la date butoire du frais
	public function billan_du_frais(Request $request) {
		
		
		$id_annee = Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		
		$action_key = "affichage-billan-frais";
        $error_msg = "Requete indisponible, reprendre dans 60 sec ...";
        if($this->set_verrouillage($action_key)!==true) return $error_msg;
    
		// if($ecole_id!=17)return "CETTE DEMANDE A BESOIN D'ETRE OPTIMISEE POUR AFIN DE BIEN REPONDRE A VOTRE ATTENDE. MERCI DE CONTACTER <b>Mr CHADRAC</b>";
		
		$mp_frais_id = $request->frais;
		$tab = $date_butoire = $frais = false;
		$mpFraiss = MpFrais::with([
    			'mpFraisClasses' => function($query) use($id_annee) {
    			  $query->where('ms_annee_scolaire_id', $id_annee);
    			},
    			'mpFraisClasses.msClasse'
    		])
		    ->whereHas('mpFraisClasses',function($q)use($id_annee){return $q->where('ms_annee_scolaire_id',$id_annee);})
		    ->whereHas('mpFraisClasses.msClasse',function($q)use($ecole_id){return $q->where('ecole_id',$ecole_id);})
		    ->get();
		if($mp_frais_id){
			$frais = MpFrais::find($mp_frais_id);
			// $date_butoire = $frais->date_butoire??$frais->date_fin_paiement??date('Y-m-19');
			$FROM = "SELECT sum(`montant_payer`) smp, sum(`montant_payer_usd`) smpu, sum(`montant_payer_cdf`) smpf ,
				EL.id,inscrit_le,etat,EL.ms_classe_id,
				`montant`, `montant_usd`, `montant_cdf`, `taux`, FCL.date_butoire
				FROM `bulletin_ms_eleves`  partition (p$ecole_id)  EL 
				INNER JOIN mp_frais_classes partition (p$ecole_id) FCL ON FCL.ms_classe_id = EL.ms_classe_id AND FCL.mp_frais_id = $mp_frais_id
				and EL.ecole_id='$ecole_id' and FCL.ms_annee_scolaire_id='$id_annee' and EL.ms_annee_scolaire_id='$id_annee' 
				LEFT JOIN `mp_frais_paiements` partition (p$ecole_id) P ON EL.id = P.ms_eleve_id AND P.mp_frais_classe_id = FCL.id
				GROUP BY EL.id";
				
			$req = "SELECT count(*) effectif, sum(case (etat='' or etat is null or etat = 'Actif') when 1 then 0 else 1 end )abandon,
			sum(case inscrit_le < date_butoire when 1 then 0 else 1 end )insc_retard,
			sum(`smp`) smp, sum(`smpu`) smpu, sum(`smpf`) smpf,
			`montant`, `montant_usd`, `montant_cdf`, `taux`, classe,P.section_id,P.niveau,CL.id
			FROM(
				$FROM
			) AS ELEVE
			INNER JOIN bulletin_ms_classes  partition (p$ecole_id)  CL ON CL.id = ELEVE.ms_classe_id
			INNER JOIN bulletin_ms_promotions P ON P.id = CL.ms_promotion_id
			GROUP BY CL.id
			ORDER BY P.section_id,P.niveau,classe";
			$tab = \DB::select($req);

			$req = "SELECT count(*) effectif,
			sum(case (etat='' or etat is null or etat = 'Actif') when 1 then 0 else 1 end )abandon,
			sum(case inscrit_le < date_butoire when 1 then 0 else 1 end )insc_retard,
			
			sum(case (smp=montant) when 1 then 1 else 0 end)eff_pay_total,
			sum(case (smp<montant and smp>=(montant/2)) when 1 then 1 else 0 end)eff_pay_moitie,
			sum(case (smp>0 and smp<(montant/2)) when 1 then 1 else 0 end)eff_pay_inf_moitie,
			sum(case (smp=0 or smp is null ) when 1 then 1 else 0 end)eff_pay_0,

			sum(case (smp=montant) when 1 then smp else 0 end)smp_pay_total,
			sum(case (smp<montant and smp>=(montant/2)) when 1 then smp else 0 end)smp_pay_moitie,
			sum(case (smp>0 and smp<(montant/2)) when 1 then smp else 0 end)smp_pay_inf_moitie,
			`taux`
			FROM(
				$FROM
			) AS ELEVE";
			
			$tabStat = \DB::select($req);
			if(count($tabStat))
				$tabStat = $tabStat[0];
			//dd($tabStat);
		}
		
        $this->del_verrouillage($action_key);
    
		$date_butoire = "0000-00-00";
		$datas = compact('tab','date_butoire','frais','mpFraiss');
		if(isset($tabStat))
			$datas['tabStat'] = $tabStat;
		
		return $this->addUser($this->v_path.'billant_frais', $datas );
		//return $this->addUser($this->v_path.'billant_frais', compact('tab','date_butoire','frais','mpFraiss','tabStat') );
	}
	
	// affiche les effectifs des eleves inscrits, abandon, et inscrits en retard par rapport a la date butoire du frais
	public function rapport_des_entree_classe(Request $request) {		
		$tab = $selected_frais = $tab_tot = $tab_entree_mensuelle =[];
		$mp_frais_id='0';
		$id_annee = Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		$mpFraiss = MpFrais::with('mpFraisClasses.msClasse')
		    ->whereHas('mpFraisClasses',function($q)use($id_annee){return $q->where('ms_annee_scolaire_id',$id_annee);})
		    ->whereHas('mpFraisClasses.msClasse',function($q)use($ecole_id){return $q->where('ecole_id',$ecole_id);})
		    ->get();
		$ids = $request->mp_frais_id;
		$monnaie = $request->monnaie??'usd';
		if($ids){
			$mp_frais_id = $ids = implode(',',$ids);
			$req_entree_mensuelle = "SELECT `frais`, `usd`, `cdf`, `mois`, `annee`,concat(annee,mois)as ann_mois FROM `vp_frais_entrees_mensuelles` WHERE `ecole_id`='$ecole_id' and `ms_annee_scolaire_id`='$id_annee' and `mp_frais_id` in ($ids) ";
			$tab_entree_mensuelle = \DB::select($req_entree_mensuelle );
			if(count($tab_entree_mensuelle))
			    $tab_entree_mensuelle = collect($tab_entree_mensuelle)->groupBy('ann_mois');
			
			$selected_frais = \DB::select("select * from mp_frais where id in ($ids) order by mp_type_frais_id ,priorite ");
			$req = "SELECT * FROM vp_entree_classe_ok v 
			where ecole_id='$ecole_id' and ms_annee_scolaire_id='$id_annee' and v.mp_frais_id in ($ids)
			order by v.groupe_classe,v.classe, priorite, v.mp_frais_id
			";
			$tab = \DB::select($req);
		}
		return $this->addUser($this->v_path.'rapport_des_entree_classes', compact('tab_entree_mensuelle','tab_tot','mp_frais_id','monnaie','tab','mpFraiss','selected_frais') );
		//return $this->addUser($this->v_path.'billant_frais', compact('tab','date_butoire','frais','mpFraiss','tabStat') );
	}
	public function rapport_des_entree_chart (Request $request){
		$labels_x = $request->labels_x ;
		$datas = substr($request->datas,0,strlen($request->datas)-1) ;
		$datas_chart = explode(';',$datas);
		foreach($datas_chart as $i=>$e)
		$datas_chart[$i] = substr($e,0,strlen($e)-1) ;
		$labels = substr($request->labels,0,strlen($request->labels)-1) ;
		return $this->addUser($this->v_path.'_rapport_chart',compact('labels','labels_x','datas_chart'));
		
	}
	
	private function tab_frais_inclus($date,$date1,$ecole_id){
	    $req = "SELECT frais_id,frais,sum(montant) montant,sum(montant)/taux as montant_usd,intitule_frais from (
        SELECT f.id frais_id,f.frais,fi.montant,fin.intitule_frais,fi.taux,fp.montant_payer ,fi.mont_necessaire
        FROM `mp_frais_inclus` fi
        INNER JOIN mp_frais_inclu_noms fin on fin.id = fi.mp_frais_inclu_nom_id
        INNER JOIN mp_frais_classes fcl on fi.mp_frais_classe_id=fcl.id 
        INNER JOIN bulletin_ms_classes cl on cl.id=fcl.ms_classe_id and cl.ecole_id='$ecole_id'
        INNER JOIN mp_frais f on f.id = fcl.mp_frais_id
        inner join mp_frais_paiements fp on fp.mp_frais_classe_id=fi.mp_frais_classe_id
        WHERE fp.payer_le BETWEEN '$date' AND '$date1'
        GROUP BY fp.ms_eleve_id,fcl.mp_frais_id
        having sum(ifnull(fp.montant_payer,0))>=fi.mont_necessaire)as t;";
        return collect(\DB::select($req))->groupBy('frais');
	}
	
	public function rapport_aujourdhui(Request $request){
		// 🔹 Initialisation des variables principales
        $date          = isset($request->date) ? $request->date : date("Y-m-d");
        $date1         = isset($request->date1) ? $request->date1 : date("Y-m-d");
        $mp_frais_id   = isset($request->mp_frais_id) ? $request->mp_frais_id : 0;
        $ms_classe_id  = isset($request->ms_classe_id) ? $request->ms_classe_id : 0;
        $annee_id      = Config::getIdAnnee();
        $ecole_id      = Config::getEcoleId();
        $user          = \Auth::user();
        $user_id       = $user->id;
        
        // 🔹 Préchargement des données de base
        $msClasses = MsClasse::with('msPromotion.section')
            ->where('ecole_id', $ecole_id)
            ->get();
        
        $mpFraiss = MpFrais::with('mpFraisClasses.msClasse')
            ->whereHas('mpFraisClasses', function ($q) use ($annee_id) {
                $q->where('ms_annee_scolaire_id', $annee_id);
            })
            ->whereHas('mpFraisClasses.msClasse', function ($q) use ($ecole_id) {
                $q->where('ecole_id', $ecole_id);
            })
            ->get();
        
        $compte = isset($request->compte) && $request->compte
            ? Compte::with('categorieCompte')->find($request->compte)
            : null;
        
        $liste_users = $liste_users_annee_passees = $tab_frais_inclus = [];
        
        // 🔹 Détermination du type de filtrage de date
        if ($date == $date1) {
            $dateFilter = function ($query) use ($date) {
                return $query->where('payer_le', $date);
            };
        } else {
            $dateFilter = function ($query) use ($date, $date1) {
                return $query->whereBetween('payer_le', [$date, $date1]);
            };
        }
        
        // 🔹 Construction de la requête de base
        $baseQuery = MpFraisPaiement::with('mpRecu', 'user', 'mpFraisClasse.msClasse')
            ->whereHas('mpFraisClasse.msClasse', function ($q) use ($ecole_id) {
                $q->where('ecole_id', $ecole_id);
            });
        
        // Application du filtre de date
        $baseQuery = $dateFilter($baseQuery);
        
        // 🔹 Limiter aux paiements du caissier si nécessaire
        if (! $user->user_acces_to_zone('VOIR-TOUS-PAIEMENT')) {
            $baseQuery->where('user_id', $user_id);
        }
        
        // ===============================
        // 🔹 FILTRES OPTIONNELS SELON LES PARAMÈTRES
        // ===============================
        if ($mp_frais_id > 0) {
            $baseQuery->whereHas('mpFraisClasse', function ($q) use ($annee_id, $mp_frais_id, $ms_classe_id) {
                $q->where('ms_annee_scolaire_id', $annee_id)
                  ->where('mp_frais_id', $mp_frais_id);
                if ($ms_classe_id) {
                    $q->where('ms_classe_id', $ms_classe_id);
                }
            });
        }
        
        // ===============================
        // 🔹 ANNÉE EN COURS
        // ===============================
        $mpfraispaiements = (clone $baseQuery)
            ->whereHas('mpFraisClasse', function ($q) use ($annee_id) {
                $q->where('ms_annee_scolaire_id', $annee_id);
            })
            ->get();
        
        // 🔹 ANNÉES PASSÉES
        $mpfraispaiements_annee_passees = (clone $baseQuery)
            ->whereHas('mpFraisClasse', function ($q) use ($annee_id) {
                $q->where('ms_annee_scolaire_id', '<>', $annee_id);
            })
            ->get();
        
        // ===============================
        // 🔹 REGROUPEMENT SI PLAGE DE DATES
        // ===============================
        if ($date != $date1) {
            // Année en cours
            $liste_users = $mpfraispaiements->groupBy(function ($item) {
                return isset($item->user->name) ? $item->user->name : 'Autre';
            })->keys();
        
            $mpfraispaiements = $mpfraispaiements->groupBy('payer_le')
                ->sortKeysDesc()
                ->map(function ($items) {
                    return $items->groupBy(function ($i) {
                        return isset($i->user->name) ? $i->user->name : 'Autre';
                    });
                });
        
            // Années passées
            $liste_users_annee_passees = $mpfraispaiements_annee_passees->groupBy(function ($item) {
                return isset($item->user->name) ? $item->user->name : 'Autre';
            })->keys();
        
            $mpfraispaiements_annee_passees = $mpfraispaiements_annee_passees->groupBy('payer_le')
                ->sortKeysDesc()
                ->map(function ($items) {
                    return $items->groupBy(function ($i) {
                        return isset($i->user->name) ? $i->user->name : 'Autre'; 
                    });
                });
        }

        // ===============================
        // 🔹 AUTRES DONNÉES UTILITAIRES
        // ===============================
        $tab_frais_inclus = $this->tab_frais_inclus($date, $date1, $ecole_id);
        $comptes = Compte::with('categorieCompte')->where('ecole_id', $ecole_id)->get();

		return $this->addUser($this->v_path.'paiement_du_jour', compact('tab_frais_inclus','ms_classe_id','mp_frais_id','compte','comptes','msClasses','mpFraiss','mpfraispaiements','mpfraispaiements_annee_passees','date','date1','liste_users','liste_users_annee_passees') );
	}	
	
	public function datatable(Request $request){
	        // return [];
			$id_annee = Config::getIdAnnee();
			$ecole_id = Config::getEcoleId();
			$cles = str_replace(' ','%', trim($_GET["search"]['value']));
			$w = '';
			if($cles){
				$cles="%$cles%";
				$w = "and (t.telephone like '$cles' 
				or r.observation like '$cles' 
				or p.payer_le like '$cles' 
				or r.num_recu like '$cles' 
				or concat(ifnull(matricule,''),' ',ifnull(nom,''),' ',ifnull(postnom,''),' ',ifnull(prenom,'')) like '$cles' ) ";
			}
			else $cle=1;
			$a = " and e.ms_annee_scolaire_id=$id_annee";
		
		    $from = "from mp_frais_paiements partition (p$ecole_id) p 
			inner join mp_recus partition (p$ecole_id) r on r.id = p.mp_recu_id
			inner join bulletin_ms_eleves partition (p$ecole_id) e on e.id = p.ms_eleve_id
			inner join enfants ef on ef.id = e.enfant_id
			inner join bulletin_ms_promotions pr on pr.id=e.ms_promotion_id
			inner join bulletin_ms_classes partition (p$ecole_id) cl on cl.id = e.ms_classe_id and cl.ecole_id = '$ecole_id'
			left join tuteurs t on t.id = e.tuteur_id";
			$count = \DB::select("
			select count(*) total $from
			where 1=1 $a
			");//
			
			$where = "
			where 
			 1=1  $a
			$w
			";
			/*from mp_frais_paiements p 
			inner join mp_recus r on r.id = p.mp_recu_id
			inner join bulletin_ms_eleves e on e.id = p.ms_eleve_id
			inner join enfants ef on ef.id = e.enfant_id
			inner join bulletin_ms_promotions pr on pr.id=e.ms_promotion_id
			inner join bulletin_ms_classes cl on cl.id = e.ms_classe_id and cl.ecole_id = '$ecole_id'
			left join tuteurs t on t.id = e.tuteur_id*/
			$countV = \DB::select("
			select count(*) total $from
			$where ");
			$req = "select p.id,r.id recu_id, matricule,genre, concat(ifnull(nom,''),' ',ifnull(postnom,''),' ',ifnull(prenom,''))identite,classe
			,payer_le, montant_payer_usd, montant_payer_cdf,num_recu,r.observation, f.frais, p.mp_frais_classe_id,montant_payer,e.ms_classe_id
			$from
			inner join mp_frais_classes fcl on fcl.id = p.mp_frais_classe_id
			inner join mp_frais f on f.id = fcl.mp_frais_id
			$where 
			order by p.id desc
			limit $_GET[start],$_GET[length]";
			$data = \DB::select($req);
			$dataOk = [];
			$id=1;
			foreach($data as $e){
				$t = [];
				$t[]=$id++;
				$t[]=$e->matricule;
				$t[]=$e->identite;
				$t[]=$e->genre;
				$t[]=$e->classe;
				$t[]=$e->frais;
				$t[]=$e->montant_payer;
				$t[]=$e->montant_payer_usd;
				$t[]=$e->montant_payer_cdf;
				$t[]=$e->num_recu;
				$t[]=$e->payer_le;
				$t[]=$e->observation;
				$t[]=$e->id;
				$t[]=$e->recu_id;
				$t[]=$e->ms_classe_id;
				//$t[]=$e->mp_frais_classe_id;
				$dataOk[] = $t;
			}
			
			return array(  
                "draw"                    =>     intval($_GET["draw"]),  
                "recordsTotal"          =>      $count[0]->total,  
                "recordsFiltered"     =>     $countV[0]->total,  
                "data"                    =>     $dataOk 
           );
	}

	public function registre_de_paiement_par_classee(Request $request){
		$id = $request->id;
		$id_annee = Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		//dd($ecole_id);
		$mpfrais = MpFrais::with(['mpFraisClasses'=>function($q)use($id_annee)
		{return $q->where('ms_annee_scolaire_id',$id_annee);}])
		    //->whereHas()
		    ->whereHas('mpFraisClasses.msClasse',function($q)use($ecole_id){return $q->where('ecole_id',$ecole_id);})
		    ->get();
		$frais = false;
		if($request->frais_id)
			$frais = MpFrais::find($request->frais_id);
		$msclasses = MsClasse::with('msPromotion.section')->where('ecole_id',$ecole_id)
		->get();
		//->whereHas('msPromotion',function($q) use($id_annee){
		//	 return $q;
		//	})//sortBy(function($c){ return $c-> });
		
		if(is_array($request->id))
			$classes = MsClasse::with(['msEleves.mpFraisPaiements','msEleves.enfant','msPromotion.section'
			,'mpFraisClasses'=>function($q)use($id_annee)
		        {return $q->where('ms_annee_scolaire_id',$id_annee);},'mpFraisClasses.mpFrais'])
			->whereIn('id',$id)
			->get();
		else $classes = MsClasse::with(['msEleves.mpFraisPaiements','msEleves.enfant','msPromotion.section'
		    ,'mpFraisClasses'=>function($q)use($id_annee)
		        {return $q->where('ms_annee_scolaire_id',$id_annee);},'mpFraisClasses.mpFrais'])->find($id);
		
		// dd($classe);
		return $this->addUser($this->v_path.'registre_de_paiement_par_classe', compact('frais','mpfrais','classes','msclasses') );
	}

    public function registre_de_paiement_par_classe(Request $request){
		$id = $request->id;
		$id_annee = Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		//dd($ecole_id);
		$mpfrais = MpFrais::with('mpFraisClasses.msClasse')
		    ->whereHas('mpFraisClasses',function($q)use($id_annee){return $q->where('ms_annee_scolaire_id',$id_annee);})
		    ->whereHas('mpFraisClasses.msClasse',function($q)use($ecole_id){return $q->where('ecole_id',$ecole_id);})
		    ->get();
		$frais = false;
		if($request->frais_id)
			$frais = MpFrais::find($request->frais_id);
		$msclasses = MsClasse::with('msPromotion.section')->where('ecole_id',$ecole_id)
		->get();
		
		if(is_array($request->id))
			$classes = MsClasse::with([
                        			'msEleves' => function($query) use($id_annee) {
                        			    $query->where('ms_annee_scolaire_id', $id_annee);
                        			},
                        			'msEleves.mpFraisPaiements','msEleves.enfant',
                        			'mpFraisClasses'=>function($q)use($id_annee){
                            		    return $q->where('ms_annee_scolaire_id',$id_annee);
                            		},
                            		'mpFraisClasses.mpFrais','msPromotion.section'
                        			])
			->whereHas('msEleves',function($q) use($id_annee){
			    return $q->where('ms_annee_scolaire_id',$id_annee);
			})
			->whereIn('id',$id)
			->get();
		else $classes = MsClasse::with(['msEleves.mpFraisPaiements',
        			                'msEleves' => function($query) use($id_annee) {
                        			    $query->where('ms_annee_scolaire_id', $id_annee);
                        			},
                        			'msEleves.enfant',
                        			'mpFraisClasses'=>function($q)use($id_annee){
                            		    return $q->where('ms_annee_scolaire_id',$id_annee);
                            		},
                            		'mpFraisClasses.mpFrais','msPromotion.section'])
			//->whereHas('msEleves',function($q) use($id_annee){
			// return $q->where('ms_annee_scolaire_id',$id_annee);
			//})
			->find($id);
		
		//
		//dd($classe);
		return $this->addUser($this->v_path.'registre_de_paiement_par_classe', compact('frais','mpfrais','classes','msclasses') );
	}
	
	public function registre_de_paiement_par_classe_anterieur(Request $request){
		$id = $request->id;
		$id_annee = Config::getIdAnnee();
		if($annee_anterieur_id = $request->annee_anterieur_id)
		    $id_annee = $annee_anterieur_id; //Config::getIdAnnee();
		    
		$ecole_id = Config::getEcoleId();
		//dd($ecole_id);
		$mpfrais = MpFrais::with('mpFraisClasses.msClasse')
		    ->whereHas('mpFraisClasses',function($q)use($id_annee){return $q->where('ms_annee_scolaire_id',$id_annee);})
		    ->whereHas('mpFraisClasses.msClasse',function($q)use($ecole_id){return $q->where('ecole_id',$ecole_id);})
		    ->get();
		$frais = false;
		if($request->frais_id)
			$frais = MpFrais::find($request->frais_id);
		$msclasses = MsClasse::with('msPromotion.section')->where('ecole_id',$ecole_id)
		->get();
		
		if(is_array($request->id))
			$classes = MsClasse::with([
                        			'msEleves' => function($query) use($id_annee) {
                        			    $query->where('ms_annee_scolaire_id', $id_annee);
                        			},
                        			'msEleves.mpFraisPaiements','msEleves.enfant',
                        			'mpFraisClasses'=>function($q)use($id_annee){
                            		    return $q->where('ms_annee_scolaire_id',$id_annee);
                            		},
                            		'mpFraisClasses.mpFrais','msPromotion.section'
                        			])
			->whereHas('msEleves',function($q) use($id_annee){
			    return $q->where('ms_annee_scolaire_id',$id_annee);
			})
			->whereIn('id',$id)
			->get();
		else $classes = MsClasse::with(['msEleves.mpFraisPaiements',
        			                'msEleves' => function($query) use($id_annee) {
                        			    $query->where('ms_annee_scolaire_id', $id_annee);
                        			},
                        			'msEleves.enfant',
                        			'mpFraisClasses'=>function($q)use($id_annee){
                            		    return $q->where('ms_annee_scolaire_id',$id_annee);
                            		},
                            		'mpFraisClasses.mpFrais','msPromotion.section'])
			//->whereHas('msEleves',function($q) use($id_annee){
			// return $q->where('ms_annee_scolaire_id',$id_annee);
			//})
			->find($id);
		
		//
		//dd($classe);
		return $this->addUser($this->v_path.'registre_de_paiement_par_classe_anterieur', compact('frais','mpfrais','classes','msclasses') );
	}
		
	// ================================================
	// RECUS
	public function recu_inscription(MsEleve $eleve){
		
		return view($this->v_path.'recu_inscription', compact('eleve') );
	}
		
	public function recu_paiement($id_paiements,$tous='non'){
		if($id_paiements=="")
			return "Erreur, Aucun paiement effectué!";
		$recus = [];
		$tab_id_paiements = explode(",",$id_paiements);
		// dd($tab_id_paiements);
		foreach($tab_id_paiements as $recu_id){
		    if($tous=='oui'){
		        $recu = MpRecu::with('msEleve.msClasse.msPromotion.section')->find($recu_id);
		        $eleve = MsEleve::with(['mpFraisPaiements.mpFraisClasse.mpFrais','mpFraisPaiements' => function($query) use($recu) {
			  $query->where('payer_le','<=', $recu->date_recu);
			}])->find($recu->ms_eleve_id);
		        $paiements = $eleve->mpFraisPaiements;
		    }
		    else{
		        $recu = MpRecu::with('mpFraisPaiements.mpFraisClasse.mpFrais','msEleve.msClasse.msPromotion.section')->findOrFail($recu_id);
			    $eleve = $recu->msEleve;
			    $paiements = $recu->mpFraisPaiements;
		    }
			if(!$recu)
				return "RECU NON VALID OU INEXISTANT";
			
			$recus[] = [$eleve,$paiements];
		}
		//dd($recus);
		return view($this->v_path.'recu', compact('recus','recu','tous') );
	}
		
	
	// DOSSIER PAIEMENT ELEVE
	public  function dossier_eleve($id) {
			$msEleve = MsEleve::with('mpFraisPaiementExpetionnels','mpFraisPaiements.mpFraisClasse.mpFrais.mpTypeFrais','msClasse.msPromotion.msAnneeScolaire')->find($id);
			$arrierer = $this->arrierer_paiement($msEleve->enfant->id,$msEleve->id);
			$datas = compact('msEleve','arrierer');
			return $this->addUser($this->v_path.'dossier_eleve', $datas );
	}
	
	// ELEVES EN ORDRE OU PAS DE PAIEMENT
	
	public function eleves_en_ordre(Request $request){
		$frais = false;
		$id_annee = Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		$mpFraisPaiements = [];
		$mp_frais_id = 0;
		$ms_classe_id = 0;
		$en_ordre = 0;
		$image = $request->image;
	    $voir_en_usd = $request->en_usd; 
		if($request->mp_frais_id){
			$ms_classe_id = $request->ms_classe_id;
			$mp_frais_id = $request->mp_frais_id;
			$en_ordre = $request->en_ordre;
			$frais = MpFrais::find($request->mp_frais_id);
			
			if($en_ordre=="oui")
				$mpFraisPaiements = $this->les_paiements_dun_frais($mp_frais_id,$ms_classe_id,$voir_en_usd)
											->filter(function($p,$k){// on filtre uniquement les élève qui n'ont pas un reste à payer
												return ($p['reste'] == 0 );
											})->groupBy('classe');
			else if($en_ordre=="non"){
			    if($frais->optionnel){
			        $mpFraisPaiements = $this->les_paiements_dun_frais($mp_frais_id,$ms_classe_id,$voir_en_usd) 
											->filter(function($p,$k)use($mp_frais_id){// on filtre uniquement les élève qui ont des dettes et qui sont souscrit au frais
											    $s = \DB::select("select * from mp_frais_optionnels where ms_eleve_id=$p[eleve_id] and mp_frais_id=$mp_frais_id");//table()->
												if($s)
												    return ($p['reste'] != 0 );
												else return false; // pas concernés sur la liste des élèves en ordre ou pas
											})->groupBy('classe');
			    }
			    else 
			    $mpFraisPaiements = $this->les_paiements_dun_frais($mp_frais_id,$ms_classe_id,$voir_en_usd) 
											->filter(function($p,$k){// on filtre uniquement les élève qui n'ont pas un reste à payer
												return ($p['reste'] != 0 );
											})->groupBy('classe');
			}
			else {
			    if($frais->optionnel){
			        $mpFraisPaiements = $this->les_paiements_dun_frais($mp_frais_id,$ms_classe_id,$voir_en_usd) 
											->filter(function($p,$k)use($mp_frais_id){// on filtre uniquement les élève qui ont des dettes et qui sont souscrit au frais
											    $s = \DB::select("select * from mp_frais_optionnels where ms_eleve_id=$p[eleve_id] and mp_frais_id=$mp_frais_id");//table()->
												if($s)
												    return true;
												else return false; // pas concernés sur la liste des élèves en ordre ou pas
											})->groupBy('classe')
                                			->sortBy(function($groupe){
                                			    $c = $groupe->first();
                                			    return $c['section'].' '.$c['niveau'].' '.$c['promotion'].' '.$c['classe'];
                                			    
                                			});
			    }
			    else 
				$mpFraisPaiements = $this->les_paiements_dun_frais($mp_frais_id,$ms_classe_id,$voir_en_usd)->groupBy('classe')
                                			->sortBy(function($groupe){
                                			    $c = $groupe->first();
                                			    return $c['section'].' '.$c['niveau'].' '.$c['promotion'].' '.$c['classe'];
                                			    
                                			});
			}
		}	
		//dd($mpFraisPaiements);
		$msClasses = MsClasse::with('msPromotion.section')->where('ecole_id',$ecole_id)->get();
		$mpFraiss = MpFrais::with('mpFraisClasses.msClasse')
		    ->whereHas('mpFraisClasses',function($q)use($id_annee){return $q->where('ms_annee_scolaire_id',$id_annee);})
		    ->whereHas('mpFraisClasses.msClasse',function($q)use($ecole_id){return $q->where('ecole_id',$ecole_id);})
		    ->get(); 
		return $this->addUser($this->v_path.'eleves_en_ordre',compact('voir_en_usd','msClasses','image','mpFraiss','mpFraisPaiements','frais','en_ordre','mp_frais_id','ms_classe_id'));
	}
	
	public function paiements_exceptionnel(Request $request){
		$id_annee = Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		
        $msClasses = MsClasse::with('msPromotion.section')->where('ecole_id',$ecole_id)->get( );
		$mpFraiss = MpFrais::with('mpFraisClasses.msClasse')
		    ->whereHas('mpFraisClasses',function($q)use($id_annee){return $q->where('ms_annee_scolaire_id',$id_annee);})
		    ->whereHas('mpFraisClasses.msClasse',function($q)use($ecole_id){return $q->where('ecole_id',$ecole_id);})
		    ->get();
		$mp_frais_id= $ms_classe_id =[];
		$except = [];
		$frais_header=[];
	    if($request->mp_frais_id){
	        $frais_header = \DB::select("select * from mp_frais where id in (".implode(",",$request->mp_frais_id).") ");
            $req="SELECT el.id,matricule,e.nom,postnom,prenom,genre,cl.classe,f.frais,fc.montant,pe.montant_fixer,f.id mp_frais_id,pe.raison,pe.created_at
            ,concat(f.mp_type_frais_id,'-',f.priorite,'-',f.frais)prio
    	    FROM `bulletin_ms_eleves` PARTITION(p$ecole_id) el 
            inner join mp_frais_paiement_expetionnels pe on pe.ms_eleve_id = el.id
            inner join mp_frais_classes fc on fc.id = pe.mp_frais_classe_id
            inner join mp_frais f on f.id = fc.mp_frais_id
            inner join enfants e on e.id= el.enfant_id
            inner join bulletin_ms_classes cl on cl.id=el.ms_classe_id
            WHERE el.ms_annee_scolaire_id=$id_annee ;";// order by e.nom,postnom,prenom,genre
        
            $req .= " AND f.id IN (".implode(",",$request->mp_frais_id).") ";
            $mp_frais_id = $request->mp_frais_id;
            
            if($request->ms_classe_id and !in_array('-',$request->ms_classe_id)){
                $req .= " AND el.ms_classe_id IN (".implode(",",$request->ms_classe_id).") ";
                $ms_classe_id = $request->ms_classe_id;
            }
    		$except = collect(\DB::select($req));
            $except = $except->groupBy('classe');
    		
    		// dd($except);
        }
         
    	return $this->addUser($this->v_path.'paiement_exceptionnel',compact('msClasses','ms_classe_id','mpFraiss','except','mp_frais_id','frais_header'));
	}
	
	/* 
	public function eleves_en_ordre_oui(Request $request){
		$frais = false;
		$mpFraisPaiements = [];
		if($request->mp_frais_id){
			$frais = MpFrais::find($request->mp_frais_id);					
			$mpFraisPaiements = $this->les_paiements_dun_frais($request->mp_frais_id,$request->ms_classe_id)
															// on filtre uniquement les élève qui n'ont pas un reste à payer
															->filter(function($p,$k){
																return ($p['reste'] == 0 );
															})->groupBy('classe');
		}		
		$en_ordre = 'yes';
		$msClasses = MsClasses::with('msPromotion.section')->get();
		$mpFraiss = MpFrais::all();
		return $this->addUser($this->v_path.'eleves_non_en_ordre',compact('msClasses','mpFraiss','mpFraisPaiements','frais','en_ordre'));

	}
	
	public function eleves_en_ordre_non(Request $request){
		$frais = false;
		$mpFraisPaiements = [];
		if($request->mp_frais_id){
			$frais = MpFrais::find($request->mp_frais_id);					
			$mpFraisPaiements = $this->les_paiements_dun_frais($request->mp_frais_id,$request->ms_classe_id)
															// on filtre uniquement les élève qui n'ont pas un reste à payer
															->filter(function($p,$k){
																return ($p['reste'] != 0 );
															})->groupBy('classe');
		}
		$en_ordre = 'no';
		return $this->addUser($this->v_path.'eleves_non_en_ordre',compact('msClasses','mpFraiss','mpFraisPaiements','frais','en_ordre'));

	}

	public function eleves_en_ordre_tou(Request $request){
		$frais = false;
		$mpFraisPaiements = [];
		if($request->mp_frais_id){
			$frais = MpFrais::find($request->mp_frais_id);					
			$mpFraisPaiements = $this->les_paiements_dun_frais($request->mp_frais_id,$request->ms_classe_id)->groupBy('classe');
		}
		$en_ordre = '';
		return $this->addUser($this->v_path.'eleves_non_en_ordre',compact('msClasses','mpFraiss','mpFraisPaiements','frais','en_ordre'));
	}
	 */
	
    public function les_paiements_dun_frais($id_frais,$id_classe,$voir_en_usd=false){
		$this->id_frais_concerne = $id_frais;
		$id_annee = Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		$msEleves = MsEleve::with([
			'mpFraisPaiementExpetionnels',
			'enfant',
			'statusEnfant',
			'tuteur',
			'msClasse.msPromotion.section',
			'msClasse.mpFraisClasses' => function($query) use($id_annee) {
			  $query->where('ms_annee_scolaire_id', $id_annee);
			},
			'mpFraisPaiements',
			'msClasse.mpFraisClasses.mpFrais'
		])
			->where('ms_classe_id', $id_classe=='-'?'!=':'=' ,$id_classe)
			->where('ms_annee_scolaire_id',$id_annee)	
			->where('ecole_id',$ecole_id)	
			->where('etat','Actif')			
			// on récupère tous les élèves
			->get();
			//dd($msEleves->first());
			// on filtre (faire passer) uniquement les élèves concernés pas le frais
			$msEleves = $msEleves->filter(function($msEleve,$k){
				$frais = $msEleve->msClasse->mpFraisClasses->where('mp_frais_id',$this->id_frais_concerne);
				return count($frais );
			})
			// on sommationne les paiement de chacun en rapport avec le frais, et on retourne un nouvel objet
			->map(function($el,$k)use($voir_en_usd){
				$frais = $el->msClasse->mpFraisClasses->where('mp_frais_id',$this->id_frais_concerne);
														//	dd($frais);
				
				if($voir_en_usd){
                    $taux_usd = $frais->first()->taux;
    				$all_paid = $el->mpFraisPaiements->where('mp_frais_classe_id',$frais->first()->id)->sum('montant_payer')/$taux_usd;
    				if(($frais_ex = $el->mpFraisPaiementExpetionnels->where('mp_frais_classe_id',$frais->first()->id)->first()))
    					$montant_du = $frais_ex->montant_fixer/$taux_usd;
    				else $montant_du = $frais->first()->montant/$taux_usd;
				}
				else{
				   $all_paid = $el->mpFraisPaiements->where('mp_frais_classe_id',$frais->first()->id)->sum('montant_payer');
															//dd($all_paid,$frais->first(),$el->mpFraisPaiements);
    				if(($frais_ex = $el->mpFraisPaiementExpetionnels->where('mp_frais_classe_id',$frais->first()->id)->first()))
    					$montant_du = $frais_ex->montant_fixer;
    				else $montant_du = $frais->first()->montant;
                }
				$insc_tardive=false;
				if($frais->first()->date_butoire >= $el->inscrit_le ){
    				$reste = $montant_du-$all_paid;
    				$taux = $montant_du?round(($all_paid/$montant_du)*100,2):100;
				}
				else{
				    $reste =  0;
				    $all_paid=$montant_du;
				    $taux = 100;
				    $insc_tardive=true;
				} 
				$frais = $frais->first()->MpFrais->frais;
				$enfant = $el->enfant;
				$eleve_id = $el->id;
				$inscription_id = $el->id;
				$tuteur = $el->tuteur;
				$img = $el->mpFraisPaiements;//$el->img;
				$ms_classe_id = $el->ms_classe_id;
				$classe = $el->msClasse->classe; 
				$section = $el->msClasse->msPromotion->section->nom_sec;
				$niveau = $el->msClasse->msPromotion->niveau;
				$promotion = $el->msClasse->msPromotion->promotion;
				$status_enfant = $el->statusEnfant->status??'';
				$status = $el->statusEnfant;
				// nouvell objet retourné
				return compact('inscription_id','img','status_enfant','insc_tardive','eleve_id','enfant','ms_classe_id','classe','niveau','promotion','section','frais','all_paid','montant_du','taux','reste','tuteur','status');
			})
			->sortBy(function($c){
			    $e = $c['enfant'];
			    if(!$e)dd($c);
			    return $e->nom.$e->postnom.$e->prenom; 
			    
			});
			// ->sortBy('classe')
			;
		return($msEleves);
			
	}
				
	public function transferer_les_paiements_dun_frais_a_un_autre(Request $request){
	    $id_frais_source = $request->id_frais_source;
	    $id_frais_destin = $request->id_frais_destin;
	    $id_annee = Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		$mp_frais_id = $request->frais;
		$tab = $date_butoire = $frais = false;
		
		//retrouver tous les frais_classe_id du frais_id source
		$mp_frais_classes = MpFraisClasse::with(['msClasse'])
		        ->where('mp_frais_id',$id_frais_source)->where('ms_annee_scolaire_id', $id_annee)
		        ->whereHas('msClasse',function($q)use($ecole_id){return $q->where('ecole_id',$ecole_id);})
		        ->get();
		       $msg = "";
		// trouver les frais_classe_id destin correspondant au mp_frais_classe_id source, sachant que les deux doivent etre dans la meme
		// classe et le destin doit correspondre au frais_id destin connaissant la classe 
		foreach($mp_frais_classes as $mp_frais_classe){
		    $ms_classe_id = $mp_frais_classe->ms_classe_id;
		    $m_classe_frais_dest = MpFraisClasse::where('ms_classe_id',$ms_classe_id)->where('mp_frais_id',$id_frais_destin)->first();
		    if($m_classe_frais_dest){
		        $mp_frais_classe_id = $m_classe_frais_dest->id;
		        $compte_id = $m_classe_frais_dest->compte;
		        // $compte = $this->trouver_classe_comptable($mp_frais_classe_id, $date );
		        MpFraisPaiement::where('mp_frais_classe_id',$m_classe_frais_dest->id)->update(compact('mp_frais_classe_id','compte_id'));
		    }
		    else {
		        $msg .= "Aucune correspondant trouvée dans la classe : ".$mp_frais_classe->msClasse->classe;
		    }
		}
		dd($msg);
    }
}