<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;

use App\Masomwetu\Sys\SysUserRole;
use App\Masomwetu\Scholar\MsEleve;
use App\Masomwetu\Scholar\MsClasse;
use App\Masomwetu\Disciplinary\AbsEleveAbsent;
use App\Masomwetu\Disciplinary\MdAbsence;
use App\Masomwetu\Disciplinary\MdPresence;
use App\Masomwetu\Disciplinary\MdAbsJour;
use App\Masomwetu\Disciplinary\MdRetard;
use App\Masomwetu\Disciplinary\MotifCommentaire;
use App\Masomwetu\Disciplinary\MdCommentaire;
use App\Masomwetu\Disciplinary\Periode;
use App\Masomwetu\Disciplinary\MdMention;
use App\Config;

// le controlleur qui gère l'entrée à toutes les sous applications
class MDisciplinaryController extends Controller
{
	private $v_path = 'mes_vues.Disciplinary.';
	/* 
	private function addUser($path,$tab=[]){
		$sysUserRole = Config::initUser() ;
		return view($path, array_merge( $tab,compact('sysUserRole')) );
	}
	 */
		
    public function accueil(){
		$today = date("Y-m-d");
		$nbr_com = MdCommentaire::where("coment_date",$today)->count();
		$nbr_abs = MdAbsence::where("absence_date",$today)->count();
		$nbr_ret = MdRetard::where("retard_date",$today)->count();
		
		return $this->addUser($this->v_path.'accueil', compact('nbr_abs','nbr_com','nbr_ret'));
	}
	
	public function create(){
		$action = "retard";
		$ecole_id = Config::getEcoleId();
		$id_annee = Config::getIdAnnee();
		$motifCommentaires = MotifCommentaire::all();
		$msEleves = MsEleve::with(
								'enfant',
								'msClasse.msPromotion')
							->where('ecole_id',$ecole_id)
							->where('etat','Actif')
							->whereHas('msClasse.msPromotion', function($q) use($id_annee){
									$q->where('ms_annee_scolaire_id', $id_annee);
							})->get();
		return $this->addUser($this->v_path.'create',compact('msEleves','motifCommentaires'));
	}
	public function table_choix(){
		$action = "retard";
		$ecole_id = Config::getEcoleId();
		$id_annee = Config::getIdAnnee();
		$motifCommentaires = MotifCommentaire::all();
		$msEleves = MsEleve::with(
								'enfant',
								'msClasse.msPromotion')
							->where('ecole_id',$ecole_id)
							->where('etat','Actif')
							->whereHas('msClasse.msPromotion', function($q) use($id_annee){
									$q->where('ms_annee_scolaire_id', $id_annee);
							})->get();
		return $this->addUser($this->v_path.'table_de_choix',compact('msEleves','motifCommentaires'));
	}
	public function store(Request $request){
		$action = "retard";
		$id_annee = Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		$msEleves = MsEleve::with(
								'enfant',
								'msClasse.msPromotion')
							->where('ecole_id',$ecole_id)
							->where('etat','Actif')
							->whereHas('msClasse.msPromotion', function($q) use($id_annee){
									$q->where('ms_annee_scolaire_id', $id_annee);
							})->get();
		return $this->addUser($this->v_path.'create',compact('msEleves'));
	}
	
	public function actualiser_conduite($ms_eleve_id ,$periode_id){
		$ecole_id = Config::getEcoleId();
		$msEleve = MsEleve::with('mdCommentaires.motifCommentaire','mdAbsences','mdRetards')->find($ms_eleve_id);
		$mdMentions = MdMention::all();
		
		$abs = MotifCommentaire::where("motif","Absence")->first();
		$ret = MotifCommentaire::where("motif","Retard")->first();
		$point_absence = $abs?$abs->point:5;
		$point_retard = $ret?$ret->point:3;
		
		$mdCommentaires = $msEleve->mdCommentaires->groupBy('periode_id');
		$mdAbsences = $msEleve->mdAbsences->groupBy('periode_id');
		$mdRetards = $msEleve->mdRetards->groupBy('periode_id');
		
		$id1 = $periode_id;
		$points = '';$PC = $PA = $PR = 0;
		if($mdCommentaires->has($id1)){
			$PC = $mdCommentaires[$id1]->sum(function($v){ return $v->motifCommentaire->point; });
		}
		if($mdAbsences->has($id1)){
			$PA = $mdAbsences[$id1]->sum(function($v) use($point_absence){ return $v->justif_date?0:$point_absence; });
		}
		if($mdRetards->has($id1)){
			$PR = $mdRetards[$id1]->sum(function($v) use($point_retard){ return $v->justif_date?0:$point_retard; });
		}
		$mention = 100-($PC+$PR+$PA);
		
		$mentions = $mdMentions->filter(function ($v, $key) use($mention){
			return $v->borne_inf <= $mention and $v->borne_sup >= $mention;
		});
		
		if($ment = $mentions->first())
			$mention = $ment->mention;
		else $mention = "$mention/100";
		// $msEleve["cond$periode_id"] = $mention;
		$msEleve->update(["cond$periode_id"=>$mention]);
	}
	
	public function conduite_eleves(Request $request ,$ms_classe_id=0){
		$id_annee = Config::getIdAnnee();
		
		$ecole_id = Config::getEcoleId();
		$ms_classe_id = $request->has('ms_classe_id') ?$request->ms_classe_id : $ms_classe_id;
		$classe = MsClasse::find($ms_classe_id);
		if($classe)
			$msEleves = MsEleve::with('mdCommentaires.motifCommentaire','mdAbsences','mdRetards')
							->where('ecole_id',$ecole_id)->where('ms_classe_id',$ms_classe_id)->get();
		else $msEleves = collect([]);
		$msClasses = MsClasse::with('msPromotion')->where('ecole_id',$ecole_id)->get();
			
		$mdMentions = MdMention::all();
		$abs = MotifCommentaire::where("motif","Absence")->first();
		$ret = MotifCommentaire::where("motif","Retard")->first();
		$point_absence = $abs?$abs->point:5;
		$point_retard = $ret?$ret->point:3;
		$lien_dossier = route('disciplinary.dossier');
		return $this->addUser($this->v_path.'conduite_eleves',compact('lien_dossier','msClasses','msEleves','classe','mdMentions','point_retard','point_absence'));
	}
	
	public function dossier(Request $request ,$ms_eleve_id=0){
		$ecole_id = Config::getEcoleId();
		$ms_eleve_id = $request->has('ms_eleve_id') ?$request->ms_eleve_id : $ms_eleve_id;
		$eleve = $ms_eleve_id;
		
		$msEleve = MsEleve::with('mdCommentaires.motifCommentaire','mdAbsences','mdRetards')
							->where('ecole_id',$ecole_id)->find($ms_eleve_id);
		$msEleve = $msEleve?$msEleve :new MsEleve();
		
		$mdMentions = MdMention::all();
		$abs = MotifCommentaire::where("motif","Absence")->first();
		$ret = MotifCommentaire::where("motif","Retard")->first();
		$point_absence = $abs?$abs->point:5;
		$point_retard = $ret?$ret->point:3;
		$lien_dossier = route('disciplinary.dossier');
		$data = compact('lien_dossier','msEleve','eleve','mdMentions','point_retard','point_absence');
		if($request->has('profile_eleve'))
			return $this->addUser($this->v_path.'_dossier_elevee',$data);
		return $this->addUser($this->v_path.'dossier_elevee',$data);
	}
	
	public function save_retard(Request $request){
		$tab = explode(',',$request->id_eleves);
		$date = $request->retard_date;
		$nbr = $request->nbre_min_retard;
		$j = 1;
		$liste = $rep = '';
		
		if(!$periode_id = Config::getPeriode())
			return ["Activez une période SVP!"];
		
		foreach($tab as $id){
			$el = MsEleve::with('enfant','tuteur')->find($id);
			if($el){
				if($this->saveEleveRetard($id,$periode_id,$date,$nbr)){
					if(($tut = $el->tuteur) and $tut->telephone ){
						$num = $tut->telephone;
						$msg = // "L'enfant ".
						$el->enfant->nom." a été en retard de $nbr min.";
						if($request->send_sms)
							ms_sms($num,$msg);
					}
				}
				$liste .= "$j) ".$el->enfant->nom.' '.$el->enfant->postnom.' '.$el->enfant->prenom." \n\n";
				$j++;
			}
			
		
		}
		return ["RETARD ENREGISTRE POUR:\n\n".$liste];
	}
	public function send_convocation(Request $request){
		// dd($request);
		$j = 1;
		$liste = $rep = '';
		if($request->id_eleves){
			$tab = explode(',',$request->id_eleves);
			foreach($tab as $id){
				$el = MsEleve::with('enfant','tuteur')->find($id);
				if($el){
					if(($tut = $el->tuteur) and $tut->telephone ){
						$num = $tut->telephone;
						$msg = 'Chers parents de '.$el->enfant->nom.',\n '.$request->message;
						ms_sms($num,$msg);
					}
					$liste .= "$j) ".$el->enfant->nom.' '.$el->enfant->postnom.' '.$el->enfant->prenom." \n\n";
					$j++;
				}		
			}		
		}
	}
	public function save_absence(Request $request){
		// dd($request);
		if($request->id_eleves){
			$tab = explode(',',$request->id_eleves);
			$date = $request->date_jour;
			$liste = '';
			$j = 1;
			if(!$periode_id = Config::getPeriode())
				return ["Activez une période SVP!"];
			
			$JRS = explode(" ","Lundi Mardi Mercredi Jeudi Vendredi Samedi Dimanche");
			$n_jr = $JRS[date('N')-1];
			foreach($tab as $id){
				$el = MsEleve::with('enfant','tuteur')->find($id);
				if($el){
					if($this->saveEleveAbs($id,$periode_id,$el->ms_classe_id,$date)){
						if(($tut = $el->tuteur) and $tut->telephone ){
							$num = $tut->telephone;
							$msg = // "Bjr. ".
							$el->enfant->nom." A ETE MARQUE ABSENTE AU COURS, CE $n_jr ".date("d-m, Y",strtotime($date));
							if($request->send_sms)
							ms_sms($num,$msg);
						}
					}
					$liste .= "$j) ".$el->enfant->nom.' '.$el->enfant->postnom.' '.$el->enfant->prenom." \n\n";
					$j++;
				}		
			}		
			$msg = "ABSENCE ENREGISTREE POUR:\n\n".$liste;
		}
		else $msg = 'AUCUN ELEVE CHOISI';
		
		return [$msg];
	}
	
	public function change_state_absences(Request $request){
		// dd($request); 
		$ecole_id = Config::getEcoleId();
		$id_annee = Config::getIdAnnee();
		$msg="";
		if($request->id_eleves){
			$tab = explode(',',$request->id_eleves);
		    $data = ['etat'=>'Actif'];
		    if('DEACTIVER'==$request->action_to_do)
		        $data = ['etat'=>date('Y-m-d')];
		    else if('REACTIVER'==$request->action_to_do)
		        $data = ['etat'=>'Actif'];
		    MsEleve::whereIn('id',$tab)->where('ms_annee_scolaire_id', $id_annee)->where('ecole_id',$ecole_id)->update($data);
	        $nbr = MsEleve::where('etat','!=','Actif')->where('ms_annee_scolaire_id', $id_annee)->where('ecole_id',$ecole_id)->get()->count(); 
			$nbr_t = MsEleve::where('ms_annee_scolaire_id', $id_annee)->where('ecole_id',$ecole_id)->get()->count();
    		$nbr_t -= $nbr;	
			$msg = "OPERATION ENREGISTREE $nbr Abandons ET  $nbr_t Actifs";
		}
		else $msg = 'AUCUN ELEVE CHOISI';
		
		return [$msg];
	}
	
	public function save_commentaire(Request $request){
		$tab = explode(',',$request->id_eleves);
		
		$j = 1;
		$liste = '';
		if(!$periode_id = Config::getPeriode())
			return ["Activez une période SVP!"];
		$tab_sms=[]; 
		foreach($tab as $id){
			$el = MsEleve::with('enfant','tuteur')->find($id); 
			if($el){
				if($com = $this->saveEleveComment($id,$periode_id,$request)){
					if($request->send_sms and ($tut = $el->tuteur) and $tut->telephone ){
						$num = $tut->telephone;
						$msg = // "Boujour ".$tut->nom_tuteur.", VOTRE ENFANT ".
						$el->enfant->nom." A ETE INTERPELE POUR MOTIF DE : ".$com->motifCommentaire->motif." CE ".date("d/m/y");
						
						$tab_sms[$num]=$msg;
					} 
				}
				$liste .= "$j) ".$el->enfant->nom.' '.$el->enfant->postnom.' '.$el->enfant->prenom." \n\n";
				$j++;		
			}
		}
		foreach($tab_sms as $num=>$msg)ms_sms($num,$msg);
		return ["COMMENTAIRE ENREGISTRE POUR:\n\n".$liste];
	}
	
	public function rapport(Request $request){
		
		return $this->rapport_absence($request);
	}

	public function where_absence($ms_classe_id, $date1, $date2){
		$where = $ms_classe_id?" and ms_classe_id in (".implode(',',$ms_classe_id).")":"";
		$where .= $date1?" and date_jour BETWEEN '$date1' AND '$date2' ":" and DATEDIFF(now(),date_jour) <= 20";
		
		return $where;
	}
	// il retourne les trois derniers jours, semaine ou mois auquels les absences ont été prelevees
	public function trouver_periode_absence($where,$jr_se_moi){
		
		$periode = "".($jr_se_moi=="jr"?"date_jour":($jr_se_moi=="se"?"semaine":"mois"));
		$req = " SELECT date_jour, count(*)nbr,semaine,mois FROM `eleves_absents` 
		where 1 $where
		group by $periode order by $periode desc limit 3";
		// dd($req);
		
		return \DB::select($req);
	}
		
	public function trouver_eleves_absents($where,$jr_se_moi,$val){
		$where .= "and ".($jr_se_moi=="jr"?"date_jour='$val' ":($jr_se_moi=="se"?"semaine='$val' ":"mois='$val'"));
		
		$req = " SELECT ms_eleve_id,date_jour,`matricule`, `nom`, `postnom`, `prenom`, `genre`, `classe`, `motif_absence`, `observation`,md_absence_id,justif_date
		FROM `eleves_absents` 
		where 1 $where  
		order by date_jour desc, classe,ms_eleve_id,`nom`, `postnom`, `prenom` desc";
		return \DB::select($req);
		
	}
	
	public function graphique_sem($se){
		$req = "SELECT count(*) nbr,
			CASE DATEDIFF(now(),date_jour)
				 WHEN 0 THEN 'Aujourd\'hui'
				 WHEN 1 THEN 'Hier'
				 WHEN 2 THEN 'Avant Hier'
				 ELSE DAYNAME(date_jour)
			END as jour,
		DAYOFWEEK (date_jour),date_jour, semaine FROM `eleves_absents` group by date_jour HAVING semaine = $se ORDER BY date_jour desc LIMIT 6  ";
		return \DB::select($req);
	}
	
	public function rapport_absence(Request $request){
	    
		$ecole_id = Config::getEcoleId();
		$msClasses = MsClasse::with('msPromotion')->where('ecole_id',$ecole_id)->get();
		//$msClasses = MsClasse::all();
		$where = $this->where_absence($request->ms_classe_id, $request->date1, $request->date2);
		$tabJoursAbs = $this->trouver_periode_absence($where,'jr');
		$tabSemaineAbs = $this->trouver_periode_absence($where,'se');
		$tabMoisAbs = $this->trouver_periode_absence($where,'mois');
		$titre = $periode = "";
		$tabEleveAbs = $grapData = [];
		// ==============================
		$aujourd = date("Y-m-d");
		$hier = (new \DateTime(date('Y-m-d').' - 1 day'))->format('Y-m-d');
		$avanthier = (new \DateTime(date('Y-m-d').' - 2 day'))->format('Y-m-d');
		// ============================================
		if($request->jr)if($request->se){
			$sem = $request->se==date('W')-1?"Semaine en cours":($request->se==(date('W')-2)?"Semaine passee":($request->se==(date('W')-3)?"Semaine anterieure":$request->se));
			$titre = "Eleves absents la $sem";
			$tabEleveAbs = $this->trouver_eleves_absents($where,'se',$request->se);
			$periode = $request->se;
			$grapData = $this->graphique_sem($request->se);
		}
		else if($request->mois){
			$titre = "Eleves absents le $request->mois eme mois";
			$tabEleveAbs = $this->trouver_eleves_absents($where,'mois',$request->mois);
			$periode = $request->mois;
		}
		else {
			$jour = $request->jr==$aujourd?"Aujourd'hui":
					($request->jr==$hier?"Hier":($request->jr==$avanthier?"Avant Hier":" le $request->jr"));
			$titre = "Eleves absents $jour";
			$tabEleveAbs = $this->trouver_eleves_absents($where,'jr',$request->jr);
			$periode = $request->jr;
		}
		
		
		$sc = $this->calculer_periode_abs();
		$tentativeAbandon = $this->eleveAbandon($sc);
		$nbrJrAbs = $sc['count'];
		
		$date1 = $request->date1??(new \DateTime(date('Y-m-d').' - 20 day'))->format('Y-m-d');
		$date2 = $request->date2??date("Y-m-d");
		$ms_classe_id = $request->ms_classe_id;
		
		$mdcommentaires = Mdcommentaire::with('msEleve.enfant','msEleve.msClasse.msPromotion.section')->where('coment_date',date('Y-m-d'))->get();
		
		return $this->addUser($this->v_path.'rapport',compact('msClasses','nbrJrAbs','tentativeAbandon','titre','grapData','tabEleveAbs','tabJoursAbs','tabSemaineAbs','tabMoisAbs','ms_classe_id','date1','date2','aujourd','hier','avanthier','periode','mdcommentaires'));
	}

	public function rapport_presence(Request $request){
	    
		$date = $request->date??date("Y-m-d");
		$ms_classe_id = $request->ms_classe_id;
		
		$id_annee = Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		$msClasses = MsClasse::with('msPromotion')->where('ecole_id',$ecole_id)->get();
		
		
		$les_presences = MsEleve::with(['msClasse','enfant','mdPresences'=>function($e)use($date){
		    return $e->where('presence_date',$date);
		}])->where('ecole_id',$ecole_id)->where('ms_annee_scolaire_id', $id_annee);
		
		if($ms_classe_id){
		    $les_presences = $les_presences->whereHas('msClasse', function($q) use($ms_classe_id){
									$q->whereIn('ms_classe_id',$ms_classe_id);
							});
		}
		$les_presences = $les_presences->get()->groupBy(function($k,$e){
		    return $k->msClasse->classe;
		})->sortKeys();
		
		return $this->addUser($this->v_path.'rapport_presence',compact('les_presences','date','msClasses'));
	}

	private function saveJoursAbs($id_classe,$date){
		
		return MdAbsJour::firstOrCreate(['date_jour'=>$date,'ms_classe_id'=>$id_classe], ['commentaire'=>'RAS']);
	}
	
	private function saveEleveAbs($id_eleve,$periode_id,$id_classe,$date){
		$jr = $this->saveJoursAbs($id_classe,$date);
		
		$re = MdAbsence::firstOrCreate(['ms_eleve_id'=>$id_eleve,'absence_date'=>$date,'md_abs_jour_id'=>$jr->id],['periode_id'=>$periode_id,'created_at'=>date('Y-m-d')]);
		$this->actualiser_conduite($id_eleve,$periode_id);
		return 	$re;
	}
	
	private function saveEleveRetard($id_eleve,$periode_id,$date,$nbr){
		
		$r = MdRetard::firstOrCreate(['ms_eleve_id'=>$id_eleve,'retard_date'=>$date],['periode_id'=>$periode_id,'nbre_min_retard'=>$nbr]);
		if($r->nbre_min_retard != $nbr){
			$r->nbre_min_retard = $nbr;
			$r->save();
		}
		$this->actualiser_conduite($id_eleve,$periode_id);
		return $r;
	}
	
	private function saveEleveComment($id_eleve,$periode_id,$request){
		$datas = [
			'periode_id'=>$periode_id,
			'ms_eleve_id'=>$id_eleve,
			'coment_date'=>$request->coment_date,
			'importance'=>$request->importace,
			'motif_commentaire_id'=>$request->motif_commentaire_id,
			'detail'=>$request->detail,
		];
        $c = MdCommentaire::create($datas);
		$this->actualiser_conduite($id_eleve,$periode_id);
		return $c;
	}
	
	public function eleveAbandon($sc){		
		
		$req = "
		SELECT matricule, nom, postnom, prenom, genre, classe
		FROM `eleves_absents`
		GROUP BY ms_eleve_id 
		HAVING count(*) = $sc[count] AND SUM(DATEDIFF(now(),date_jour)) = $sc[sum] 
		ORDER BY nom, postnom, prenom";
		// dd($req);
		return \DB::select($req);
	}
	
	private function calculer_periode_abs(){
		$N = date('N');
		$N = ($N==7||$N==6)?5:$N;
		$periode = '';
		$j = 0;$sum=0;
		for($i=$N;$i!=0;$i--,$j++){
			$periode = "$j-".$periode;
			$sum+=$j;			
		}
		
		for($i=$j+2;$i!=$j+7;$i++){
			$periode = "$i-".$periode;
			$sum+=$i;
		}
		// dd($periode);
		return ['sum'=>$sum,'count'=>$N+5];//$periode;
	}
	
	public function marquer_presence_eleve($ms_eleve_id,$return_data=false){
		$msg = null;
		$retard = null;
		$heure_prevue = Config::getParamVal('HEURE-ARRIVEE-ELEVE');// "08:00:00";
		$heure_arrivee = date('H:i:s');
		$heure_actuelle = date("H:i:s");
		$date=date('Y-m-d');
		
		if(!$periode_id = Config::getPeriode())
			return ["Activez une période SVP!"];
		
		if(!$heure_prevue)
			return ["INDIQUER LA VALEUR DE HEURE-ARRIVEE-ELEVE SVP"];
		$min_ret = $msg ='';
		$action = "ENTREE";
		$presence = MdPresence::firstOrCreate(['presence_date'=>$date,'periode_id'=>$periode_id,'ms_eleve_id'=>$ms_eleve_id], ['arrivee_a'=>$heure_actuelle]);
		if(!$presence->wasRecentlyCreated ){
		    if($presence->sortie_a){
		        $msg ='ERREUR! SORTIE DEJA POINTEE à '.$presence->sortie_a;
		        $action='ERREUR';
		    }
		    else $presence->update(['sortie_a'=>$heure_actuelle]);
		    $action = "SORTIE";
	    }
	    else{
	        $min_ret = diff_times($heure_prevue,$heure_actuelle);
	        $presence->update(['sortie_a'=>$heure_actuelle,'nbre_min_retard'=>$min_ret]);
	    }
	    
	    if($min_ret and $min_ret[0]=='-')$en_retard=true;
	    else $en_retard=false;
	    
		$num = $presence->msEleve->tuteur?$presence->msEleve->tuteur->telephone:false;
		$classe = $presence->msEleve->msClasse->classe;
		$img = $presence->msEleve->img;
		$nom = $presence->msEleve->enfant->nom.' '.$presence->msEleve->enfant->postnom.' '.$presence->msEleve->enfant->prenom;
		if( $action != "ERREUR"){
    		if($en_retard){
    			$min_ret = substr($min_ret,1);
    			$msg = "$nom A ETE EN RETARD DE $min_ret";
    			$retard = true;
    			$this->saveEleveRetard($ms_eleve_id,$periode_id,$date,$min_ret);
    		}
    		else $msg = "Presence deja marquee!";
    		
    		if($num)
    		    ms_sms($num,$msg);
    		
    	}
    	
		$datas = compact('nom','img','heure_actuelle','min_ret','retard','classe','msg','action','en_retard');
		if($return_data)
		    return $datas;
		return view('result_for_eleve_scan_presence', $datas );
	}
	
	public function marquer_les_absences(Request $request){
		$date = $request->date;
		$ms_classe_id = $request->ms_classe_id;
		$send_sms = $request->send_sms;
		$ids = implode(',',$ms_classe_id);
		$req = "select e.id,e.ms_classe_id, ef.nom, ef.postnom, ef.prenom, t.telephone
		from ms_eleves e
		inner join enfants ef on ef.id = e.enfant_id
		inner join ms_inscriptions i on i.id = e.ms_inscription_id
		left join tuteurs t on t.id=i.tuteur_id
		left join md_presences p on e.id=p.ms_eleve_id and p.presence_date = '$date' 
		where e.ms_classe_id in ($ids) and p.id is null
		order by t.telephone
		";
		$tab = \DB::select($req);
		$message = "Enregistrement effecté avec succès";
		if(!$periode_id = Config::getPeriode())
			$message = "Activez une période SVP!";
		
		else {
			// dd($tab);
			foreach($tab as $lg){
				$this->saveEleveAbs($lg->id,$periode_id,$lg->ms_classe_id,$date);
				$num = $lg->telephone;
				$msg = // "Bonjour. ".
				$lg->nom." ".$lg->prenom." a été marqué absent au cours, ce ".date("d-m, Y",strtotime($date));
				if($send_sms)
					ms_sms($num,$msg);
			}
		}
		
		my_flash($message);
		return redirect()->back();
	}
}

