<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Enfant;
use App\Tuteur;
use App\MsEleve;
use App\MpFraisPaiement;
use App\MsInscription;
use Validator,Rule;
class InscrireController extends Controller
{			
	public function inscrire(Request $request)
    {
				$data = AjaxValidator::request_data(
					['matricule','nom','postnom','prenom','genre','datenaiss','lieunaiss',
					'montant','ms_promotion_id','nom_tuteur','telephone','adresse','id_enfant','id_tuteur'],
					$request
				);
				$enfant_existe = $request->has('id_enfant');// and !empty($request->id_enfant) and $request->id_enfant!== null;
				$tuteur_existe = $request->has('id_tuteur') and !empty($request->id_tuteur)
				and $request->id_tuteur>0
				and $request->id_tuteur!= 'null'
				and $request->id_tuteur!= ''
				and !is_null($request->id_tuteur);
				
				// dd($enfant_existe,$tuteur_existe,$request);
				if( !$enfant_existe ){
					$rules = [
						'matricule'=>'required|unique:enfants',
						'nom'=>'required|min:3',
						'postnom'=>'required|min:3',
						'prenom'=>'required|min:3',
						'montant'=>'required|numeric',
						'ms_promotion_id'=>'required|numeric',
					];
				}
				else $rules['id_enfant']='required|numeric';
				
				// les règles de validation sur le tuteur sont optionnelles
				if( !$tuteur_existe ){
					$rules['nom_tuteur']='required|min:3';
					$rules['telephone']='numeric|unique:tuteurs';
					$rules['adresse']='required|min:3';
				}
				else $rules['id_tuteur']='required|numeric';
				
				// on exécute les régles de validation sur les données
				$result = AjaxValidator::validate($data,$rules);
				if($result!==true)
					return $result;
				
				// si toutes les regles réussissent
				try {
					\DB::beginTransaction();
						// database queries here
						if( !$enfant_existe){
							$enfant = Enfant::create([
							'matricule'=>$request->matricule
							,'nom'=>$request->nom
							,'postnom'=>$request->postnom
							,'prenom'=>$request->prenom
							,'genre'=>$request->genre
							,'datenaiss'=>$request->datenaiss
							,'lieunaiss'=>$request->lieunaiss
							,]);
						}
						else $enfant = Enfant::find($request->id_enfant);
						
						// enregistrement du tuteur
						if( !$tuteur_existe ){
							$tuteur = Tuteur::create(['nom_tuteur'=>$request->nom_tuteur
							,'telephone'=>$request->telephone
							,'adresse'=>$request->adresse
							,]);
						}
						else $tuteur = Tuteur::find($request->id_tuteur);
						
						
						$inscription = MsInscription::create([
						'enfant_id'=>$enfant->id
						,'ms_promotion_id'=>$request->ms_promotion_id
						,'inscrit_le'=>date("Y-m-d")
						,'classer'=>false
						,'tuteur_id'=>$tuteur->id
						,'montant'=>$request->montant
						,]);
						
					\DB::commit();
				} catch (\PDOException $e) {
						// Woopsy
						\DB::rollBack();
						$result = 'fail';
						$message = "Erreur transaction!";
						// dd($e);
						return compact('result','message','e');
				}
						
				flash("Enregistrement effecté avec succès");
				$result = 'success';
				$token = csrf_token();
				return compact('result','token','eleve','tuteur','enfant','inscription');
				//redirect()->route('enfants.index', compact() );
        //
    }
		
}
